/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.trait.miner.LargeMinerLogic;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.misc.FluidTransferList;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.tterrag.registrate.util.entry.BlockEntry;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeMinerMachine
extends WorkableElectricMultiblockMachine
implements IMiner,
IControllable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeMinerMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    public static final int CHUNK_LENGTH = 16;
    private final int tier;
    @Nullable
    protected EnergyContainerList energyContainer;
    @Nullable
    protected FluidTransferList inputFluidInventory;
    private final int drillingFluidConsumePerTick;

    public LargeMinerMachine(IMachineBlockEntity holder, int tier, int speed, int maximumChunkDiameter, int fortune, int drillingFluidConsumePerTick) {
        super(holder, fortune, speed, maximumChunkDiameter);
        this.tier = tier;
        this.drillingFluidConsumePerTick = drillingFluidConsumePerTick;
    }

    @Override
    @NotNull
    protected RecipeLogic createRecipeLogic(Object ... args) {
        Object object = args[args.length - 3];
        if (object instanceof Integer) {
            Integer fortune = (Integer)object;
            object = args[args.length - 2];
            if (object instanceof Integer) {
                Integer speed = (Integer)object;
                object = args[args.length - 1];
                if (object instanceof Integer) {
                    Integer maxRadius = (Integer)object;
                    return new LargeMinerLogic(this, fortune, speed, maxRadius * 16 / 2);
                }
            }
        }
        throw new IllegalArgumentException("MinerMachine need args [inventorySize, fortune, speed, maximumRadius] for initialization");
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public LargeMinerLogic getRecipeLogic() {
        return (LargeMinerLogic)super.getRecipeLogic();
    }

    public static Material getMaterial(int tier) {
        if (tier == 4) {
            return GTMaterials.Steel;
        }
        if (tier == 5) {
            return GTMaterials.Titanium;
        }
        if (tier == 6) {
            return GTMaterials.TungstenSteel;
        }
        return GTMaterials.Steel;
    }

    public static Block getCasingState(int tier) {
        return (Block)((BlockEntry)GTBlocks.MATERIALS_TO_CASINGS.get((Object)LargeMinerMachine.getMaterial(tier))).get();
    }

    @Override
    public long getMaxVoltage() {
        return GTValues.V[this.getEnergyTier()];
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.initializeAbilities();
    }

    private void initializeAbilities() {
        ArrayList<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
        ArrayList<IFluidTransfer> fluidTanks = new ArrayList<IFluidTransfer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH);
            if (io == IO.NONE) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                IO handlerIO;
                if (io != IO.BOTH && handler.getHandlerIO() != IO.BOTH && io != handler.getHandlerIO()) continue;
                IO iO = handlerIO = io == IO.BOTH ? handler.getHandlerIO() : io;
                if (handlerIO == IO.IN && handler.getCapability() == EURecipeCapability.CAP && handler instanceof IEnergyContainer) {
                    IEnergyContainer container = (IEnergyContainer)((Object)handler);
                    energyContainers.add(container);
                    continue;
                }
                if (handlerIO != IO.IN || handler.getCapability() != FluidRecipeCapability.CAP || !(handler instanceof IFluidTransfer)) continue;
                IFluidTransfer fluidTransfer = (IFluidTransfer)handler;
                fluidTanks.add(fluidTransfer);
            }
        }
        this.energyContainer = new EnergyContainerList(energyContainers);
        this.inputFluidInventory = new FluidTransferList(fluidTanks);
        this.getRecipeLogic().setVoltageTier(GTUtil.getTierByVoltage(this.energyContainer.getInputVoltage()));
        this.getRecipeLogic().setOverclockAmount(Math.max(1, GTUtil.getTierByVoltage(this.energyContainer.getInputVoltage()) - this.tier));
        this.getRecipeLogic().initPos(this.getPos(), this.getRecipeLogic().getCurrentRadius());
    }

    public int getEnergyTier() {
        if (this.energyContainer == null) {
            return this.tier;
        }
        return Math.min(this.tier + 1, Math.max(this.tier, GTUtil.getFloorTierByVoltage(this.energyContainer.getInputVoltage())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean drainInput(boolean simulate) {
        if (this.energyContainer == null || this.energyContainer.getEnergyStored() <= 0L) return false;
        long energyToDrain = GTValues.VA[this.getEnergyTier()];
        long resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy < 0L || resultEnergy > this.energyContainer.getEnergyCapacity()) return false;
        if (!simulate) {
            this.energyContainer.changeEnergy(-energyToDrain);
        }
        if (this.inputFluidInventory == null || this.inputFluidInventory.transfers.length <= 0) return true;
        FluidStack drillingFluid = GTMaterials.DrillingFluid.getFluid((long)this.drillingFluidConsumePerTick * (long)this.getRecipeLogic().getOverclockAmount());
        FluidStack fluidStack = this.inputFluidInventory.getFluidInTank(0);
        if (fluidStack == FluidStack.empty() || !fluidStack.isFluidEqual(GTMaterials.DrillingFluid.getFluid(1L)) || fluidStack.getAmount() < drillingFluid.getAmount()) return false;
        if (simulate) return true;
        GTTransferUtils.drainFluidAccountNotifiableList((IFluidTransfer)this.inputFluidInventory, drillingFluid, false);
        return true;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            int workingAreaChunks = this.getRecipeLogic().getCurrentRadius() * 2 / 16;
            int workingArea = IMiner.getWorkingArea(this.getRecipeLogic().getCurrentRadius());
            textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.startx", (Object[])new Object[]{this.getRecipeLogic().getX() == Integer.MAX_VALUE ? 0 : this.getRecipeLogic().getX()}));
            textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.starty", (Object[])new Object[]{this.getRecipeLogic().getY() == Integer.MAX_VALUE ? 0 : this.getRecipeLogic().getY()}));
            textList.add((Component)Component.m_237110_((String)"gtceu.machine.miner.startz", (Object[])new Object[]{this.getRecipeLogic().getZ() == Integer.MAX_VALUE ? 0 : this.getRecipeLogic().getZ()}));
            textList.add((Component)Component.m_237115_((String)"gtceu.universal.tooltip.silk_touch").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[").m_7220_((Component)(this.getRecipeLogic().isSilkTouchMode() ? Component.m_237115_((String)"gtceu.creative.activity.on") : Component.m_237115_((String)"gtceu.creative.activity.off"))).m_7220_((Component)Component.m_237113_((String)"]")), (String)"silk_touch")));
            textList.add((Component)Component.m_237115_((String)"gtceu.universal.tooltip.chunk_mode").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[").m_7220_((Component)(this.getRecipeLogic().isChunkMode() ? Component.m_237115_((String)"gtceu.creative.activity.on") : Component.m_237115_((String)"gtceu.creative.activity.off"))).m_7220_((Component)Component.m_237113_((String)"]")), (String)"chunk_mode")));
            if (this.getRecipeLogic().isChunkMode()) {
                textList.add((Component)Component.m_237110_((String)"gtceu.universal.tooltip.working_area_chunks", (Object[])new Object[]{workingAreaChunks, workingAreaChunks}));
            } else {
                textList.add((Component)Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
            }
            if (this.getRecipeLogic().isDone()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.done").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
            }
        }
    }

    @Override
    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            if (componentData.equals("chunk_mode")) {
                this.getRecipeLogic().setChunkMode(!this.getRecipeLogic().isChunkMode());
            }
            if (componentData.equals("silk_touch")) {
                this.getRecipeLogic().setSilkTouchMode(!this.getRecipeLogic().isSilkTouchMode());
            }
        }
    }

    @Override
    public InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction facing, BlockHitResult hitResult) {
        if (this.isRemote() || !this.isFormed()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isActive()) {
            int currentRadius = this.getRecipeLogic().getCurrentRadius();
            if (this.getRecipeLogic().isChunkMode()) {
                if (currentRadius - 16 <= 0) {
                    this.getRecipeLogic().setCurrentRadius(this.getRecipeLogic().getMaximumRadius());
                } else {
                    this.getRecipeLogic().setCurrentRadius(currentRadius - 16);
                }
                int workingAreaChunks = this.getRecipeLogic().getCurrentRadius() * 2 / 16;
                playerIn.m_213846_((Component)Component.m_237110_((String)"gtceu.universal.tooltip.working_area_chunks", (Object[])new Object[]{workingAreaChunks, workingAreaChunks}));
            } else {
                if (currentRadius - 8 <= 0) {
                    this.getRecipeLogic().setCurrentRadius(this.getRecipeLogic().getMaximumRadius());
                } else {
                    this.getRecipeLogic().setCurrentRadius(currentRadius - 8);
                }
                int workingArea = IMiner.getWorkingArea(this.getRecipeLogic().getCurrentRadius());
                playerIn.m_213846_((Component)Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
            }
            this.getRecipeLogic().resetArea();
        } else {
            playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.errorradius"));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

