/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class CreativeTankMachine
extends QuantumTankMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CreativeTankMachine.class, QuantumTankMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DropSaved
    private int mBPerCycle = 1;
    @Persisted
    @DropSaved
    private int ticksPerCycle = 1;

    public CreativeTankMachine(IMachineBlockEntity holder) {
        super(holder, 14, -1L, new Object[0]);
    }

    @Override
    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 1000L, IO.BOTH);
    }

    @Override
    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingFluids();
        if (this.isAutoOutputFluids() && !this.cache.isEmpty() && outputFacing != null && FluidTransferHelper.getFluidTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacing), (Direction)outputFacing.m_122424_()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    @Override
    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % (long)this.ticksPerCycle == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.updateFluidTick();
            }
            this.updateAutoOutputSubscription();
        }
    }

    public WidgetGroup createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 131);
        group.addWidget((Widget)new PhantomFluidWidget((IFluidStorage)this.cache.storages[0], 36, 6, 18, 18).setShowAmount(false).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        group.addWidget((Widget)new LabelWidget(7, 9, "gtceu.creative.tank.fluid"));
        group.addWidget((Widget)new ImageWidget(7, 45, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 47, 152, 10, () -> String.valueOf(this.mBPerCycle), value -> {
            if (!value.isEmpty()) {
                this.mBPerCycle = Integer.parseInt(value);
            }
        }).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 28, "gtceu.creative.tank.mbpc"));
        group.addWidget((Widget)new ImageWidget(7, 82, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 84, 152, 10, () -> String.valueOf(this.ticksPerCycle), value -> {
            if (!value.isEmpty()) {
                this.ticksPerCycle = Integer.parseInt(value);
            }
        }).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 65, "gtceu.creative.tank.tpc"));
        group.addWidget((Widget)new SwitchWidget(7, 101, 162, 20, (clickData, value) -> this.setWorkingEnabled((boolean)value)).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.off")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.on")})).setPressed(this.isWorkingEnabled()));
        return group;
    }

    public void updateFluidTick() {
        if (this.ticksPerCycle == 0 || this.getOffsetTimer() % (long)this.ticksPerCycle != 0L || this.cache.storages[0].getFluid().isEmpty() || this.getLevel().f_46443_ || !this.isWorkingEnabled()) {
            return;
        }
        IFluidTransfer transfer = FluidTransferHelper.getFluidTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(this.getOutputFacingFluids()), (Direction)this.getOutputFacingFluids().m_122424_());
        if (transfer != null) {
            FluidStack stack = this.cache.storages[0].getFluid().copy();
            stack.setAmount((long)this.mBPerCycle);
            long canInsertAmount = transfer.fill(stack, true);
            stack.setAmount(Math.min((long)this.mBPerCycle, canInsertAmount));
            transfer.fill(stack, false);
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

