/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.CleanroomMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class CleanroomLogic
extends RecipeLogic
implements IWorkable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CleanroomLogic.class, RecipeLogic.MANAGED_FIELD_HOLDER);
    public static final int BASE_CLEAN_AMOUNT = 5;
    @Nullable
    private IMaintenanceMachine maintenanceMachine;
    @Nullable
    private IEnergyContainer energyContainer;
    @Persisted
    private boolean isActiveAndNeedsUpdate;

    public CleanroomLogic(CleanroomMachine machine) {
        super(machine);
    }

    @Override
    public CleanroomMachine getMachine() {
        return (CleanroomMachine)this.machine;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void serverTick() {
        if (!this.isSuspend() && this.duration > 0) {
            if (this.maintenanceMachine == null || this.maintenanceMachine.getNumMaintenanceProblems() < 6) {
                if (!this.consumeEnergy()) {
                    if (this.progress > 0 && this.machine.dampingWhenWaiting()) {
                        this.progress = ConfigHolder.INSTANCE.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progress - 2);
                    }
                    if (this.machine.self().getOffsetTimer() % (long)this.duration == 0L) {
                        this.adjustCleanAmount(true);
                    }
                    this.setWaiting((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_in").m_130946_(": ").m_7220_(EURecipeCapability.CAP.getName()));
                    return;
                }
                if (this.progress++ < this.getMaxProgress()) {
                    this.machine.onWorking();
                    return;
                }
                this.progress = 0;
                this.machine.beforeWorking();
                this.adjustCleanAmount(false);
                this.setStatus(RecipeLogic.Status.WORKING);
            } else {
                if (this.progress > 0) {
                    --this.progress;
                }
                if (this.machine.self().getOffsetTimer() % (long)this.duration == 0L) {
                    this.adjustCleanAmount(true);
                }
                this.setStatus(RecipeLogic.Status.IDLE);
                this.machine.afterWorking();
            }
        }
        if (this.isSuspend() && this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }

    protected void adjustCleanAmount(boolean declined) {
        int amountToClean = 5 * (this.getTierDifference() + 1);
        if (declined) {
            amountToClean *= -1;
        }
        if (this.maintenanceMachine != null) {
            amountToClean -= this.maintenanceMachine.getNumMaintenanceProblems();
        }
        this.getMachine().adjustCleanAmount(amountToClean);
    }

    protected boolean consumeEnergy() {
        long resultEnergy;
        long energyToDrain;
        CleanroomMachine cleanroom = this.getMachine();
        long l = energyToDrain = cleanroom.isClean() ? (long)Math.min(4.0, Math.pow(4.0, cleanroom.getTier())) : (long)GTValues.VA[cleanroom.getTier()];
        if (this.energyContainer != null && (resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain) >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            this.energyContainer.removeEnergy(energyToDrain);
            return true;
        }
        return false;
    }

    protected int getTierDifference() {
        int minEnergyTier = 1;
        return this.getMachine().getTier() - minEnergyTier;
    }

    public void setDuration(int max) {
        this.duration = max;
    }

    public void setMaintenanceMachine(@Nullable IMaintenanceMachine maintenanceMachine) {
        this.maintenanceMachine = maintenanceMachine;
    }

    public void setEnergyContainer(@Nullable IEnergyContainer energyContainer) {
        this.energyContainer = energyContainer;
    }

    public boolean isActiveAndNeedsUpdate() {
        return this.isActiveAndNeedsUpdate;
    }

    public void setActiveAndNeedsUpdate(boolean isActiveAndNeedsUpdate) {
        this.isActiveAndNeedsUpdate = isActiveAndNeedsUpdate;
    }
}

