/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.pipenet.PipeNetWalker;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.cover.ShutterCover;
import com.gregtechceu.gtceu.common.cover.data.ItemFilterMode;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.gregtechceu.gtceu.common.pipelike.item.ItemRoutePath;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemNetWalker
extends PipeNetWalker<ItemPipeBlockEntity, ItemPipeProperties, ItemPipeNet> {
    private ItemPipeProperties minProperties;
    private final List<ItemRoutePath> inventories;
    private final List<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
    private final EnumMap<Direction, List<Predicate<ItemStack>>> nextFilters = new EnumMap(Direction.class);
    private BlockPos sourcePipe;
    private Direction facingToHandler;

    public static List<ItemRoutePath> createNetData(ItemPipeNet pipeNet, BlockPos sourcePipe, Direction sourceFacing) {
        if (!(pipeNet.getLevel().m_7702_(sourcePipe) instanceof ItemPipeBlockEntity)) {
            return null;
        }
        try {
            ItemNetWalker walker = new ItemNetWalker(pipeNet, sourcePipe, 1, new ArrayList<ItemRoutePath>(), null);
            walker.sourcePipe = sourcePipe;
            walker.facingToHandler = sourceFacing;
            walker.traversePipeNet();
            return walker.inventories;
        }
        catch (Exception e) {
            GTCEu.LOGGER.error("error while create net data for ItemPipeNet", (Throwable)e);
            return null;
        }
    }

    protected ItemNetWalker(ItemPipeNet world, BlockPos sourcePipe, int distance, List<ItemRoutePath> inventories, ItemPipeProperties properties) {
        super(world, sourcePipe, distance);
        this.inventories = inventories;
        this.minProperties = properties;
    }

    @Override
    @NotNull
    protected PipeNetWalker<ItemPipeBlockEntity, ItemPipeProperties, ItemPipeNet> createSubWalker(ItemPipeNet pipeNet, Direction facingToNextPos, BlockPos nextPos, int walkedBlocks) {
        ItemNetWalker walker = new ItemNetWalker(pipeNet, nextPos, walkedBlocks, this.inventories, this.minProperties);
        walker.facingToHandler = this.facingToHandler;
        walker.sourcePipe = this.sourcePipe;
        walker.filters.addAll(this.filters);
        List<Predicate<ItemStack>> moreFilters = this.nextFilters.get(facingToNextPos);
        if (moreFilters != null && !moreFilters.isEmpty()) {
            walker.filters.addAll(moreFilters);
        }
        return walker;
    }

    @Override
    protected Class<ItemPipeBlockEntity> getBasePipeClass() {
        return ItemPipeBlockEntity.class;
    }

    @Override
    protected void checkPipe(ItemPipeBlockEntity pipeTile, BlockPos pos) {
        for (List<Predicate<ItemStack>> filters : this.nextFilters.values()) {
            if (filters.isEmpty()) continue;
            this.filters.addAll(filters);
        }
        this.nextFilters.clear();
        ItemPipeProperties pipeProperties = (ItemPipeProperties)pipeTile.getNodeData();
        this.minProperties = this.minProperties == null ? pipeProperties : new ItemPipeProperties(this.minProperties.getPriority() + pipeProperties.getPriority(), Math.min(this.minProperties.getTransferRate(), pipeProperties.getTransferRate()));
    }

    @Override
    protected void checkNeighbour(ItemPipeBlockEntity pipeTile, BlockPos pipePos, Direction faceToNeighbour, @Nullable BlockEntity neighbourTile) {
        if (neighbourTile == null || pipePos.equals((Object)this.sourcePipe) && faceToNeighbour == this.facingToHandler) {
            return;
        }
        LazyOptional handler = neighbourTile.getCapability(ForgeCapabilities.ITEM_HANDLER, faceToNeighbour.m_122424_());
        if (handler.isPresent()) {
            ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>(this.filters);
            List<Predicate<ItemStack>> moreFilters = this.nextFilters.get(faceToNeighbour);
            if (moreFilters != null && !moreFilters.isEmpty()) {
                filters.addAll(moreFilters);
            }
            this.inventories.add(new ItemRoutePath(pipeTile, faceToNeighbour, this.getWalkedBlocks(), this.minProperties, filters));
        }
    }

    @Override
    protected boolean isValidPipe(ItemPipeBlockEntity currentPipe, ItemPipeBlockEntity neighbourPipe, BlockPos pipePos, Direction faceToNeighbour) {
        ItemFilterCover itemFilterCover;
        ShutterCover shutter;
        CoverBehavior thisCover = currentPipe.getCoverContainer().getCoverAtSide(faceToNeighbour);
        CoverBehavior neighbourCover = neighbourPipe.getCoverContainer().getCoverAtSide(faceToNeighbour.m_122424_());
        ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
        if (thisCover instanceof ShutterCover) {
            shutter = (ShutterCover)thisCover;
            filters.add(stack -> !shutter.isWorkingEnabled());
        } else if (thisCover instanceof ItemFilterCover && (itemFilterCover = (ItemFilterCover)thisCover).getFilterMode() != ItemFilterMode.FILTER_INSERT) {
            filters.add(itemFilterCover.getItemFilter());
        }
        if (neighbourCover instanceof ShutterCover) {
            shutter = (ShutterCover)neighbourCover;
            filters.add(stack -> !shutter.isWorkingEnabled());
        } else if (neighbourCover instanceof ItemFilterCover && (itemFilterCover = (ItemFilterCover)neighbourCover).getFilterMode() != ItemFilterMode.FILTER_EXTRACT) {
            filters.add(itemFilterCover.getItemFilter());
        }
        if (!filters.isEmpty()) {
            this.nextFilters.put(faceToNeighbour, filters);
        }
        return true;
    }
}

