/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class BiomeCondition
extends RecipeCondition {
    public static final BiomeCondition INSTANCE = new BiomeCondition();
    private ResourceLocation biome = new ResourceLocation("dummy");

    public BiomeCondition(ResourceLocation biome) {
        this.biome = biome;
    }

    @Override
    public String getType() {
        return "biome";
    }

    @Override
    public boolean isOr() {
        return true;
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.biome.tooltip", (Object[])new Object[]{LocalizationUtils.format((String)"biome.%s.%s", (Object[])new Object[]{this.biome.m_135827_(), this.biome.m_135815_()})});
    }

    public ResourceLocation getBiome() {
        return this.biome;
    }

    @Override
    public boolean test(@Nonnull GTRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Level level = recipeLogic.machine.self().getLevel();
        if (level == null) {
            return false;
        }
        Holder biome = level.m_204166_(recipeLogic.machine.self().getPos());
        return biome.m_203373_(this.biome);
    }

    @Override
    public RecipeCondition createTemplate() {
        return new BiomeCondition();
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("biome", this.biome.toString());
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.biome = new ResourceLocation(GsonHelper.m_13851_((JsonObject)config, (String)"biome", (String)"dummy"));
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.biome = new ResourceLocation(buf.m_130277_());
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130070_(this.biome.toString());
    }

    public BiomeCondition() {
    }
}

