/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.worldgen;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.common.data.GTPlacerTypes;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RubberTrunkPlacer
extends TrunkPlacer {
    public static final Codec<RubberTrunkPlacer> CODEC = RecordCodecBuilder.create(p_70206_ -> RubberTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)p_70206_).apply((Applicative)p_70206_, RubberTrunkPlacer::new));

    public RubberTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return GTPlacerTypes.RUBBER_TRUNK;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BlockPos blockpos = pos.m_7495_();
        RubberTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockpos, (TreeConfiguration)config);
        RubberTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockpos.m_122029_(), (TreeConfiguration)config);
        RubberTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockpos.m_122019_(), (TreeConfiguration)config);
        RubberTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockpos.m_122019_().m_122029_(), (TreeConfiguration)config);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        --freeTreeHeight;
        for (int i = 0; i < freeTreeHeight; ++i) {
            this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 0);
            if (i < freeTreeHeight - 1) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, -1);
            }
            if (i == 0 || i == freeTreeHeight - 6) {
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 1, i, -1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, i, 1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -1, i, -1);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 2, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, -2, i, 0);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, 2);
                this.placeLogIfFreeWithOffset(level, blockSetter, random, mutableBlockPos, config, pos, 0, i, -2);
            }
            if (i != 1 && i != freeTreeHeight - 7) continue;
            this.placeLogIfFreeWithOffsetAndChance(0.33f, level, blockSetter, random, mutableBlockPos, config, pos, 1, i, 1);
            this.placeLogIfFreeWithOffsetAndChance(0.33f, level, blockSetter, random, mutableBlockPos, config, pos, 1, i, -1);
            this.placeLogIfFreeWithOffsetAndChance(0.33f, level, blockSetter, random, mutableBlockPos, config, pos, -1, i, 1);
            this.placeLogIfFreeWithOffsetAndChance(0.33f, level, blockSetter, random, mutableBlockPos, config, pos, -1, i, -1);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.m_6630_(freeTreeHeight), 0, false));
    }

    private void placeLogIfFreeWithOffset(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos.MutableBlockPos pos, TreeConfiguration config, BlockPos pOffsetPos, int pOffsetX, int pOffsetY, int pOffsetZ) {
        pos.m_122154_((Vec3i)pOffsetPos, pOffsetX, pOffsetY, pOffsetZ);
        this.m_226163_(level, blockSetter, random, pos, config);
    }

    private void placeLogIfFreeWithOffsetAndChance(float pChance, LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos.MutableBlockPos pos, TreeConfiguration config, BlockPos pOffsetPos, int pOffsetX, int pOffsetY, int pOffsetZ) {
        if (random.m_188501_() > pChance) {
            return;
        }
        pos.m_122154_((Vec3i)pOffsetPos, pOffsetX, pOffsetY, pOffsetZ);
        this.m_226163_(level, blockSetter, random, pos, config);
    }
}

