/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<BlockDestructionProgress>> f_109409_;
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    @Nullable
    private ClientLevel f_109465_;

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void renderLevel(PoseStack poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        BlockHitResult result;
        ItemStack mainHandItem;
        block7: {
            block6: {
                HitResult hitResult;
                if (this.f_109461_.f_91074_ == null || this.f_109461_.f_91073_ == null) {
                    return;
                }
                mainHandItem = this.f_109461_.f_91074_.m_21205_();
                if (!ToolHelper.hasBehaviorsTag(mainHandItem) || ToolHelper.getAoEDefinition(mainHandItem) == AoESymmetrical.none() || !((hitResult = this.f_109461_.f_91077_) instanceof BlockHitResult)) break block6;
                result = (BlockHitResult)hitResult;
                if (!this.f_109461_.f_91074_.m_6144_()) break block7;
            }
            return;
        }
        BlockPos hitResultPos = result.m_82425_();
        BlockState hitResultState = this.f_109461_.f_91073_.m_8055_(hitResultPos);
        SortedSet progresses = (SortedSet)this.f_109409_.get(hitResultPos.m_121878_());
        if (progresses == null || progresses.isEmpty() || !mainHandItem.m_41735_(hitResultState)) {
            return;
        }
        BlockDestructionProgress progress = (BlockDestructionProgress)progresses.last();
        Set<BlockPos> positions = ToolHelper.getHarvestableBlocks(mainHandItem, ToolHelper.getAoEDefinition(mainHandItem), (Level)this.f_109465_, (Player)this.f_109461_.f_91074_, (HitResult)result);
        Vec3 vec3 = camera.m_90583_();
        double camX = vec3.m_7096_();
        double camY = vec3.m_7098_();
        double camZ = vec3.m_7094_();
        for (BlockPos pos : positions) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ);
            PoseStack.Pose last = poseStack.m_85850_();
            SheetedDecalTextureGenerator breakProgressDecal = new SheetedDecalTextureGenerator(this.f_109464_.m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(progress.m_139988_())), last.m_252922_(), last.m_252943_(), 1.0f);
            this.f_109461_.m_91289_().m_110918_(this.f_109461_.f_91073_.m_8055_(pos), pos, (BlockAndTintGetter)this.f_109461_.f_91073_, poseStack, (VertexConsumer)breakProgressDecal);
            poseStack.m_85849_();
        }
    }

    @Invoker(value="renderShape")
    public static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        throw new AssertionError();
    }

    @Inject(method={"renderHitOutline"}, at={@At(value="HEAD")})
    private void renderHitOutline(PoseStack poseStack, VertexConsumer consumer, Entity entity, double camX, double camY, double camZ, BlockPos pos, BlockState state, CallbackInfo ci) {
        if (this.f_109461_.f_91074_ == null || this.f_109461_.f_91073_ == null) {
            return;
        }
        ItemStack mainHandItem = this.f_109461_.f_91074_.m_21205_();
        if (state.m_60795_() || !this.f_109461_.f_91073_.m_46739_(pos) || !mainHandItem.m_41735_(state) || this.f_109461_.f_91074_.m_6144_() || !ToolHelper.hasBehaviorsTag(mainHandItem)) {
            return;
        }
        Set<BlockPos> blockPositions = ToolHelper.getHarvestableBlocks(mainHandItem, ToolHelper.getAoEDefinition(mainHandItem), (Level)this.f_109465_, (Player)this.f_109461_.f_91074_, this.f_109461_.f_91077_);
        HashSet<VoxelShape> outlineShapes = new HashSet<VoxelShape>();
        for (BlockPos position : blockPositions) {
            BlockPos diffPos = position.m_121996_((Vec3i)pos);
            BlockState offsetState = this.f_109461_.f_91073_.m_8055_(position);
            outlineShapes.add(offsetState.m_60808_((BlockGetter)this.f_109461_.f_91073_, position).m_83216_((double)diffPos.m_123341_(), (double)diffPos.m_123342_(), (double)diffPos.m_123343_()));
        }
        outlineShapes.forEach(shape -> LevelRendererMixin.renderShape(poseStack, consumer, shape, (double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ, 0.0f, 0.0f, 0.0f, 0.4f));
    }
}

