/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.loader;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBedrockFluids;
import com.gregtechceu.gtceu.integration.kjs.GTCEuServerEvents;
import com.gregtechceu.gtceu.integration.kjs.events.GTFluidVeinEventJS;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraftforge.fml.ModLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidVeinLoader
extends SimpleJsonResourceReloadListener {
    public static FluidVeinLoader INSTANCE;
    public static final Gson GSON_INSTANCE;
    private static final String FOLDER = "gtceu/fluid_veins";
    protected static final Logger LOGGER;

    public FluidVeinLoader() {
        super(GSON_INSTANCE, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceList, ResourceManager resourceManager, ProfilerFiller profiler) {
        GTRegistries.BEDROCK_FLUID_DEFINITIONS.unfreeze();
        GTRegistries.BEDROCK_FLUID_DEFINITIONS.registry().clear();
        GTBedrockFluids.init();
        AddonFinder.getAddons().forEach(IGTAddon::registerFluidVeins);
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.BEDROCK_FLUID_DEFINITIONS, BedrockFluidDefinition.class));
        if (GTCEu.isKubeJSLoaded()) {
            RunKJSEventInSeparateClassBecauseForgeIsDumb.fireKJSEvent();
        }
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceList.entrySet()) {
            ResourceLocation location = entry.getKey();
            try {
                BedrockFluidDefinition fluid = FluidVeinLoader.fromJson(location, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"), (RegistryOps<JsonElement>)ops);
                if (fluid == null) {
                    LOGGER.info("Skipping loading fluid vein {} as it's serializer returned null", (Object)location);
                    continue;
                }
                if (GTRegistries.BEDROCK_FLUID_DEFINITIONS.containKey(location)) {
                    GTRegistries.BEDROCK_FLUID_DEFINITIONS.replace(location, fluid);
                    continue;
                }
                GTRegistries.BEDROCK_FLUID_DEFINITIONS.register(location, fluid);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                LOGGER.error("Parsing error loading ore vein {}", (Object)location, (Object)jsonParseException);
            }
        }
        GTRegistries.BEDROCK_FLUID_DEFINITIONS.freeze();
    }

    public static BedrockFluidDefinition fromJson(ResourceLocation id, JsonObject json, RegistryOps<JsonElement> ops) {
        return (BedrockFluidDefinition)BedrockFluidDefinition.FULL_CODEC.decode(ops, (Object)json).map(Pair::getFirst).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    static {
        GSON_INSTANCE = Deserializers.m_78799_().create();
        LOGGER = LogManager.getLogger();
    }

    public static final class RunKJSEventInSeparateClassBecauseForgeIsDumb {
        public static void fireKJSEvent() {
            GTCEuServerEvents.FLUID_VEIN_MODIFICATION.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new GTFluidVeinEventJS());
        }
    }
}

