/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import org.apache.commons.lang3.tuple.Pair;

public class OreRecipeHandler {
    public static void init(Consumer<FinishedRecipe> provider) {
        for (TagPrefix ore : TagPrefix.ORES.keySet()) {
            if (!ConfigHolder.INSTANCE.worldgen.allUniqueStoneTypes && !TagPrefix.ORES.get(ore).shouldDropAsItem()) continue;
            ore.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processOre(tagPrefix, material, property, provider));
        }
        TagPrefix.ore.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processOreForgeHammer(tagPrefix, material, property, provider));
        TagPrefix.rawOre.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processRawOre(tagPrefix, material, property, provider));
        TagPrefix.crushed.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processCrushedOre(tagPrefix, material, property, provider));
        TagPrefix.crushedPurified.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processCrushedPurified(tagPrefix, material, property, provider));
        TagPrefix.crushedRefined.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processCrushedCentrifuged(tagPrefix, material, property, provider));
        TagPrefix.dustImpure.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processDirtyDust(tagPrefix, material, property, provider));
        TagPrefix.dustPure.executeHandler(PropertyKey.ORE, (tagPrefix, material, property) -> OreRecipeHandler.processPureDust(tagPrefix, material, property, provider));
    }

    private static void processMetalSmelting(TagPrefix crushedPrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack ingotStack;
        Material smeltingResult;
        Material material2 = smeltingResult = property.getDirectSmeltResult() != null ? property.getDirectSmeltResult() : material;
        if (smeltingResult.hasProperty(PropertyKey.INGOT) && !(ingotStack = ChemicalHelper.get(TagPrefix.ingot, smeltingResult)).m_41619_() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingResult)) {
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + crushedPrefix.name + "_" + material.getName() + "_to_ingot", ChemicalHelper.getTag(crushedPrefix, material), ingotStack, 0.5f);
        }
    }

    public static void processOreForgeHammer(TagPrefix orePrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack crushedStack = ChemicalHelper.get(TagPrefix.crushed, material);
        int amountOfCrushedOre = property.getOreMultiplier();
        int oreTypeMultiplier = TagPrefix.ORES.get(orePrefix).isDoubleDrops() ? 2 : 1;
        crushedStack.m_41764_(crushedStack.m_41613_() * property.getOreMultiplier());
        String prefixString = orePrefix == TagPrefix.ore ? "" : orePrefix.name + "_";
        GTRecipeBuilder builder = GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + prefixString + material.getName() + "_ore_to_raw_ore", new Object[0]).inputItems(orePrefix, material).duration(10).EUt(16L);
        if (material.hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(material)) {
            builder.outputItems(GTUtil.copyAmount(amountOfCrushedOre * oreTypeMultiplier, ChemicalHelper.get(TagPrefix.gem, material, crushedStack.m_41613_())));
        } else {
            builder.outputItems(GTUtil.copyAmount(amountOfCrushedOre * oreTypeMultiplier, crushedStack));
        }
        builder.save(provider);
    }

    public static void processOre(TagPrefix orePrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        String prefixString;
        Material byproductMaterial = GTUtil.selectItemInList(0, material, property.getOreByProducts(), Material.class);
        ItemStack byproductStack = ChemicalHelper.get(TagPrefix.gem, byproductMaterial);
        if (byproductStack.m_41619_()) {
            byproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial);
        }
        Material smeltingMaterial = property.getDirectSmeltResult() == null ? material : property.getDirectSmeltResult();
        ItemStack crushedStack = ChemicalHelper.get(TagPrefix.crushed, material);
        int amountOfCrushedOre = property.getOreMultiplier();
        ItemStack ingotStack = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get(TagPrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get(TagPrefix.gem, smeltingMaterial) : ChemicalHelper.get(TagPrefix.dust, smeltingMaterial));
        int oreTypeMultiplier = TagPrefix.ORES.get(orePrefix).isDoubleDrops() ? 2 : 1;
        ingotStack.m_41764_(ingotStack.m_41613_() * property.getOreMultiplier() * oreTypeMultiplier);
        crushedStack.m_41764_(crushedStack.m_41613_() * property.getOreMultiplier());
        String string = prefixString = orePrefix == TagPrefix.ore ? "" : orePrefix.name + "_";
        if (!crushedStack.m_41619_()) {
            GTRecipeBuilder builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + prefixString + material.getName() + "_ore_to_raw_ore", new Object[0]).inputItems(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(orePrefix.getItemTags(material)[0]), Ingredient.m_204132_(orePrefix.getItemParentTags()[0])})).outputItems(GTUtil.copyAmount(amountOfCrushedOre * 2 * oreTypeMultiplier, crushedStack)).chancedOutput(byproductStack, 1400, 850).EUt(2L).duration(400);
            for (MaterialStack secondaryMaterial : orePrefix.secondaryMaterials()) {
                if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                ItemStack dustStack = ChemicalHelper.getGem(secondaryMaterial);
                builder.chancedOutput(dustStack, 6700, 800);
            }
            builder.save(provider);
        }
        if (!ingotStack.m_41619_() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial) && !orePrefix.isIgnored(material)) {
            float xp = (float)Math.round(((1.0f + (float)oreTypeMultiplier * 0.5f) * 0.5f - 0.05f) * 10.0f) / 10.0f;
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + prefixString + material.getName() + "_ore_to_ingot", IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(orePrefix.getItemTags(material)[0]), Ingredient.m_204132_(orePrefix.getItemParentTags()[0])}), ingotStack, xp);
            VanillaRecipeHelper.addBlastingRecipe(provider, "smelt_" + prefixString + material.getName() + "_ore_to_ingot", IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(orePrefix.getItemTags(material)[0]), Ingredient.m_204132_(orePrefix.getItemParentTags()[0])}), ingotStack, xp);
        }
    }

    public static void processRawOre(TagPrefix orePrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        Material smeltingMaterial;
        ItemStack crushedStack = ChemicalHelper.get(TagPrefix.crushed, material);
        Material material2 = smeltingMaterial = property.getDirectSmeltResult() == null ? material : property.getDirectSmeltResult();
        ItemStack ingotStack = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get(TagPrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get(TagPrefix.gem, smeltingMaterial) : ChemicalHelper.get(TagPrefix.dust, smeltingMaterial));
        if (!crushedStack.m_41619_()) {
            GTRecipeBuilder builder = GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + orePrefix.name + "_" + material.getName() + "_to_crushed_ore", new Object[0]).inputItems(orePrefix, material).duration(10).EUt(16L);
            if (material.hasProperty(PropertyKey.GEM) && !TagPrefix.gem.isIgnored(material)) {
                builder.outputItems(ChemicalHelper.get(TagPrefix.gem, material, crushedStack.m_41613_()));
            } else {
                builder.outputItems(crushedStack.m_41777_());
            }
            builder.save(provider);
            GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + orePrefix.name + "_" + material.getName() + "_ore_to_crushed_ore", new Object[0]).inputItems(orePrefix, material).outputItems(crushedStack).chancedOutput(crushedStack, 5000, 750).chancedOutput(crushedStack, 2500, 500).chancedOutput(crushedStack, 1250, 250).EUt(2L).duration(400).save(provider);
        }
        if (!ingotStack.m_41619_() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial) && !orePrefix.isIgnored(material)) {
            float xp = (float)Math.round((1.0f + (float)property.getOreMultiplier() * 0.33f) / 3.0f * 10.0f) / 10.0f;
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + orePrefix.name + "_" + material.getName() + "_ore_to_ingot", ChemicalHelper.getTag(orePrefix, material), ingotStack, xp);
            VanillaRecipeHelper.addBlastingRecipe(provider, "smelt_" + orePrefix.name + "_" + material.getName() + "_ore_to_ingot", ChemicalHelper.getTag(orePrefix, material), ingotStack, xp);
        }
        if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
            VanillaRecipeHelper.addShapedRecipe(provider, "compress_" + material.getName() + "_to_ore_block", ChemicalHelper.get(TagPrefix.rawOreBlock, material), "BBB", "BBB", "BBB", Character.valueOf('B'), ChemicalHelper.getTag(TagPrefix.rawOre, material));
            VanillaRecipeHelper.addShapelessRecipe(provider, "decompress_" + material.getName() + "_from_ore_block", ChemicalHelper.get(TagPrefix.rawOre, material, 9), ChemicalHelper.getTag(TagPrefix.rawOreBlock, material));
            GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "to_ore_block", new Object[0]).inputItems(TagPrefix.rawOre, material, 9).outputItems(TagPrefix.rawOreBlock, material).duration(300).EUt(2L).save(provider);
        }
    }

    public static void processCrushedOre(TagPrefix crushedPrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack impureDustStack = ChemicalHelper.get(TagPrefix.dustImpure, material);
        Material byproductMaterial = GTUtil.selectItemInList(0, material, property.getOreByProducts(), Material.class);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_crushed_ore_to_impure_dust", new Object[0]).inputItems(crushedPrefix, material).outputItems(impureDustStack).duration(10).EUt(16L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_crushed_ore_to_impure_dust", new Object[0]).inputItems(crushedPrefix, material).outputItems(impureDustStack).duration(400).EUt(2L).chancedOutput(ChemicalHelper.get(TagPrefix.dust, byproductMaterial, property.getByProductMultiplier()), 1400, 850).save(provider);
        ItemStack crushedPurifiedOre = GTUtil.copy(ChemicalHelper.get(TagPrefix.crushedPurified, material), ChemicalHelper.get(TagPrefix.dust, material));
        ItemStack crushedCentrifugedOre = GTUtil.copy(ChemicalHelper.get(TagPrefix.crushedRefined, material), ChemicalHelper.get(TagPrefix.dust, material));
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore_fast", new Object[0]).inputItems(crushedPrefix, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100L)).outputItems(crushedPurifiedOre).duration(8).EUt(4L).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore", new Object[0]).inputItems(crushedPrefix, material).inputFluids(GTMaterials.Water.getFluid(1000L)).circuitMeta(1).outputItems(crushedPurifiedOre).chancedOutput(TagPrefix.dust, byproductMaterial, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore_distilled", new Object[0]).inputItems(crushedPrefix, material).inputFluids(GTMaterials.DistilledWater.getFluid(100L)).outputItems(crushedPurifiedOre).chancedOutput(TagPrefix.dust, byproductMaterial, 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone).duration(200).save(provider);
        GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_crushed_ore_to_refined_ore", new Object[0]).inputItems(crushedPrefix, material).outputItems(crushedCentrifugedOre).chancedOutput(TagPrefix.dust, property.getOreByProduct(1, material), property.getByProductMultiplier(), 3333, 0).outputItems(TagPrefix.dust, GTMaterials.Stone).save(provider);
        if (property.getWashedIn().getKey() != null) {
            Material washingByproduct = GTUtil.selectItemInList(3, material, property.getOreByProducts(), Material.class);
            Pair<Material, Integer> washedInTuple = property.getWashedIn();
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("bathe_" + material.getName() + "_crushed_ore_to_purified_ore", new Object[0]).inputItems(crushedPrefix, material).inputFluids(((Material)washedInTuple.getKey()).getFluid(((Integer)washedInTuple.getValue()).intValue())).outputItems(crushedPurifiedOre).chancedOutput(ChemicalHelper.get(TagPrefix.dust, washingByproduct, property.getByProductMultiplier()), 7000, 580).chancedOutput(ChemicalHelper.get(TagPrefix.dust, GTMaterials.Stone), 4000, 650).duration(200).EUt(GTValues.VA[1]).save(provider);
        }
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("crushed_ore_to_dust_%s", material.getName()), impureDustStack, Character.valueOf('h'), new UnificationEntry(crushedPrefix, material));
        OreRecipeHandler.processMetalSmelting(crushedPrefix, material, property, provider);
    }

    public static void processCrushedCentrifuged(TagPrefix centrifugedPrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        ItemStack byproductStack = ChemicalHelper.get(TagPrefix.dust, GTUtil.selectItemInList(2, material, property.getOreByProducts(), Material.class), 1);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_refined_ore_to_dust", new Object[0]).inputItems(centrifugedPrefix, material).outputItems(dustStack).duration(10).EUt(16L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_refined_ore_to_dust", new Object[0]).inputItems(centrifugedPrefix, material).outputItems(dustStack).chancedOutput(byproductStack, 1400, 850).duration(400).EUt(2L).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("centrifuged_ore_to_dust_%s", material.getName()), dustStack, Character.valueOf('h'), new UnificationEntry(centrifugedPrefix, material));
        OreRecipeHandler.processMetalSmelting(centrifugedPrefix, material, property, provider);
    }

    public static void processCrushedPurified(TagPrefix purifiedPrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack crushedCentrifugedStack = ChemicalHelper.get(TagPrefix.crushedRefined, material);
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dustPure, material);
        Material byproductMaterial = GTUtil.selectItemInList(1, material, property.getOreByProducts(), Material.class);
        ItemStack byproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_crushed_ore_to_dust", new Object[0]).inputItems(purifiedPrefix, material).outputItems(dustStack).duration(10).EUt(16L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_crushed_ore_to_dust", new Object[0]).inputItems(purifiedPrefix, material).outputItems(dustStack).chancedOutput(byproductStack, 1400, 850).duration(400).EUt(2L).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("purified_ore_to_dust_%s", material.getName()), dustStack, Character.valueOf('h'), new UnificationEntry(purifiedPrefix, material));
        if (!crushedCentrifugedStack.m_41619_()) {
            GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_purified_ore_to_refined_ore", new Object[0]).inputItems(purifiedPrefix, material).outputItems(crushedCentrifugedStack).chancedOutput(TagPrefix.dust, byproductMaterial, 3333, 0).save(provider);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            ItemStack exquisiteStack = ChemicalHelper.get(TagPrefix.gemExquisite, material);
            ItemStack flawlessStack = ChemicalHelper.get(TagPrefix.gemFlawless, material);
            ItemStack gemStack = ChemicalHelper.get(TagPrefix.gem, material);
            ItemStack flawedStack = ChemicalHelper.get(TagPrefix.gemFlawed, material);
            ItemStack chippedStack = ChemicalHelper.get(TagPrefix.gemChipped, material);
            if (material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT)) {
                GTRecipeBuilder builder = GTRecipeTypes.SIFTER_RECIPES.recipeBuilder("sift_" + material.getName() + "_purified_ore_to_gems", new Object[0]).inputItems(purifiedPrefix, material).chancedOutput(exquisiteStack, 500, 150).chancedOutput(flawlessStack, 1500, 200).chancedOutput(gemStack, 5000, 1000).chancedOutput(dustStack, 2500, 500).duration(400).EUt(16L);
                if (!flawedStack.m_41619_()) {
                    builder.chancedOutput(flawedStack, 2000, 500);
                }
                if (!chippedStack.m_41619_()) {
                    builder.chancedOutput(chippedStack, 3000, 350);
                }
                builder.save(provider);
            } else {
                GTRecipeBuilder builder = GTRecipeTypes.SIFTER_RECIPES.recipeBuilder("sift_" + material.getName() + "_purified_ore_to_gems", new Object[0]).inputItems(purifiedPrefix, material).chancedOutput(exquisiteStack, 300, 100).chancedOutput(flawlessStack, 1000, 150).chancedOutput(gemStack, 3500, 500).chancedOutput(dustStack, 5000, 750).duration(400).EUt(16L);
                if (!flawedStack.m_41619_()) {
                    builder.chancedOutput(flawedStack, 2500, 300);
                }
                if (!chippedStack.m_41619_()) {
                    builder.chancedOutput(chippedStack, 3500, 400);
                }
                builder.save(provider);
            }
        }
        OreRecipeHandler.processMetalSmelting(purifiedPrefix, material, property, provider);
    }

    public static void processDirtyDust(TagPrefix dustPrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        Material byproduct = GTUtil.selectItemInList(0, material, property.getOreByProducts(), Material.class);
        GTRecipeBuilder builder = GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_dirty_dust_to_dust", new Object[0]).inputItems(dustPrefix, material).outputItems(dustStack).duration((int)(material.getMass() * 4L)).EUt(24L);
        if (byproduct.hasProperty(PropertyKey.DUST)) {
            builder.chancedOutput(TagPrefix.dust, byproduct, 1111, 0);
        } else {
            builder.outputFluids(byproduct.getFluid(16L));
        }
        builder.save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_dirty_dust_to_dust", new Object[0]).inputItems(dustPrefix, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100L)).outputItems(dustStack).duration(8).EUt(4L).save(provider);
        OreRecipeHandler.processMetalSmelting(dustPrefix, material, property, provider);
    }

    public static void processPureDust(TagPrefix purePrefix, Material material, OreProperty property, Consumer<FinishedRecipe> provider) {
        Material byproductMaterial = GTUtil.selectItemInList(1, material, property.getOreByProducts(), Material.class);
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        if (property.getSeparatedInto() != null && !property.getSeparatedInto().isEmpty()) {
            List<Material> separatedMaterial = property.getSeparatedInto();
            TagPrefix prefix = separatedMaterial.get(separatedMaterial.size() - 1).getBlastTemperature() == 0 && separatedMaterial.get(separatedMaterial.size() - 1).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dust;
            ItemStack separatedStack2 = ChemicalHelper.get(prefix, separatedMaterial.get(separatedMaterial.size() - 1), prefix == TagPrefix.nugget ? 2 : 1);
            GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder("separate_" + material.getName() + "_pure_dust_to_dust", new Object[0]).inputItems(purePrefix, material).outputItems(dustStack).chancedOutput(TagPrefix.dust, separatedMaterial.get(0), 1000, 250).chancedOutput(separatedStack2, prefix == TagPrefix.dust ? 500 : 2000, prefix == TagPrefix.dust ? 150 : 600).duration(200).EUt(24L).save(provider);
        }
        GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_pure_dust_to_dust", new Object[0]).inputItems(purePrefix, material).outputItems(dustStack).chancedOutput(TagPrefix.dust, byproductMaterial, 1111, 0).duration(100).EUt(5L).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_pure_dust_to_dust", new Object[0]).inputItems(purePrefix, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100L)).outputItems(dustStack).duration(8).EUt(4L).save(provider);
        OreRecipeHandler.processMetalSmelting(purePrefix, material, property, provider);
    }

    private static boolean doesMaterialUseNormalFurnace(Material material) {
        return !material.hasProperty(PropertyKey.BLAST);
    }
}

