/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.GemProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PartsRecipeHandler {
    private PartsRecipeHandler() {
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        TagPrefix.rod.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> PartsRecipeHandler.processStick(tagPrefix, material, property, provider));
        TagPrefix.rodLong.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> PartsRecipeHandler.processLongStick(tagPrefix, material, property, provider));
        TagPrefix.plate.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> PartsRecipeHandler.processPlate(tagPrefix, material, property, provider));
        TagPrefix.plateDouble.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processPlateDouble(tagPrefix, material, property, provider));
        TagPrefix.plateDense.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processPlateDense(tagPrefix, material, property, provider));
        TagPrefix.turbineBlade.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processTurbine(tagPrefix, material, property, provider));
        TagPrefix.rotor.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processRotor(tagPrefix, material, property, provider));
        TagPrefix.bolt.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> PartsRecipeHandler.processBolt(tagPrefix, material, property, provider));
        TagPrefix.screw.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> PartsRecipeHandler.processScrew(tagPrefix, material, property, provider));
        TagPrefix.wireFine.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processFineWire(tagPrefix, material, property, provider));
        TagPrefix.foil.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processFoil(tagPrefix, material, property, provider));
        TagPrefix.lens.executeHandler(PropertyKey.GEM, (tagPrefix, material, property) -> PartsRecipeHandler.processLens(tagPrefix, material, property, provider));
        TagPrefix.gear.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> PartsRecipeHandler.processGear(tagPrefix, material, property, provider));
        TagPrefix.gearSmall.executeHandler(PropertyKey.DUST, (tagPrefix, material, property) -> PartsRecipeHandler.processGear(tagPrefix, material, property, provider));
        TagPrefix.ring.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processRing(tagPrefix, material, property, provider));
        TagPrefix.springSmall.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processSpringSmall(tagPrefix, material, property, provider));
        TagPrefix.spring.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processSpring(tagPrefix, material, property, provider));
        TagPrefix.round.executeHandler(PropertyKey.INGOT, (tagPrefix, material, property) -> PartsRecipeHandler.processRound(tagPrefix, material, property, provider));
    }

    public static void processBolt(TagPrefix boltPrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack boltStack = ChemicalHelper.get(boltPrefix, material);
        ItemStack ingotStack = ChemicalHelper.get(TagPrefix.ingot, material);
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_screw_to_bolt", new Object[0]).inputItems(TagPrefix.screw, material).outputItems(boltStack).duration(20).EUt(24L).save(provider);
        if (!boltStack.m_41619_() && !ingotStack.m_41619_()) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_bolt", new Object[0]).inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_BOLT).outputItems(GTUtil.copyAmount(8, boltStack)).duration(15).EUt(GTValues.VA[2]).save(provider);
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_bolt", new Object[0]).inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_BOLT).outputItems(GTUtil.copyAmount(8, boltStack)).duration(15).EUt(GTValues.VA[2]).save(provider);
            }
        }
    }

    public static void processScrew(TagPrefix screwPrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack screwStack = ChemicalHelper.get(screwPrefix, material);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_bolt_to_screw", new Object[0]).inputItems(TagPrefix.bolt, material).outputItems(screwStack).duration((int)Math.max(1L, material.getMass() / 8L)).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("screw_%s", material.getName()), screwStack, "fX", "X ", Character.valueOf('X'), new UnificationEntry(TagPrefix.bolt, material));
    }

    public static void processFoil(TagPrefix foilPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("foil_%s", material.getName()), ChemicalHelper.get(foilPrefix, material, 2), "hP ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
        }
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_foil", new Object[0]).inputItems(TagPrefix.plate, material).outputItems(foilPrefix, material, 4).duration((int)material.getMass()).EUt(24L).circuitMeta(1).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_foil", new Object[0]).inputItems(TagPrefix.ingot, material).outputItems(foilPrefix, material, 4).duration((int)material.getMass()).EUt(24L).circuitMeta(10).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_foil", new Object[0]).inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_FOIL).outputItems(foilPrefix, material, 4).duration((int)material.getMass()).EUt(24L).save(provider);
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_foil", new Object[0]).inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_FOIL).outputItems(foilPrefix, material, 4).duration((int)material.getMass()).EUt(24L).save(provider);
        }
    }

    public static void processFineWire(TagPrefix fineWirePrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack fineWireStack = ChemicalHelper.get(fineWirePrefix, material);
        if (!ChemicalHelper.get(TagPrefix.foil, material).m_41619_()) {
            VanillaRecipeHelper.addShapelessRecipe(provider, String.format("fine_wire_%s", material.getName()), fineWireStack, Character.valueOf('x'), new UnificationEntry(TagPrefix.foil, material));
        }
        if (material.hasProperty(PropertyKey.WIRE)) {
            GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "_wire_to_fine_wire", new Object[0]).inputItems(TagPrefix.wireGtSingle, material).outputItems(TagPrefix.wireFine, material, 4).duration((int)material.getMass() * 3 / 2).EUt(GTValues.VA[0]).save(provider);
        } else {
            GTRecipeTypes.WIREMILL_RECIPES.recipeBuilder("mill_" + material.getName() + "ingot_to_fine_wire", new Object[0]).inputItems(TagPrefix.ingot, material).outputItems(TagPrefix.wireFine, material, 8).duration((int)material.getMass() * 3).EUt(GTValues.VA[0]).save(provider);
        }
    }

    public static void processGear(TagPrefix gearPrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack stack = ChemicalHelper.get(gearPrefix, material);
        if (gearPrefix == TagPrefix.gear && material.hasProperty(PropertyKey.INGOT)) {
            int voltageMultiplier = PartsRecipeHandler.getVoltageMultiplier(material);
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_gear", new Object[0]).inputItems(TagPrefix.ingot, material, 4).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_GEAR).outputItems(gearPrefix, material).duration((int)material.getMass() * 5).EUt(8L * (long)voltageMultiplier).save(provider);
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_ingot_to_gear", new Object[0]).inputItems(TagPrefix.ingot, material, 8).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_GEAR).outputItems(gearPrefix, material).duration((int)material.getMass() * 10).EUt(2L * (long)voltageMultiplier).save(provider);
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_gear", new Object[0]).inputItems(TagPrefix.dust, material, 4).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_GEAR).outputItems(gearPrefix, material).duration((int)material.getMass() * 5).EUt(8L * (long)voltageMultiplier).save(provider);
            }
        }
        if (material.hasFluid()) {
            boolean isSmall = gearPrefix == TagPrefix.gearSmall;
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_" + gearPrefix.name, new Object[0]).notConsumable((Supplier<? extends Item>)(isSmall ? GTItems.SHAPE_MOLD_GEAR_SMALL : GTItems.SHAPE_MOLD_GEAR)).inputFluids(material.getFluid(144 * (isSmall ? 1 : 4))).outputItems(stack).duration(isSmall ? 20 : 100).EUt(GTValues.VA[0]).save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            if (gearPrefix == TagPrefix.gearSmall) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("small_gear_%s", material.getName()), ChemicalHelper.get(TagPrefix.gearSmall, material), " R ", "hPx", " R ", Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, material), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_small_gear", new Object[0]).inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_GEAR_SMALL).outputItems(stack).duration((int)material.getMass()).EUt(material.getBlastTemperature() >= 2800 ? 256L : 64L).save(provider);
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_ingot_to_small_gear", new Object[0]).duration((int)material.getMass()).EUt(GTValues.VA[1]).inputItems(TagPrefix.ingot, material, 2).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_GEAR_SMALL).outputItems(TagPrefix.gearSmall, material).save(provider);
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_small_gear", new Object[0]).inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_GEAR_SMALL).outputItems(stack).duration((int)material.getMass()).EUt(material.getBlastTemperature() >= 2800 ? 256L : 64L).save(provider);
                }
            } else {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("gear_%s", material.getName()), stack, "RPR", "PwP", "RPR", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, material));
            }
        }
    }

    public static void processLens(TagPrefix lensPrefix, Material material, GemProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack stack = ChemicalHelper.get(lensPrefix, material);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_plate_to_lens", new Object[0]).inputItems(TagPrefix.plate, material).outputItems(TagPrefix.lens, material).outputItems(TagPrefix.dustSmall, material).duration(1200).EUt(120L).save(provider);
        if (!ChemicalHelper.get(TagPrefix.gemExquisite, material).m_41619_()) {
            GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_gem_to_lens", new Object[0]).inputItems(TagPrefix.gemExquisite, material).outputItems(TagPrefix.lens, material).outputItems(TagPrefix.dust, material, 2).duration(2400).EUt(30L).save(provider);
        }
    }

    public static void processPlate(TagPrefix platePrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasFluid()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_plate", new Object[0]).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_PLATE).inputFluids(material.getFluid(144L)).outputItems(platePrefix, material).duration(40).EUt(GTValues.VA[0]).save(provider);
        }
    }

    public static void processPlateDouble(TagPrefix doublePrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("plate_double_%s", material.getName()), ChemicalHelper.get(doublePrefix, material), "h", "P", "P", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, material));
            }
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_double_plate", new Object[0]).EUt(96L).duration((int)material.getMass() * 2).inputItems(TagPrefix.plate, material, 2).outputItems(doublePrefix, material).circuitMeta(2).save(provider);
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_double_plate", new Object[0]).inputItems(TagPrefix.ingot, material, 2).circuitMeta(2).outputItems(doublePrefix, material).duration((int)material.getMass() * 2).EUt(96L).save(provider);
        }
    }

    public static void processPlateDense(TagPrefix tagPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_dense_plate", new Object[0]).inputItems(TagPrefix.plate, material, 9).circuitMeta(9).outputItems(tagPrefix, material).duration((int)Math.max(material.getMass() * 9L, 1L)).EUt(96L).save(provider);
        if (material.hasProperty(PropertyKey.INGOT)) {
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_dense_plate", new Object[0]).inputItems(TagPrefix.ingot, material, 9).circuitMeta(9).outputItems(tagPrefix, material).duration((int)Math.max(material.getMass() * 9L, 1L)).EUt(96L).save(provider);
        }
    }

    public static void processRing(TagPrefix ringPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_ring", new Object[0]).inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_RING).outputItems(ringPrefix, material, 4).duration((int)material.getMass() * 2).EUt(6L * (long)PartsRecipeHandler.getVoltageMultiplier(material)).save(provider);
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("ring_%s", material.getName()), ChemicalHelper.get(ringPrefix, material), "h ", " X", Character.valueOf('X'), new UnificationEntry(TagPrefix.rod, material));
        } else {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_ring", new Object[0]).inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_RING).outputItems(ringPrefix, material, 4).duration((int)material.getMass() * 2).EUt(6L * (long)PartsRecipeHandler.getVoltageMultiplier(material)).save(provider);
        }
    }

    public static void processSpringSmall(TagPrefix springPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("spring_small_%s", material.getName()), ChemicalHelper.get(TagPrefix.springSmall, material), " s ", "fRx", Character.valueOf('R'), new UnificationEntry(TagPrefix.rod, material));
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_rod_to_small_spring", new Object[0]).duration((int)(material.getMass() / 2L)).EUt(GTValues.VA[0]).inputItems(TagPrefix.rod, material).outputItems(TagPrefix.springSmall, material, 2).circuitMeta(1).save(provider);
    }

    public static void processSpring(TagPrefix springPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_long_rod_to_spring", new Object[0]).inputItems(TagPrefix.rodLong, material).outputItems(TagPrefix.spring, material).circuitMeta(1).duration(200).EUt(16L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("spring_%s", material.getName()), ChemicalHelper.get(TagPrefix.spring, material), " s ", "fRx", " R ", Character.valueOf('R'), new UnificationEntry(TagPrefix.rodLong, material));
    }

    public static void processRotor(TagPrefix rotorPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack stack = ChemicalHelper.get(rotorPrefix, material);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("rotor_%s", material.getName()), stack, "ChC", "SRf", "CdC", Character.valueOf('C'), new UnificationEntry(TagPrefix.plate, material), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, material), Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, material));
        if (material.hasFluid()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_rotor", new Object[0]).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_ROTOR).inputFluids(material.getFluid(576L)).outputItems(GTUtil.copy(stack)).duration(120).EUt(20L).save(provider);
        }
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_rotor", new Object[0]).inputItems(TagPrefix.ingot, material, 4).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_ROTOR).outputItems(GTUtil.copy(stack)).duration((int)material.getMass() * 4).EUt(material.getBlastTemperature() >= 2800 ? 256L : 64L).save(provider);
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_rotor", new Object[0]).inputItems(TagPrefix.dust, material, 4).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_ROTOR).outputItems(GTUtil.copy(stack)).duration((int)material.getMass() * 4).EUt(material.getBlastTemperature() >= 2800 ? 256L : 64L).save(provider);
        }
    }

    public static void processStick(TagPrefix stickPrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        if (material.hasProperty(PropertyKey.GEM) || material.hasProperty(PropertyKey.INGOT)) {
            GTRecipeBuilder builder = GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_to_rod", new Object[0]).inputItems(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material).duration((int)Math.max(material.getMass() * 2L, 1L)).EUt(16L);
            if (ConfigHolder.INSTANCE.recipes.harderRods) {
                builder.outputItems(TagPrefix.rod, material);
                builder.outputItems(TagPrefix.dustSmall, material, 2);
            } else {
                builder.outputItems(TagPrefix.rod, material, 2);
            }
            builder.save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
            ItemStack boltStack = ChemicalHelper.get(TagPrefix.bolt, material);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_rod_to_bolt", new Object[0]).inputItems(stickPrefix, material).outputItems(GTUtil.copyAmount(4, boltStack)).duration((int)Math.max(material.getMass() * 2L, 1L)).EUt(4L).save(provider);
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("bolt_saw_%s", material.getName()), GTUtil.copyAmount(2, boltStack), "s ", " X", Character.valueOf('X'), new UnificationEntry(TagPrefix.rod, material));
        }
    }

    public static void processLongStick(TagPrefix longStickPrefix, Material material, DustProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack stack = ChemicalHelper.get(longStickPrefix, material);
        ItemStack stickStack = ChemicalHelper.get(TagPrefix.rod, material);
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_long_rod_to_rod", new Object[0]).inputItems(longStickPrefix, material).outputItems(GTUtil.copyAmount(2, stickStack)).duration((int)Math.max(material.getMass(), 1L)).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_long_%s", material.getName()), GTUtil.copyAmount(2, stickStack), "s", "X", Character.valueOf('X'), new UnificationEntry(TagPrefix.rodLong, material));
        if (material.hasProperty(PropertyKey.GEM)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_long_gem_flawless_%s", material.getName()), stickStack, "sf", "G ", Character.valueOf('G'), new UnificationEntry(TagPrefix.gemFlawless, material));
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_long_gem_exquisite_%s", material.getName()), GTUtil.copyAmount(2, stickStack), "sf", "G ", Character.valueOf('G'), new UnificationEntry(TagPrefix.gemExquisite, material));
        }
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_long_stick_%s", material.getName()), stack, "ShS", Character.valueOf('S'), new UnificationEntry(TagPrefix.rod, material));
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_rod_to_long_rod", new Object[0]).inputItems(TagPrefix.rod, material, 2).outputItems(stack).duration((int)Math.max(material.getMass(), 1L)).EUt(16L).save(provider);
        if (material.hasProperty(PropertyKey.INGOT)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_long_rod", new Object[0]).inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_ROD_LONG).outputItems(stack).duration((int)Math.max(material.getMass(), 1L)).EUt(64L).save(provider);
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_long_rod", new Object[0]).inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_ROD_LONG).outputItems(stack).duration((int)Math.max(material.getMass(), 1L)).EUt(64L).save(provider);
            }
        }
    }

    public static void processTurbine(TagPrefix toolPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack rotorStack = GTItems.TURBINE_ROTOR.asStack();
        TurbineRotorBehaviour.getBehaviour(rotorStack).setPartMaterial(rotorStack, material);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_turbine_blade", new Object[0]).inputItems(TagPrefix.turbineBlade, material, 8).inputItems(TagPrefix.rodLong, GTMaterials.Magnalium).outputItems(rotorStack).duration(200).EUt(400L).save(provider);
        GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("press_" + material.getName() + "_turbine_rotor", new Object[0]).inputItems(TagPrefix.plateDouble, material, 5).inputItems(TagPrefix.screw, material, 2).outputItems(toolPrefix, material).duration(20).EUt(256L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("turbine_blade_%s", material.getName()), ChemicalHelper.get(toolPrefix, material), "PPP", "SPS", "fPd", Character.valueOf('P'), new UnificationEntry(TagPrefix.plateDouble, material), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, material));
    }

    public static void processRound(TagPrefix roundPrefix, Material material, IngotProperty property, Consumer<FinishedRecipe> provider) {
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("round_%s", material.getName()), ChemicalHelper.get(TagPrefix.round, material), "fN", "Nh", Character.valueOf('N'), new UnificationEntry(TagPrefix.nugget, material));
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("round_from_ingot_%s", material.getName()), ChemicalHelper.get(TagPrefix.round, material, 4), "fIh", Character.valueOf('I'), new UnificationEntry(TagPrefix.ingot, material));
        }
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_" + material.getName() + "_nugget_to_round", new Object[0]).EUt(GTValues.VA[0]).duration(100).inputItems(TagPrefix.nugget, material).outputItems(TagPrefix.round, material).save(provider);
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

