/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.forge;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.capability.forge.compat.EUToFEProvider;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.DrumMachineItem;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.common.ServerCommands;
import com.gregtechceu.gtceu.common.block.CoilBlock;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.data.loader.forge.FluidVeinLoaderImpl;
import com.gregtechceu.gtceu.data.loader.forge.OreDataLoaderImpl;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.TaskHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="gtceu", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeCommonEventListener {
    @SubscribeEvent
    public static void registerItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        Item itemStack;
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (item instanceof ComponentItem) {
            final ComponentItem componentItem = (ComponentItem)item;
            itemStack = (ItemStack)event.getObject();
            event.addCapability(GTCEu.id("capability"), new ICapabilityProvider(){
                final /* synthetic */ ItemStack val$itemStack;
                {
                    this.val$itemStack = itemStack;
                }

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return componentItem.getCapability(this.val$itemStack, cap);
                }
            });
        }
        if ((itemStack = ((ItemStack)event.getObject()).m_41720_()) instanceof DrumMachineItem) {
            final DrumMachineItem drumMachineItem = (DrumMachineItem)itemStack;
            itemStack = (ItemStack)event.getObject();
            event.addCapability(GTCEu.id("fluid"), new ICapabilityProvider(){
                final /* synthetic */ ItemStack val$itemStack;
                {
                    this.val$itemStack = itemStack;
                }

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    return drumMachineItem.getCapability(this.val$itemStack, capability);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        IInteractedMachine machine;
        MetaMachineBlock block;
        Object object;
        BlockState blockState = event.getLevel().m_8055_(event.getPos());
        if (blockState.m_155947_() && (object = blockState.m_60734_()) instanceof MetaMachineBlock && (object = (block = (MetaMachineBlock)object).getMachine((BlockGetter)event.getLevel(), event.getPos())) instanceof IInteractedMachine && (machine = (IInteractedMachine)object).onLeftClick(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        ServerCommands.createServerCommands().forEach(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0));
    }

    @SubscribeEvent
    public static void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new OreDataLoaderImpl());
        event.addListener((PreparableReloadListener)new FluidVeinLoaderImpl());
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        event.addCapability(GTCEu.id("fe_capability"), (ICapabilityProvider)new EUToFEProvider((BlockEntity)event.getObject()));
    }

    @SubscribeEvent
    public static void levelTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.phase.equals((Object)TickEvent.Phase.END)) {
                TaskHandler.onTickUpdate(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void worldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            TaskHandler.onWorldUnLoad(serverLevel);
        }
    }

    @SubscribeEvent
    public static void remapIds(MissingMappingsEvent event) {
        event.getMappings(Registries.f_256747_, "gtceu").forEach(mapping -> {
            if (mapping.getKey().equals((Object)GTCEu.id("tungstensteel_coil_block"))) {
                mapping.remap((Object)((Block)GTBlocks.COIL_RTMALLOY.get()));
            }
        });
        event.getMappings(Registries.f_256913_, "gtceu").forEach(mapping -> {
            if (mapping.getKey().equals((Object)GTCEu.id("tungstensteel_coil_block"))) {
                mapping.remap((Object)((CoilBlock)GTBlocks.COIL_RTMALLOY.get()).m_5456_());
            }
        });
        for (TagPrefix prefix : TagPrefix.values()) {
            String first = prefix.invertedName ? FormattingUtil.toLowerCaseUnder(prefix.name) : "(.+?)";
            String last = prefix.invertedName ? "(.+?)" : FormattingUtil.toLowerCaseUnder(prefix.name);
            Pattern idPattern = Pattern.compile(first + "_" + last);
            event.getMappings(Registries.f_256747_, "gtceu").forEach(mapping -> {
                BlockEntry block;
                Matcher matcher = idPattern.matcher(mapping.getKey().m_135815_());
                if (matcher.matches() && (block = (BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)prefix, GTCEuAPI.materialManager.getRegistry("gtceu").get(matcher.group(1)))) != null && block.isPresent()) {
                    mapping.remap((Object)((Block)block.get()));
                }
            });
            event.getMappings(Registries.f_256913_, "gtceu").forEach(mapping -> {
                Matcher matcher = idPattern.matcher(mapping.getKey().m_135815_());
                if (matcher.matches()) {
                    BlockEntry block = (BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)prefix, GTCEuAPI.materialManager.getRegistry("gtceu").get(matcher.group(1)));
                    if (block != null && block.isPresent()) {
                        mapping.remap((Object)block.m_5456_());
                    } else {
                        ItemEntry item = (ItemEntry)GTItems.MATERIAL_ITEMS.get((Object)prefix, GTCEuAPI.materialManager.getRegistry("gtceu").get(matcher.group(1)));
                        if (item != null && item.isPresent()) {
                            mapping.remap((Object)item.m_5456_());
                        }
                    }
                }
            });
        }
    }
}

