/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.test.api.machine.trait;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ParallelLogicTest {
    @GameTest(m_177046_="gtceu:ebf")
    public void getMaxRecipeMultiplier_FluidLimitTest(GameTestHelper helper) {
        BlockEntity holder = helper.m_177347_(new BlockPos(1, 1, 0));
        if (!(holder instanceof MetaMachineBlockEntity)) {
            helper.m_177284_("wrong block at relative pos [1,1,0]!");
            return;
        }
        MetaMachineBlockEntity atte = (MetaMachineBlockEntity)holder;
        MetaMachine machine = atte.getMetaMachine();
        if (!(machine instanceof IRecipeLogicMachine)) {
            helper.m_177284_("wrong machine in MetaMachineBlockEntity!");
            return;
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        int parallelLimit = 4;
        GTRecipe recipe = GTRecipeBuilder.ofRaw().inputItems(new ItemStack((ItemLike)Blocks.f_50652_)).inputFluids(GTMaterials.Acetone.getFluid(4000L)).outputItems(new ItemStack((ItemLike)Blocks.f_50069_)).blastFurnaceTemp(1000).EUt(30L).duration(100).buildRawRecipe();
        ((IItemTransfer)rlm.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP)).insertItem(0, new ItemStack((ItemLike)Blocks.f_50652_, 16), false);
        ((IFluidTransfer)rlm.getCapabilitiesProxy().get((Object)IO.IN, (Object)FluidRecipeCapability.CAP)).fill(GTMaterials.Acetone.getFluid(8000L), false);
        Tuple<GTRecipe, Integer> paralleled = GTRecipeModifiers.accurateParallel(machine, recipe, parallelLimit, false);
        helper.m_246336_((Integer)paralleled.m_14419_() == 2, "Expected Parallel amount to be 2, is %s.".formatted(paralleled.m_14419_()));
        helper.m_177412_();
    }

    @GameTest(m_177046_="gtceu:ebf")
    public void getMaxRecipeMultiplier_LimitFailureTest(GameTestHelper helper) {
        BlockEntity holder = helper.m_177347_(new BlockPos(1, 1, 0));
        if (!(holder instanceof MetaMachineBlockEntity)) {
            helper.m_177284_("wrong block at relative pos [1,1,0]!");
            return;
        }
        MetaMachineBlockEntity atte = (MetaMachineBlockEntity)holder;
        MetaMachine machine = atte.getMetaMachine();
        if (!(machine instanceof IRecipeLogicMachine)) {
            helper.m_177284_("wrong machine in MetaMachineBlockEntity!");
            return;
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        int parallelLimit = 4;
        GTRecipe recipe = GTRecipeBuilder.ofRaw().inputItems(new ItemStack((ItemLike)Blocks.f_50652_)).inputFluids(GTMaterials.Acetone.getFluid(1000L)).outputItems(new ItemStack((ItemLike)Blocks.f_50069_)).blastFurnaceTemp(1000).EUt(30L).duration(100).buildRawRecipe();
        ((IItemTransfer)rlm.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP)).insertItem(0, new ItemStack((ItemLike)Blocks.f_50652_, 16), false);
        ((IFluidTransfer)rlm.getCapabilitiesProxy().get((Object)IO.IN, (Object)FluidRecipeCapability.CAP)).fill(GTMaterials.Acetone.getFluid(8000L), false);
        Tuple<GTRecipe, Integer> paralleled = GTRecipeModifiers.accurateParallel(machine, recipe, parallelLimit, false);
        helper.m_246336_(paralleled == null || (Integer)paralleled.m_14419_() == 0, "Parallel is too high, should be 0, is %s.".formatted(paralleled.m_14419_()));
        helper.m_177412_();
    }

    @GameTest(m_177046_="gtceu:ebf")
    public void getMaxRecipeMultiplier_ItemFailureTest(GameTestHelper helper) {
        BlockEntity holder = helper.m_177347_(new BlockPos(1, 1, 0));
        if (!(holder instanceof MetaMachineBlockEntity)) {
            helper.m_177284_("wrong block at relative pos [1,1,0]!");
            return;
        }
        MetaMachineBlockEntity atte = (MetaMachineBlockEntity)holder;
        MetaMachine machine = atte.getMetaMachine();
        if (!(machine instanceof IRecipeLogicMachine)) {
            helper.m_177284_("wrong machine in MetaMachineBlockEntity!");
            return;
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        int parallelLimit = 4;
        GTRecipe recipe = GTRecipeBuilder.ofRaw().inputItems(new ItemStack((ItemLike)Blocks.f_50652_)).inputFluids(GTMaterials.Acetone.getFluid(100L)).outputItems(new ItemStack((ItemLike)Blocks.f_50069_)).blastFurnaceTemp(1000).EUt(30L).duration(100).buildRawRecipe();
        ((IItemTransfer)rlm.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP)).insertItem(0, new ItemStack((ItemLike)Blocks.f_50652_, 16), false);
        ((IFluidTransfer)rlm.getCapabilitiesProxy().get((Object)IO.IN, (Object)FluidRecipeCapability.CAP)).fill(GTMaterials.Naphtha.getFluid(8000L), false);
        Tuple<GTRecipe, Integer> paralleled = GTRecipeModifiers.accurateParallel(machine, recipe, parallelLimit, false);
        helper.m_246336_(paralleled == null || (Integer)paralleled.m_14419_() == 0, "Parallel is too high, should be 0, is %s.".formatted(paralleled.m_14419_()));
        helper.m_177412_();
    }
}

