/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.GTCEu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class TaskHandler {
    private static final Map<ResourceKey<Level>, List<RunnableEntry>> serverTasks = new HashMap<ResourceKey<Level>, List<RunnableEntry>>();
    private static final Map<ResourceKey<Level>, List<RunnableEntry>> waitToAddTasks = new HashMap<ResourceKey<Level>, List<RunnableEntry>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onTickUpdate(ServerLevel level) {
        ResourceKey key = level.m_46472_();
        Map<ResourceKey<Level>, List<RunnableEntry>> map = waitToAddTasks;
        synchronized (map) {
            List<RunnableEntry> list = waitToAddTasks.remove(key);
            if (list != null && !list.isEmpty()) {
                serverTasks.computeIfAbsent((ResourceKey<Level>)key, k -> new ArrayList()).addAll(list);
            }
        }
        TaskHandler.execute(serverTasks.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onWorldUnLoad(ServerLevel level) {
        ResourceKey key = level.m_46472_();
        serverTasks.remove(key);
        Map<ResourceKey<Level>, List<RunnableEntry>> map = waitToAddTasks;
        synchronized (map) {
            waitToAddTasks.remove(key);
        }
    }

    private static void execute(List<RunnableEntry> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        Iterator<RunnableEntry> iter = tasks.iterator();
        while (iter.hasNext()) {
            RunnableEntry task = iter.next();
            if (task.delay <= 0) {
                try {
                    task.runnable.run();
                }
                catch (Exception e) {
                    GTCEu.LOGGER.error("error while schedule gregtech task", (Throwable)e);
                }
                iter.remove();
                continue;
            }
            --task.delay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueueServerTask(ServerLevel level, Runnable task, int delay) {
        Map<ResourceKey<Level>, List<RunnableEntry>> map = waitToAddTasks;
        synchronized (map) {
            waitToAddTasks.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new ArrayList()).add(new RunnableEntry(task, delay));
        }
    }

    private static class RunnableEntry {
        Runnable runnable;
        int delay;

        public RunnableEntry(Runnable runnable, int delay) {
            this.runnable = runnable;
            this.delay = delay;
        }
    }
}

