/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu;

import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTCEu {
    public static final String MOD_ID = "gtceu";
    public static final String NAME = "GregTechCEu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"GregTechCEu");
    private static boolean highTier;
    private static boolean highTierInitialized;

    public static void init() {
        LOGGER.info("{} is initializing on platform: {}", (Object)NAME, (Object)Platform.platformName());
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, FormattingUtil.toLowerCaseUnder(path));
    }

    public static String appendIdString(String id) {
        return id.indexOf(58) == -1 ? "gtceu:" + id : id;
    }

    public static ResourceLocation appendId(String id) {
        String[] strings = new String[]{MOD_ID, id};
        int i = id.indexOf(58);
        if (i >= 0) {
            strings[1] = id.substring(i + 1);
            if (i >= 1) {
                strings[0] = id.substring(0, i);
            }
        }
        return new ResourceLocation(strings[0], strings[1]);
    }

    public static boolean isKubeJSLoaded() {
        return LDLib.isModLoaded((String)"kubejs");
    }

    public static boolean isCreateLoaded() {
        return LDLib.isModLoaded((String)"create");
    }

    public static boolean isIrisOculusLoaded() {
        return LDLib.isModLoaded((String)"iris") || LDLib.isModLoaded((String)"oculus");
    }

    public static boolean isSodiumRubidiumEmbeddiumLoaded() {
        return LDLib.isModLoaded((String)"sodium") || LDLib.isModLoaded((String)"rubidium") || LDLib.isModLoaded((String)"embeddium");
    }

    public static boolean isRebornEnergyLoaded() {
        return Platform.isForge() || LDLib.isModLoaded((String)"team_reborn_energy");
    }

    public static boolean isAE2Loaded() {
        return LDLib.isModLoaded((String)"ae2");
    }

    public static boolean isAlmostUnifiedLoaded() {
        return LDLib.isModLoaded((String)"almostunified");
    }

    @ApiStatus.Internal
    public static void initializeHighTier() {
        if (highTierInitialized) {
            throw new IllegalStateException("High-Tier is already initialized.");
        }
        highTier = ConfigHolder.INSTANCE.machines.highTierContent || AddonFinder.getAddons().stream().anyMatch(IGTAddon::requiresHighTier) || Platform.isDevEnv();
        highTierInitialized = true;
        if (GTCEu.isHighTier()) {
            LOGGER.info("High-Tier is Enabled.");
        } else {
            LOGGER.info("High-Tier is Disabled.");
        }
    }

    public static boolean isHighTier() {
        return highTier;
    }
}

