/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.addon.forge;

import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.GTAddon;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AddonFinderImpl
extends AddonFinder {
    private static final Logger LOGGER = LogManager.getLogger();

    private AddonFinderImpl() {
    }

    public static List<IGTAddon> getAddons() {
        if (cache == null) {
            cache = AddonFinderImpl.getInstances(GTAddon.class, IGTAddon.class);
        }
        return cache;
    }

    private static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        List allScanData = ModList.get().getAllScanData();
        LinkedHashSet<String> pluginClassNames = new LinkedHashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (!Objects.equals(a.annotationType(), annotationType)) continue;
                String memberName = a.memberName();
                pluginClassNames.add(memberName);
            }
        }
        ArrayList<T> instances = new ArrayList<T>();
        for (String className : pluginClassNames) {
            try {
                Class<?> asmClass = Class.forName(className);
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                Constructor<T> constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
                T instance = constructor.newInstance(new Object[0]);
                instances.add(instance);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                LOGGER.error("Failed to load: {}", (Object)className, (Object)e);
            }
        }
        return instances;
    }
}

