/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MetaMachineBlock
extends AppearanceBlock
implements IMachineBlock {
    public final MachineDefinition definition;
    public final RotationState rotationState;

    public MetaMachineBlock(BlockBehaviour.Properties properties, MachineDefinition definition) {
        super(properties);
        this.definition = definition;
        this.rotationState = RotationState.get();
        if (this.rotationState != RotationState.NONE) {
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)this.rotationState.property, (Comparable)this.rotationState.defaultDirection));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{BlockProperties.SERVER_TICK});
        RotationState rotationState = RotationState.get();
        if (rotationState != RotationState.NONE) {
            pBuilder.m_61104_(new Property[]{rotationState.property});
        }
    }

    @Nullable
    public MetaMachine getMachine(BlockGetter level, BlockPos pos) {
        return MetaMachine.getMachine(level, pos);
    }

    @Nullable
    public IRenderer getRenderer(BlockState state) {
        return this.definition.getRenderer();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getRotationState() == RotationState.NONE ? this.definition.getShape(Direction.NORTH) : this.definition.getShape((Direction)pState.m_61143_((Property)this.getRotationState().property));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        MetaMachine machine = this.getMachine((BlockGetter)level, pos);
        if (machine != null) {
            machine.animateTick(random);
        }
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity player, ItemStack pStack) {
        if (!pLevel.f_46443_) {
            MetaMachine machine = this.getMachine((BlockGetter)pLevel, pPos);
            if (machine instanceof IDropSaveMachine) {
                IDropSaveMachine dropSaveMachine = (IDropSaveMachine)((Object)machine);
                CompoundTag tag = pStack.m_41783_();
                if (tag != null) {
                    dropSaveMachine.loadFromItem(tag);
                }
            }
            if (machine instanceof IMachineLife) {
                IMachineLife machineLife = (IMachineLife)((Object)machine);
                machineLife.onMachinePlaced(player, pStack);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        RotationState rotationState = this.getRotationState();
        Player player = context.m_43723_();
        BlockPos blockPos = context.m_8083_();
        BlockState state = this.m_49966_();
        if (player != null && rotationState != RotationState.NONE) {
            Vec3 pos = player.m_20182_();
            if (Math.abs(pos.f_82479_ - (double)((float)blockPos.m_123341_() + 0.5f)) < 2.0 && Math.abs(pos.f_82481_ - (double)((float)blockPos.m_123343_() + 0.5f)) < 2.0) {
                double d0 = pos.f_82480_ + (double)player.m_20192_();
                if (d0 - (double)blockPos.m_123342_() > 2.0 && rotationState.test(Direction.UP)) {
                    return (BlockState)state.m_61124_((Property)rotationState.property, (Comparable)Direction.UP);
                }
                if ((double)blockPos.m_123342_() - d0 > 0.0 && rotationState.test(Direction.DOWN)) {
                    return (BlockState)state.m_61124_((Property)rotationState.property, (Comparable)Direction.DOWN);
                }
            }
            if (rotationState == RotationState.Y_AXIS) {
                return (BlockState)state.m_61124_((Property)rotationState.property, (Comparable)Direction.UP);
            }
            return (BlockState)state.m_61124_((Property)rotationState.property, (Comparable)player.m_6350_().m_122424_());
        }
        return state;
    }

    public Direction getFrontFacing(BlockState state) {
        return this.getRotationState() == RotationState.NONE ? Direction.NORTH : (Direction)state.m_61143_((Property)this.getRotationState().property);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        IDropSaveMachine dropSaveMachine;
        ItemStack itemStack = super.m_7397_(level, pos, state);
        MetaMachine metaMachine = this.getMachine(level, pos);
        if (metaMachine instanceof IDropSaveMachine && (dropSaveMachine = (IDropSaveMachine)((Object)metaMachine)).savePickClone()) {
            dropSaveMachine.saveToItem(itemStack.m_41784_());
        }
        return itemStack;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        this.definition.getTooltipBuilder().accept(stack, tooltip);
        String mainKey = String.format("%s.machine.%s.tooltip", this.definition.getId().m_135827_(), this.definition.getId().m_135815_());
        if (LocalizationUtils.exist((String)mainKey)) {
            tooltip.add(1, (Component)Component.m_237115_((String)mainKey));
        }
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        BlockEntity tile = pLevel.m_7702_(pPos);
        if (tile != null) {
            return tile.m_7531_(pId, pParam);
        }
        return false;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return super.m_6843_(pState, pRotation);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        LootParams context = builder.m_287286_(LootContextParams.f_81461_, (Object)state).m_287235_(LootContextParamSets.f_81421_);
        Entity entity = (Entity)context.m_287267_(LootContextParams.f_81455_);
        BlockEntity tileEntity = (BlockEntity)context.m_287267_(LootContextParams.f_81462_);
        List drops = super.m_49635_(state, builder);
        if (tileEntity instanceof IMachineBlockEntity) {
            IDropSaveMachine dropSaveMachine;
            IMachineBlockEntity holder = (IMachineBlockEntity)tileEntity;
            MetaMachine machine = holder.getMetaMachine();
            for (Direction direction : Direction.values()) {
                machine.getCoverContainer().removeCover(direction, null);
            }
            if (machine instanceof IMachineModifyDrops) {
                IMachineModifyDrops machineModifyDrops = (IMachineModifyDrops)((Object)machine);
                if (entity instanceof Player) {
                    machineModifyDrops.onDrops(drops, (Player)entity);
                }
            }
            if (machine instanceof IDropSaveMachine && (dropSaveMachine = (IDropSaveMachine)((Object)machine)).saveBreak()) {
                for (ItemStack drop : drops) {
                    MetaMachineItem item;
                    Item item2 = drop.m_41720_();
                    if (!(item2 instanceof MetaMachineItem) || (item = (MetaMachineItem)item2).m_40614_() != this) continue;
                    dropSaveMachine.saveToItem(drop.m_41784_());
                }
            }
        }
        return drops;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_155947_()) {
            if (!pState.m_60713_(pNewState.m_60734_())) {
                MetaMachine metaMachine = this.getMachine((BlockGetter)pLevel, pPos);
                if (metaMachine instanceof IMachineLife) {
                    IMachineLife machineLife = (IMachineLife)((Object)metaMachine);
                    machineLife.onMachineRemoved();
                }
                pLevel.m_46717_(pPos, (Block)this);
                pLevel.m_46747_(pPos);
            } else if (this.rotationState != RotationState.NONE) {
                MetaMachine machine;
                Direction oldFacing = (Direction)pState.m_61143_((Property)this.rotationState.property);
                Direction newFacing = (Direction)pNewState.m_61143_((Property)this.rotationState.property);
                if (newFacing != oldFacing && (machine = this.getMachine((BlockGetter)pLevel, pPos)) != null) {
                    machine.onRotated(oldFacing, newFacing);
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IInteractedMachine interactedMachine;
        InteractionResult result;
        MetaMachine machine = this.getMachine((BlockGetter)world, pos);
        if (machine instanceof IInteractedMachine && (result = (interactedMachine = (IInteractedMachine)((Object)machine)).onUse(state, world, pos, player, hand, hit)) != InteractionResult.PASS) {
            return result;
        }
        if (machine instanceof IUIMachine) {
            IUIMachine uiMachine = (IUIMachine)((Object)machine);
            return uiMachine.tryToOpenUI(player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public boolean canConnectRedstone(BlockGetter level, BlockPos pos, Direction side) {
        return this.getMachine(level, pos).canConnectRedstone(side);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getMachine(level, pos).getOutputSignal(direction);
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getMachine(level, pos).getOutputDirectSignal(direction);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return this.getMachine((BlockGetter)level, pos).getAnalogOutputSignal();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        MetaMachine machine = this.getMachine((BlockGetter)level, pos);
        if (machine != null) {
            machine.onNeighborChanged(block, fromPos, isMoving);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    @Override
    public BlockState getBlockAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState sourceState, BlockPos sourcePos) {
        MetaMachine machine = this.getMachine((BlockGetter)level, pos);
        if (machine != null) {
            return machine.getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
        }
        return super.getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
    }

    @Override
    public MachineDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public RotationState getRotationState() {
        return this.rotationState;
    }
}

