/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.client.renderer.block.PipeBlockRenderer;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class PipeBlock<PipeType extends Enum<PipeType>, NodeDataType extends IAttachData, WorldPipeNetType extends LevelPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends AppearanceBlock
implements EntityBlock,
IBlockRendererProvider {
    public final PipeType pipeType;

    public PipeBlock(BlockBehaviour.Properties properties, PipeType pipeType) {
        super(properties);
        this.pipeType = pipeType;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{BlockProperties.SERVER_TICK}));
    }

    public final PipeBlockEntity<PipeType, NodeDataType> newBlockEntity(BlockPos pos, BlockState state) {
        return (PipeBlockEntity)this.getBlockEntityType().m_155264_(pos, state);
    }

    public abstract WorldPipeNetType getWorldPipeNet(ServerLevel var1);

    public abstract BlockEntityType<? extends PipeBlockEntity<PipeType, NodeDataType>> getBlockEntityType();

    public abstract NodeDataType createRawData(BlockState var1, @Nullable ItemStack var2);

    public abstract NodeDataType getFallbackType();

    @Nullable
    public abstract PipeBlockRenderer getRenderer(BlockState var1);

    protected abstract PipeModel getPipeModel();

    @Nullable
    public IPipeNode<PipeType, NodeDataType> getPileTile(BlockGetter level, BlockPos pos) {
        IPipeNode pipeTile;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IPipeNode && ((IPipeType)(pipeTile = (IPipeNode)blockEntity).getPipeType()).type().equals((Object)((IPipeType)this.pipeType).type())) {
            return pipeTile;
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        IPipeNode<PipeType, NodeDataType> pipeNode = this.getPileTile((BlockGetter)pLevel, pPos);
        if (pipeNode != null && pLevel instanceof ServerLevel) {
            Direction attachSide;
            BlockPos attachPos;
            ServerLevel serverLevel = (ServerLevel)pLevel;
            WorldPipeNetType net = this.getWorldPipeNet(serverLevel);
            if (net.getNetFromPos(pPos) == null) {
                net.addNode(pPos, ((IPipeType)this.pipeType).modifyProperties(this.createRawData(pState, pStack)), 0, 0, true);
            } else {
                net.updateData(pPos, ((IPipeType)this.pipeType).modifyProperties(this.createRawData(pState, pStack)));
            }
            if (PipeBlockItem.LAST_CONTEXT != null && !PipeBlockItem.LAST_CONTEXT.m_7058_() && (attachPos = PipeBlockItem.LAST_CONTEXT.m_8083_().m_121945_(PipeBlockItem.LAST_CONTEXT.m_43719_().m_122424_())).m_121945_(attachSide = PipeBlockItem.LAST_CONTEXT.m_43719_()).equals((Object)pPos)) {
                IPipeNode<PipeType, NodeDataType> attachNode = this.getPileTile((BlockGetter)pLevel, attachPos);
                if (attachNode != null) {
                    if (attachNode.isBlocked(attachSide)) {
                        attachNode.setBlocked(attachSide, false);
                    }
                    if (pipeNode.isBlocked(attachSide.m_122424_())) {
                        pipeNode.setBlocked(attachSide.m_122424_(), false);
                    }
                } else if (pipeNode.isBlocked(attachSide.m_122424_()) && pipeNode.canAttachTo(attachSide.m_122424_())) {
                    pipeNode.setBlocked(attachSide.m_122424_(), false);
                }
            }
            for (Direction side : Direction.values()) {
                BlockPos attachPos2;
                IPipeNode<PipeType, NodeDataType> attachNode;
                if (!pipeNode.isBlocked(side) || (attachNode = this.getPileTile((BlockGetter)pLevel, attachPos2 = pPos.m_121945_(side))) == null || attachNode.isBlocked(side.m_122424_())) continue;
                pipeNode.setBlocked(side, false);
            }
            pipeNode.updateConnections();
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        ServerLevel serverLevel;
        WorldPipeNetType net;
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!oldState.m_60713_(state.m_60734_()) && level instanceof ServerLevel && (net = this.getWorldPipeNet(serverLevel = (ServerLevel)level)).getNetFromPos(pos) == null) {
            net.addNode(pos, ((IPipeType)this.pipeType).modifyProperties(this.createRawData(state, null)), 0, 0, true);
        }
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        IPipeNode<PipeType, NodeDataType> pipeNode = this.getPileTile((BlockGetter)pLevel, pPos);
        if (pipeNode != null) {
            pipeNode.onNeighborChanged(pBlock, pFromPos, pIsMoving);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_155947_() && !pState.m_60713_(pNewState.m_60734_())) {
            pLevel.m_46717_(pPos, (Block)this);
            pLevel.m_46747_(pPos);
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                this.getWorldPipeNet(serverLevel).removeNode(pPos);
            }
        }
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext context) {
        int connections;
        block2: {
            VoxelShape shape;
            block3: {
                block4: {
                    BlockItem blockItem;
                    EntityCollisionContext entityCtx;
                    Entity entity;
                    IPipeNode<PipeType, NodeDataType> pipeNode = this.getPileTile(pLevel, pPos);
                    connections = 0;
                    if (pipeNode == null) break block2;
                    connections = pipeNode.getVisualConnections();
                    shape = this.getPipeModel().getShapes(connections);
                    shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])pipeNode.getCoverContainer().addCoverCollisionBoundingBox());
                    if (!(context instanceof EntityCollisionContext) || !((entity = (entityCtx = (EntityCollisionContext)context).m_193113_()) instanceof Player)) break block3;
                    Player player = (Player)entity;
                    ICoverable coverable = pipeNode.getCoverContainer();
                    ItemStack held = player.m_21205_();
                    if (held.m_204117_(GTToolType.WIRE_CUTTER.itemTag) || held.m_204117_(GTToolType.WRENCH.itemTag)) break block4;
                    if (CoverPlaceBehavior.isCoverBehaviorItem(held, coverable::hasAnyCover, coverDef -> ICoverable.canPlaceCover(coverDef, coverable))) break block4;
                    Item item = held.m_41720_();
                    if (!(item instanceof BlockItem) || !((item = (blockItem = (BlockItem)item).m_40614_()) instanceof PipeBlock)) break block3;
                    PipeBlock pipeBlock = (PipeBlock)item;
                    if (!((IPipeType)pipeBlock.pipeType).type().equals((Object)((IPipeType)this.pipeType).type())) break block3;
                }
                return Shapes.m_83110_((VoxelShape)Shapes.m_83144_(), (VoxelShape)shape);
            }
            return shape;
        }
        return this.getPipeModel().getShapes(connections);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == this.getBlockEntityType() && !level.f_46443_ && ((Boolean)state.m_61143_((Property)BlockProperties.SERVER_TICK)).booleanValue()) {
            return (pLevel, pPos, pState, pTile) -> {
                if (pTile instanceof IPipeNode) {
                    IPipeNode pipeNode = (IPipeNode)pTile;
                    pipeNode.serverTick();
                }
            };
        }
        return null;
    }

    @Override
    public BlockState getBlockAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState sourceState, BlockPos sourcePos) {
        BlockState appearance;
        IPipeNode<PipeType, NodeDataType> pipe = this.getPileTile((BlockGetter)level, pos);
        if (pipe != null && (appearance = pipe.getCoverContainer().getBlockAppearance(state, level, pos, side, sourceState, sourcePos)) != null) {
            return appearance;
        }
        return super.getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        LootParams context = builder.m_287286_(LootContextParams.f_81461_, (Object)state).m_287235_(LootContextParamSets.f_81421_);
        BlockEntity tileEntity = (BlockEntity)context.m_287267_(LootContextParams.f_81462_);
        if (tileEntity instanceof IPipeNode) {
            IPipeNode pipeTile = (IPipeNode)tileEntity;
            for (Direction direction : Direction.values()) {
                pipeTile.getCoverContainer().removeCover(direction, null);
            }
        }
        return super.m_49635_(state, builder);
    }
}

