/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.blockentity.forge;

import appeng.api.networking.IInWorldGridNodeHost;
import appeng.capabilities.Capabilities;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.capability.IPlatformEnergyStorage;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.capability.forge.GTEnergyHelperImpl;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.misc.LaserContainerList;
import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.client.renderer.GTRendererProvider;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidEndpointMachine;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemEndpointMachine;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidTransferHelperImpl;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.forge.ItemTransferHelperImpl;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaMachineBlockEntityImpl
extends MetaMachineBlockEntity {
    public MetaMachineBlockEntityImpl(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static MetaMachineBlockEntity createBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new MetaMachineBlockEntityImpl(type, pos, blockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional result = MetaMachineBlockEntityImpl.getCapability(this.getMetaMachine(), cap, side);
        return result == null ? super.getCapability(cap, side) : result;
    }

    @Nullable
    public static <T> LazyOptional<T> getCapability(MetaMachine machine, @NotNull Capability<T> cap, @Nullable Direction side) {
        List<Object> list;
        if (cap == GTCapability.CAPABILITY_COVERABLE) {
            return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(machine::getCoverContainer));
        }
        if (cap == GTCapability.CAPABILITY_TOOLABLE) {
            return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> machine));
        }
        if (cap == GTCapability.CAPABILITY_WORKABLE) {
            if (machine instanceof IWorkable) {
                IWorkable workable = (IWorkable)((Object)machine);
                return GTCapability.CAPABILITY_WORKABLE.orEmpty(cap, LazyOptional.of(() -> workable));
            }
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof IWorkable)) continue;
                IWorkable workable = (IWorkable)((Object)trait);
                return GTCapability.CAPABILITY_WORKABLE.orEmpty(cap, LazyOptional.of(() -> workable));
            }
        } else if (cap == GTCapability.CAPABILITY_CONTROLLABLE) {
            if (machine instanceof IControllable) {
                IControllable controllable = (IControllable)((Object)machine);
                return GTCapability.CAPABILITY_CONTROLLABLE.orEmpty(cap, LazyOptional.of(() -> controllable));
            }
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof IControllable)) continue;
                IControllable controllable = (IControllable)((Object)trait);
                return GTCapability.CAPABILITY_CONTROLLABLE.orEmpty(cap, LazyOptional.of(() -> controllable));
            }
        } else if (cap == GTCapability.CAPABILITY_RECIPE_LOGIC) {
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof RecipeLogic)) continue;
                RecipeLogic recipeLogic = (RecipeLogic)trait;
                return GTCapability.CAPABILITY_RECIPE_LOGIC.orEmpty(cap, LazyOptional.of(() -> recipeLogic));
            }
        } else if (cap == GTCapability.CAPABILITY_ENERGY_CONTAINER) {
            if (machine instanceof IEnergyContainer) {
                IEnergyContainer energyContainer = (IEnergyContainer)((Object)machine);
                return GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(cap, LazyOptional.of(() -> energyContainer));
            }
            list = machine.getTraits().stream().filter(IEnergyContainer.class::isInstance).filter(t -> t.hasCapability(side)).map(IEnergyContainer.class::cast).toList();
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(cap, LazyOptional.of(() -> list.size() == 1 ? (IEnergyContainer)list.get(0) : new EnergyContainerList(list)));
            }
        } else if (cap == GTCapability.CAPABILITY_CLEANROOM_RECEIVER) {
            if (machine instanceof ICleanroomReceiver) {
                ICleanroomReceiver cleanroomReceiver = (ICleanroomReceiver)((Object)machine);
                return GTCapability.CAPABILITY_CLEANROOM_RECEIVER.orEmpty(cap, LazyOptional.of(() -> cleanroomReceiver));
            }
        } else if (cap == GTCapability.CAPABILITY_MAINTENANCE_MACHINE) {
            if (machine instanceof IMaintenanceMachine) {
                IMaintenanceMachine maintenanceMachine = (IMaintenanceMachine)((Object)machine);
                return GTCapability.CAPABILITY_MAINTENANCE_MACHINE.orEmpty(cap, LazyOptional.of(() -> maintenanceMachine));
            }
        } else if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (machine instanceof LDItemEndpointMachine) {
                fluidEndpointMachine = (LDItemEndpointMachine)machine;
                if (machine.getLevel().f_46443_) {
                    return null;
                }
                ILDEndpoint endpoint = fluidEndpointMachine.getLink();
                if (endpoint == null) {
                    return null;
                }
                Direction outputFacing = fluidEndpointMachine.getOutputFacing();
                IItemTransfer transfer = ItemTransferHelperImpl.getItemTransfer((Level)machine.getLevel(), (BlockPos)endpoint.getPos().m_121945_(outputFacing), (Direction)outputFacing.m_122424_());
                if (transfer != null) {
                    return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> ItemTransferHelperImpl.toItemHandler((IItemTransfer)new LDItemEndpointMachine.ItemHandlerWrapper(transfer))));
                }
            }
            if ((transfer = machine.getItemTransferCap(side, true)) != null) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> ItemTransferHelperImpl.toItemHandler((IItemTransfer)transfer)));
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (machine instanceof LDFluidEndpointMachine) {
                fluidEndpointMachine = (LDFluidEndpointMachine)machine;
                if (machine.getLevel().f_46443_) {
                    return null;
                }
                ILDEndpoint endpoint = fluidEndpointMachine.getLink();
                if (endpoint == null) {
                    return null;
                }
                Direction outputFacing = fluidEndpointMachine.getOutputFacing();
                IFluidTransfer transfer = FluidTransferHelper.getFluidTransfer((Level)machine.getLevel(), (BlockPos)endpoint.getPos().m_121945_(outputFacing), (Direction)outputFacing.m_122424_());
                if (transfer != null) {
                    return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> FluidTransferHelperImpl.toFluidHandler((IFluidTransfer)new LDFluidEndpointMachine.FluidHandlerWrapper(transfer))));
                }
            }
            if ((transfer = machine.getFluidTransferCap(side, true)) != null) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> MetaMachineBlockEntityImpl.lambda$getCapability$14((IFluidTransfer)transfer)));
            }
        } else if (cap == ForgeCapabilities.ENERGY) {
            if (machine instanceof IPlatformEnergyStorage) {
                IPlatformEnergyStorage platformEnergyStorage = (IPlatformEnergyStorage)((Object)machine);
                return ForgeCapabilities.ENERGY.orEmpty(cap, LazyOptional.of(() -> GTEnergyHelperImpl.toEnergyStorage(platformEnergyStorage)));
            }
            list = machine.getTraits().stream().filter(IPlatformEnergyStorage.class::isInstance).filter(t -> t.hasCapability(side)).map(IPlatformEnergyStorage.class::cast).toList();
            if (!list.isEmpty()) {
                return ForgeCapabilities.ENERGY.orEmpty(cap, LazyOptional.of(() -> GTEnergyHelperImpl.toEnergyStorage((IPlatformEnergyStorage)list.get(0))));
            }
        } else if (cap == GTCapability.CAPABILITY_LASER) {
            if (machine instanceof ILaserContainer) {
                ILaserContainer energyContainer = (ILaserContainer)((Object)machine);
                return GTCapability.CAPABILITY_LASER.orEmpty(cap, LazyOptional.of(() -> energyContainer));
            }
            list = machine.getTraits().stream().filter(ILaserContainer.class::isInstance).filter(t -> t.hasCapability(side)).map(ILaserContainer.class::cast).toList();
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_LASER.orEmpty(cap, LazyOptional.of(() -> list.size() == 1 ? (ILaserContainer)list.get(0) : new LaserContainerList(list)));
            }
        }
        if (GTCEu.isAE2Loaded() && cap == Capabilities.IN_WORLD_GRID_NODE_HOST) {
            if (machine instanceof IInWorldGridNodeHost) {
                IInWorldGridNodeHost nodeHost = (IInWorldGridNodeHost)machine;
                return Capabilities.IN_WORLD_GRID_NODE_HOST.orEmpty(cap, LazyOptional.of(() -> nodeHost));
            }
            list = machine.getTraits().stream().filter(IInWorldGridNodeHost.class::isInstance).filter(t -> t.hasCapability(side)).map(IInWorldGridNodeHost.class::cast).toList();
            if (!list.isEmpty()) {
                return Capabilities.IN_WORLD_GRID_NODE_HOST.orEmpty(cap, LazyOptional.of(() -> (IInWorldGridNodeHost)list.get(0)));
            }
        }
        return null;
    }

    public static void onBlockEntityRegister(BlockEntityType<BlockEntity> metaMachineBlockEntityBlockEntityType) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        IRenderer renderer;
        GTRendererProvider instance = GTRendererProvider.getInstance();
        if (instance != null && (renderer = instance.getRenderer(this)) != null) {
            if (renderer.getViewDistance() == 64) {
                return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 2, 2));
            }
            int viewDistHalf = renderer.getViewDistance() / 2;
            return new AABB(this.f_58858_).m_82400_((double)viewDistHalf);
        }
        return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 2, 2));
    }

    private static /* synthetic */ IFluidHandler lambda$getCapability$14(IFluidTransfer transfer) {
        return FluidTransferHelperImpl.toFluidHandler((IFluidTransfer)transfer);
    }
}

