/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.forge.compat;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IPlatformEnergyStorage;
import com.gregtechceu.gtceu.api.capability.PlatformEnergyCompat;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.capability.forge.GTEnergyHelperImpl;
import com.gregtechceu.gtceu.api.capability.forge.compat.CapabilityCompatProvider;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EUToFEProvider
extends CapabilityCompatProvider {
    private long feBuffer;

    public EUToFEProvider(BlockEntity tileEntity) {
        super((ICapabilityProvider)tileEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (!ConfigHolder.INSTANCE.compat.energy.nativeEUToPlatformNative || capability != GTCapability.CAPABILITY_ENERGY_CONTAINER) {
            return LazyOptional.empty();
        }
        LazyOptional energyStorage = this.getUpvalueCapability(ForgeCapabilities.ENERGY, facing);
        return energyStorage.isPresent() ? GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(capability, LazyOptional.of(() -> new GTEnergyWrapper((IEnergyStorage)energyStorage.resolve().get()))) : LazyOptional.empty();
    }

    public static int safeCastLongToInt(long v) {
        return v > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v;
    }

    public class GTEnergyWrapper
    implements IEnergyContainer {
        private final IPlatformEnergyStorage energyStorage;

        public GTEnergyWrapper(IEnergyStorage energyStorage) {
            this.energyStorage = GTEnergyHelperImpl.toPlatformEnergyStorage(energyStorage);
        }

        @Override
        public long acceptEnergyFromNetwork(Direction facing, long voltage, long amperage) {
            long receive = 0L;
            if (EUToFEProvider.this.feBuffer > 0L) {
                receive = this.energyStorage.insert(EUToFEProvider.safeCastLongToInt(EUToFEProvider.this.feBuffer), true);
                if (receive == 0L) {
                    return 0L;
                }
                if (EUToFEProvider.this.feBuffer > receive) {
                    EUToFEProvider.this.feBuffer -= receive;
                    this.energyStorage.insert(receive, false);
                    return 0L;
                }
                receive = EUToFEProvider.safeCastLongToInt(EUToFEProvider.this.feBuffer);
                EUToFEProvider.this.feBuffer = 0L;
            }
            long maxPacket = PlatformEnergyCompat.toNativeLong(voltage, PlatformEnergyCompat.ratio(false));
            long maximalValue = maxPacket * amperage;
            if (receive != 0L) {
                long consumable = this.energyStorage.insert(EUToFEProvider.safeCastLongToInt(maximalValue + receive), true);
                if (consumable == 0L) {
                    return 0L;
                }
                if (consumable == receive) {
                    this.energyStorage.insert(consumable, false);
                    return 0L;
                }
                if (consumable == maximalValue + receive) {
                    this.energyStorage.insert(consumable, false);
                    return amperage;
                }
                long newPower = consumable - receive;
                if (newPower % maxPacket == 0L) {
                    return this.energyStorage.insert(consumable, false) / maxPacket;
                }
                int ampsToConsume = EUToFEProvider.safeCastLongToInt(newPower / maxPacket + 1L);
                EUToFEProvider.this.feBuffer = EUToFEProvider.safeCastLongToInt(maxPacket * (long)ampsToConsume - consumable);
                this.energyStorage.insert(consumable, false);
                return ampsToConsume;
            }
            long consumable = this.energyStorage.insert(EUToFEProvider.safeCastLongToInt(maximalValue), true);
            if (consumable == 0L) {
                return 0L;
            }
            if (consumable == maximalValue) {
                this.energyStorage.insert(consumable, false);
                return amperage;
            }
            if (consumable % maxPacket == 0L) {
                return this.energyStorage.insert(consumable, false) / maxPacket;
            }
            int ampsToConsume = EUToFEProvider.safeCastLongToInt(consumable / maxPacket + 1L);
            EUToFEProvider.this.feBuffer = EUToFEProvider.safeCastLongToInt(maxPacket * (long)ampsToConsume - consumable);
            this.energyStorage.insert(consumable, false);
            return ampsToConsume;
        }

        @Override
        public long changeEnergy(long delta) {
            if (delta == 0L) {
                return 0L;
            }
            if (delta < 0L) {
                return PlatformEnergyCompat.extractEu(this.energyStorage, -delta);
            }
            return PlatformEnergyCompat.insertEu(this.energyStorage, delta);
        }

        @Override
        public long getEnergyCapacity() {
            return PlatformEnergyCompat.toEu(this.energyStorage.getCapacity(), PlatformEnergyCompat.ratio(false));
        }

        @Override
        public long getEnergyStored() {
            return PlatformEnergyCompat.toEu(this.energyStorage.getAmount(), PlatformEnergyCompat.ratio(false));
        }

        @Override
        public long getEnergyCanBeInserted() {
            return Math.max(1L, this.getEnergyCapacity() - this.getEnergyStored());
        }

        @Override
        public long getInputAmperage() {
            return this.getInputVoltage() == 0L ? 0L : 2L;
        }

        @Override
        public long getInputVoltage() {
            long maxInput = this.energyStorage.insert(Integer.MAX_VALUE, true);
            if (maxInput == 0L) {
                return 0L;
            }
            return GTValues.V[GTUtil.getTierByVoltage(PlatformEnergyCompat.toEu(maxInput, PlatformEnergyCompat.ratio(false)))];
        }

        @Override
        public boolean inputsEnergy(Direction facing) {
            return this.energyStorage.supportsInsertion();
        }

        @Override
        public boolean outputsEnergy(Direction facing) {
            return false;
        }

        @Override
        public boolean isOneProbeHidden() {
            return true;
        }
    }
}

