/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.factory.CoverUIFactory;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighLight;
import com.gregtechceu.gtceu.api.syncdata.EnhancedFieldManagedStorage;
import com.gregtechceu.gtceu.api.syncdata.IEnhancedManaged;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CoverBehavior
implements IEnhancedManaged,
IToolGridHighLight {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CoverBehavior.class);
    private final EnhancedFieldManagedStorage syncStorage = new EnhancedFieldManagedStorage(this);
    public final CoverDefinition coverDefinition;
    public final ICoverable coverHolder;
    public final Direction attachedSide;
    @Persisted
    @DescSynced
    protected ItemStack attachItem = ItemStack.f_41583_;
    @Persisted
    protected int redstoneSignalOutput = 0;

    public CoverBehavior(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        this.coverDefinition = definition;
        this.coverHolder = coverHolder;
        this.attachedSide = attachedSide;
    }

    @Override
    public void scheduleRenderUpdate() {
        this.coverHolder.scheduleRenderUpdate();
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.coverHolder.getLevel();
        if (level != null && !level.f_46443_ && level.m_7654_() != null) {
            level.m_7654_().execute(this.coverHolder::markDirty);
        }
    }

    public boolean canAttach() {
        return true;
    }

    public void onAttached(ItemStack itemStack, ServerPlayer player) {
        this.attachItem = itemStack.m_41777_();
        this.attachItem.m_41764_(1);
    }

    public void onLoad() {
    }

    public void onUnload() {
    }

    public ItemStack getPickItem() {
        return this.attachItem;
    }

    public List<ItemStack> getAdditionalDrops() {
        return new ArrayList<ItemStack>();
    }

    public void onRemoved() {
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
    }

    public void setRedstoneSignalOutput(int redstoneSignalOutput) {
        this.redstoneSignalOutput = redstoneSignalOutput;
        this.coverHolder.notifyBlockUpdate();
        this.coverHolder.markDirty();
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, BlockHitResult hitResult) {
        if (this instanceof IUICover) {
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                CoverUIFactory.INSTANCE.openUI(this, serverPlayer);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    public boolean blockPipePassThrough() {
        return true;
    }

    public boolean shouldRenderPlate() {
        return true;
    }

    public ICoverRenderer getCoverRenderer() {
        return this.coverDefinition.getCoverRenderer();
    }

    @Override
    public boolean shouldRenderGrid(Player player, ItemStack held, GTToolType toolType) {
        return toolType == GTToolType.CROWBAR || toolType == GTToolType.SCREWDRIVER && this instanceof IUICover;
    }

    @Override
    public ResourceTexture sideTips(Player player, GTToolType toolType, Direction side) {
        if (toolType == GTToolType.CROWBAR) {
            return GuiTextures.TOOL_REMOVE_COVER;
        }
        if (toolType == GTToolType.SCREWDRIVER && this instanceof IUICover) {
            return GuiTextures.TOOL_COVER_SETTINGS;
        }
        return null;
    }

    @Nullable
    public BlockState getAppearance(BlockState sourceState, BlockPos sourcePos) {
        return null;
    }

    public IItemTransfer getItemTransferCap(Direction side, IItemTransfer defaultValue) {
        return defaultValue;
    }

    public IFluidTransfer getFluidTransferCap(Direction side, IFluidTransfer defaultValue) {
        return defaultValue;
    }

    public EnhancedFieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    public ItemStack getAttachItem() {
        return this.attachItem;
    }

    public int getRedstoneSignalOutput() {
        return this.redstoneSignalOutput;
    }
}

