/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.chemical.material;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.Element;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlag;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.AlloyBlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IMaterialProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.MaterialProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.RotorProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.integration.kjs.helpers.MaterialStackWrapper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.material.Fluid;

public class Material
implements Comparable<Material> {
    @Nonnull
    private final MaterialInfo materialInfo;
    @Nonnull
    private final MaterialProperties properties;
    @Nonnull
    private final MaterialFlags flags;
    private String chemicalFormula;

    private String calculateChemicalFormula() {
        if (this.chemicalFormula != null) {
            return this.chemicalFormula;
        }
        if (this.materialInfo.element != null) {
            Object result;
            String[] split = this.materialInfo.element.symbol().split("-");
            if (split.length > 1) {
                split[1] = FormattingUtil.toSmallUpNumbers(split[1]);
                result = split[0] + split[1];
            } else {
                result = this.materialInfo.element.symbol();
            }
            return result;
        }
        if (!this.materialInfo.componentList.isEmpty()) {
            StringBuilder components = new StringBuilder();
            for (MaterialStack component : this.materialInfo.componentList) {
                components.append(component.toString());
            }
            return components.toString();
        }
        return "";
    }

    public String getChemicalFormula() {
        return this.chemicalFormula;
    }

    public Material setFormula(String formula) {
        return this.setFormula(formula, true);
    }

    public Material setFormula(String formula, boolean withFormatting) {
        this.chemicalFormula = withFormatting ? FormattingUtil.toSmallDownNumbers(formula) : formula;
        return this;
    }

    public ImmutableList<MaterialStack> getMaterialComponents() {
        return this.materialInfo.componentList;
    }

    public MaterialStack[] getMaterialComponentsCt() {
        return (MaterialStack[])this.getMaterialComponents().toArray((Object[])new MaterialStack[0]);
    }

    private Material(@Nonnull MaterialInfo materialInfo, @Nonnull MaterialProperties properties, @Nonnull MaterialFlags flags) {
        this.materialInfo = materialInfo;
        this.properties = properties;
        this.flags = flags;
        this.properties.setMaterial(this);
        this.verifyMaterial();
    }

    protected Material(String name) {
        this.materialInfo = new MaterialInfo(name);
        this.materialInfo.iconSet = MaterialIconSet.DULL;
        this.properties = new MaterialProperties();
        this.flags = new MaterialFlags();
    }

    protected void registerMaterial() {
        GTRegistries.MATERIALS.register(this.materialInfo.name, this);
    }

    public String getName() {
        return this.materialInfo.name;
    }

    public void addFlags(MaterialFlag ... flags) {
        if (GTRegistries.MATERIALS.isFrozen()) {
            throw new IllegalStateException("Cannot add flag to material when registry is frozen!");
        }
        this.flags.addFlags(flags).verify(this);
    }

    public void addFlags(String ... names) {
        this.addFlags((MaterialFlag[])Arrays.stream(names).map(MaterialFlag::getByName).filter(Objects::nonNull).toArray(MaterialFlag[]::new));
    }

    public boolean hasFlag(MaterialFlag flag) {
        return this.flags.hasFlag(flag);
    }

    public boolean isElement() {
        return this.materialInfo.element != null;
    }

    @Nullable
    public Element getElement() {
        return this.materialInfo.element;
    }

    public boolean hasFlags(MaterialFlag ... flags) {
        return Arrays.stream(flags).allMatch(this::hasFlag);
    }

    public boolean hasAnyOfFlags(MaterialFlag ... flags) {
        return Arrays.stream(flags).anyMatch(this::hasFlag);
    }

    protected void calculateDecompositionType() {
        if (!(this.materialInfo.componentList.isEmpty() || this.hasFlag(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING) || this.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) || this.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION))) {
            boolean onlyMetalMaterials = true;
            for (MaterialStack materialStack : this.materialInfo.componentList) {
                Material material = materialStack.material();
                onlyMetalMaterials &= material.hasProperty(PropertyKey.INGOT);
            }
            if (onlyMetalMaterials) {
                this.flags.addFlags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING);
            } else {
                this.flags.addFlags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING);
            }
        }
    }

    public Fluid getFluid() {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.getName() + " does not have a Fluid!");
        }
        FluidStorageKey key = prop.getPrimaryKey();
        Fluid fluid = null;
        if (key != null) {
            fluid = prop.getStorage().get(key);
        }
        if (fluid != null) {
            return fluid;
        }
        fluid = this.getFluid(FluidStorageKeys.LIQUID);
        if (fluid != null) {
            return fluid;
        }
        return this.getFluid(FluidStorageKeys.GAS);
    }

    public Fluid getFluid(@Nonnull FluidStorageKey key) {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.getName() + " does not have a Fluid!");
        }
        return prop.getStorage().get(key);
    }

    public FluidStack getFluid(long amount) {
        return FluidStack.create((Fluid)this.getFluid(), (long)amount);
    }

    public FluidStack getFluid(@Nonnull FluidStorageKey key, long amount) {
        return FluidStack.create((Fluid)this.getFluid(key), (long)amount);
    }

    public MaterialToolTier getToolTier() {
        ToolProperty prop = this.getProperty(PropertyKey.TOOL);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.materialInfo.name + " does not have a tool!");
        }
        return prop.getTier(this);
    }

    public Fluid getHotFluid() {
        AlloyBlastProperty prop = this.properties.getProperty(PropertyKey.ALLOY_BLAST);
        return prop == null ? null : prop.getFluid();
    }

    public FluidStack getHotFluid(long amount) {
        AlloyBlastProperty prop = this.properties.getProperty(PropertyKey.ALLOY_BLAST);
        return prop == null ? null : FluidStack.create((Fluid)prop.getFluid(), (long)amount);
    }

    public Item getBucket() {
        Fluid fluid = this.getFluid();
        return fluid.m_6859_();
    }

    public int getBlockHarvestLevel() {
        if (!this.hasProperty(PropertyKey.DUST)) {
            throw new IllegalArgumentException("Material " + this.materialInfo.name + " does not have a harvest level! Is probably a Fluid");
        }
        int harvestLevel = this.getProperty(PropertyKey.DUST).getHarvestLevel();
        return harvestLevel > 0 ? harvestLevel - 1 : harvestLevel;
    }

    public int getToolHarvestLevel() {
        if (!this.hasProperty(PropertyKey.TOOL)) {
            throw new IllegalArgumentException("Material " + this.materialInfo.name + " does not have a tool harvest level! Is probably not a Tool Material");
        }
        return this.getProperty(PropertyKey.TOOL).getHarvestLevel();
    }

    public void setMaterialRGB(int materialRGB) {
        this.materialInfo.color = materialRGB;
    }

    public int getLayerARGB(int layerIndex) {
        return switch (layerIndex) {
            case -101, 0 -> this.getMaterialARGB();
            case -111, 1 -> {
                if (this.getMaterialSecondaryARGB() != -1) {
                    yield this.getMaterialSecondaryARGB();
                }
                yield this.getMaterialARGB();
            }
            default -> -1;
        };
    }

    public int getMaterialARGB() {
        return this.materialInfo.color | 0xFF000000;
    }

    public int getMaterialSecondaryARGB() {
        return this.materialInfo.secondaryColor | 0xFF000000;
    }

    public int getMaterialRGB() {
        return this.materialInfo.color;
    }

    public int getMaterialSecondaryRGB() {
        return this.materialInfo.secondaryColor;
    }

    public boolean hasFluidColor() {
        return this.materialInfo.hasFluidColor;
    }

    public void setMaterialIconSet(MaterialIconSet materialIconSet) {
        this.materialInfo.iconSet = materialIconSet;
    }

    public MaterialIconSet getMaterialIconSet() {
        return this.materialInfo.iconSet;
    }

    public boolean isRadioactive() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.halfLifeSeconds() >= 0L;
        }
        for (MaterialStack material : this.materialInfo.componentList) {
            if (!material.material().isRadioactive()) continue;
            return true;
        }
        return false;
    }

    public long getProtons() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.protons();
        }
        if (this.materialInfo.componentList.isEmpty()) {
            return Math.max(1, 43);
        }
        long totalProtons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount();
            totalProtons += material.amount() * material.material().getProtons();
        }
        return totalProtons / totalAmount;
    }

    public long getNeutrons() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.neutrons();
        }
        if (this.materialInfo.componentList.isEmpty()) {
            return 55L;
        }
        long totalNeutrons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount();
            totalNeutrons += material.amount() * material.material().getNeutrons();
        }
        return totalNeutrons / totalAmount;
    }

    public long getMass() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.mass();
        }
        if (this.materialInfo.componentList.size() == 0) {
            return 98L;
        }
        long totalMass = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount();
            totalMass += material.amount() * material.material().getMass();
        }
        return totalMass / totalAmount;
    }

    public int getBlastTemperature() {
        BlastProperty prop = this.properties.getProperty(PropertyKey.BLAST);
        return prop == null ? 0 : prop.getBlastTemperature();
    }

    public String toCamelCaseString() {
        return FormattingUtil.lowerUnderscoreToUpperCamel(this.toString());
    }

    public String getUnlocalizedName() {
        return "material." + this.materialInfo.name;
    }

    public MutableComponent getLocalizedName() {
        return Component.m_237115_((String)this.getUnlocalizedName());
    }

    @Override
    public int compareTo(Material material) {
        return this.toString().compareTo(material.toString());
    }

    public String toString() {
        return this.materialInfo.name;
    }

    public MaterialStack multiply(long amount) {
        return new MaterialStack(this, amount);
    }

    @Nonnull
    public MaterialProperties getProperties() {
        return this.properties;
    }

    public <T extends IMaterialProperty<T>> boolean hasProperty(PropertyKey<T> key) {
        return this.getProperty(key) != null;
    }

    public <T extends IMaterialProperty<T>> T getProperty(PropertyKey<T> key) {
        return this.properties.getProperty(key);
    }

    public <T extends IMaterialProperty<T>> void setProperty(PropertyKey<T> key, IMaterialProperty<T> property) {
        if (GTRegistries.MATERIALS.isFrozen()) {
            throw new IllegalStateException("Cannot add properties to a Material when registry is frozen!");
        }
        this.properties.setProperty(key, property);
        this.properties.verify();
    }

    public boolean isSolid() {
        return this.hasProperty(PropertyKey.INGOT) || this.hasProperty(PropertyKey.GEM);
    }

    public boolean hasFluid() {
        return this.hasProperty(PropertyKey.FLUID);
    }

    public void verifyMaterial() {
        this.properties.verify();
        this.flags.verify(this);
        this.chemicalFormula = this.calculateChemicalFormula();
        this.calculateDecompositionType();
    }

    private static class MaterialInfo {
        private final String name;
        private int color = -1;
        private int secondaryColor = -1;
        private boolean hasFluidColor = true;
        private MaterialIconSet iconSet;
        private ImmutableList<MaterialStack> componentList;
        private Element element;

        private MaterialInfo(String name) {
            if (!FormattingUtil.toLowerCaseUnderscore(FormattingUtil.lowerUnderscoreToUpperCamel(name)).equals(name)) {
                throw new IllegalStateException("Cannot add materials with names like 'materialnumber'! Use 'material_number' instead.");
            }
            this.name = name;
        }

        private void verifyInfo(MaterialProperties p, boolean averageRGB) {
            if (this.iconSet == null) {
                this.iconSet = p.hasProperty(PropertyKey.GEM) ? MaterialIconSet.GEM_VERTICAL : (p.hasProperty(PropertyKey.DUST) || p.hasProperty(PropertyKey.INGOT) || p.hasProperty(PropertyKey.POLYMER) ? MaterialIconSet.DULL : (p.hasProperty(PropertyKey.FLUID) ? MaterialIconSet.FLUID : MaterialIconSet.DULL));
            }
            if (this.color == -1) {
                if (!averageRGB || this.componentList.isEmpty()) {
                    this.color = 0xFFFFFF;
                } else {
                    long colorTemp = 0L;
                    int divisor = 0;
                    for (MaterialStack stack : this.componentList) {
                        colorTemp += (long)stack.material().getMaterialARGB() * stack.amount();
                        divisor = (int)((long)divisor + stack.amount());
                    }
                    this.color = (int)(colorTemp / (long)divisor);
                }
            }
        }
    }

    @RemapPrefixForJS(value="kjs$")
    public static class Builder
    extends BuilderBase<Material> {
        private final MaterialInfo materialInfo;
        private final MaterialProperties properties;
        private final MaterialFlags flags;
        private List<MaterialStack> composition = new ArrayList<MaterialStack>();
        private List<MaterialStackWrapper> compositionSupplier;
        private boolean averageRGB = false;

        public Builder(String name) {
            super(GTCEu.id(name), new Object[0]);
            if (name.charAt(name.length() - 1) == '_') {
                throw new IllegalArgumentException("Material name cannot end with a '_'!");
            }
            this.materialInfo = new MaterialInfo(name);
            this.properties = new MaterialProperties();
            this.flags = new MaterialFlags();
        }

        public Builder(ResourceLocation id, Object ... args) {
            this(id.m_135815_());
        }

        public Builder fluid() {
            this.fluid(FluidStorageKeys.LIQUID, new FluidBuilder());
            return this;
        }

        public Builder fluid(@Nonnull FluidStorageKey key, @Nonnull FluidState state) {
            return this.fluid(key, new FluidBuilder().state(state));
        }

        public Builder fluid(@Nonnull FluidStorageKey key, @Nonnull FluidBuilder builder) {
            this.properties.ensureSet(PropertyKey.FLUID);
            FluidProperty property = this.properties.getProperty(PropertyKey.FLUID);
            property.getStorage().enqueueRegistration(key, builder);
            return this;
        }

        public Builder plasma() {
            return this.fluid(FluidStorageKeys.PLASMA, FluidState.PLASMA);
        }

        public Builder gas() {
            return this.fluid(FluidStorageKeys.GAS, FluidState.GAS);
        }

        public Builder dust() {
            this.properties.ensureSet(PropertyKey.DUST);
            return this;
        }

        public Builder dust(int harvestLevel) {
            return this.dust(harvestLevel, 0);
        }

        public Builder dust(int harvestLevel, int burnTime) {
            this.properties.setProperty(PropertyKey.DUST, new DustProperty(harvestLevel, burnTime));
            return this;
        }

        public Builder wood() {
            return this.wood(0, 300);
        }

        public Builder wood(int harvestLevel) {
            return this.wood(harvestLevel, 300);
        }

        public Builder wood(int harvestLevel, int burnTime) {
            this.properties.setProperty(PropertyKey.DUST, new DustProperty(harvestLevel, burnTime));
            this.properties.ensureSet(PropertyKey.WOOD);
            return this;
        }

        public Builder ingot() {
            this.properties.ensureSet(PropertyKey.INGOT);
            return this;
        }

        public Builder ingot(int harvestLevel) {
            return this.ingot(harvestLevel, 0);
        }

        public Builder ingot(int harvestLevel, int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, burnTime);
            } else {
                if (prop.getHarvestLevel() == 2) {
                    prop.setHarvestLevel(harvestLevel);
                }
                if (prop.getBurnTime() == 0) {
                    prop.setBurnTime(burnTime);
                }
            }
            this.properties.ensureSet(PropertyKey.INGOT);
            return this;
        }

        public Builder gem() {
            this.properties.ensureSet(PropertyKey.GEM);
            return this;
        }

        public Builder gem(int harvestLevel) {
            return this.gem(harvestLevel, 0);
        }

        public Builder gem(int harvestLevel, int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, burnTime);
            } else {
                if (prop.getHarvestLevel() == 2) {
                    prop.setHarvestLevel(harvestLevel);
                }
                if (prop.getBurnTime() == 0) {
                    prop.setBurnTime(burnTime);
                }
            }
            this.properties.ensureSet(PropertyKey.GEM);
            return this;
        }

        public Builder polymer() {
            this.properties.ensureSet(PropertyKey.POLYMER);
            return this;
        }

        public Builder polymer(int harvestLevel) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, 0);
            } else if (prop.getHarvestLevel() == 2) {
                prop.setHarvestLevel(harvestLevel);
            }
            this.properties.ensureSet(PropertyKey.POLYMER);
            this.properties.ensureSet(PropertyKey.FLUID);
            return this;
        }

        public Builder burnTime(int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust();
                prop = this.properties.getProperty(PropertyKey.DUST);
            }
            prop.setBurnTime(burnTime);
            return this;
        }

        public Builder color(int color) {
            this.color(color, true);
            return this;
        }

        public Builder color(int color, boolean hasFluidColor) {
            this.materialInfo.color = color;
            this.materialInfo.hasFluidColor = hasFluidColor;
            return this;
        }

        public Builder secondaryColor(int color) {
            this.materialInfo.secondaryColor = color;
            return this;
        }

        public Builder colorAverage() {
            this.averageRGB = true;
            return this;
        }

        public Builder iconSet(MaterialIconSet iconSet) {
            this.materialInfo.iconSet = iconSet;
            return this;
        }

        public Builder components(Object ... components) {
            Preconditions.checkArgument((components.length % 2 == 0 ? 1 : 0) != 0, (Object)"Material Components list malformed!");
            for (int i = 0; i < components.length; i += 2) {
                Material material;
                if (components[i] == null) {
                    throw new IllegalArgumentException("Material in Components List is null for Material " + this.materialInfo.name);
                }
                Object object = components[i];
                if (object instanceof CharSequence) {
                    CharSequence chars = (CharSequence)object;
                    material = GTMaterials.get(chars.toString());
                } else {
                    material = (Material)components[i];
                }
                this.composition.add(new MaterialStack(material, ((Number)components[i + 1]).longValue()));
            }
            return this;
        }

        public Builder componentStacks(MaterialStack ... components) {
            this.composition = Arrays.asList(components);
            return this;
        }

        public Builder componentStacks(ImmutableList<MaterialStack> components) {
            this.composition = components;
            return this;
        }

        public Builder kjs$components(MaterialStackWrapper ... components) {
            this.compositionSupplier = Arrays.asList(components);
            return this;
        }

        public Builder flags(MaterialFlag ... flags) {
            this.flags.addFlags(flags);
            return this;
        }

        public Builder appendFlags(Collection<MaterialFlag> f1, MaterialFlag ... f2) {
            this.flags.addFlags(f1.toArray(new MaterialFlag[0]));
            this.flags.addFlags(f2);
            return this;
        }

        public Builder element(Element element) {
            this.materialInfo.element = element;
            return this;
        }

        public Builder toolStats(ToolProperty toolProperty) {
            this.properties.setProperty(PropertyKey.TOOL, toolProperty);
            return this;
        }

        public Builder rotorStats(float speed, float damage, int durability) {
            this.properties.setProperty(PropertyKey.ROTOR, new RotorProperty(speed, damage, durability));
            return this;
        }

        public Builder blastTemp(int temp) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp));
            return this;
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp, gasTier, -1, -1));
            return this;
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier, int eutOverride) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp, gasTier, eutOverride, -1));
            return this;
        }

        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier, int eutOverride, int durationOverride) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp, gasTier, eutOverride, durationOverride));
            return this;
        }

        public Builder ore() {
            this.properties.ensureSet(PropertyKey.ORE);
            return this;
        }

        public Builder ore(boolean emissive) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(1, 1, emissive));
            return this;
        }

        public Builder ore(int oreMultiplier, int byproductMultiplier) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier));
            return this;
        }

        public Builder ore(int oreMultiplier, int byproductMultiplier, boolean emissive) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier, emissive));
            return this;
        }

        public Builder fluidBurnTime(int burnTime) {
            return this;
        }

        public Builder washedIn(Material m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setWashedIn(m);
            return this;
        }

        public Builder washedIn(Material m, int washedAmount) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setWashedIn(m, washedAmount);
            return this;
        }

        public Builder separatedInto(Material ... m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setSeparatedInto(m);
            return this;
        }

        public Builder oreSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setDirectSmeltResult(m);
            return this;
        }

        public Builder polarizesInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setMagneticMaterial(m);
            return this;
        }

        public Builder arcSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setArcSmeltingInto(m);
            return this;
        }

        public Builder macerateInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setMacerateInto(m);
            return this;
        }

        public Builder ingotSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setSmeltingInto(m);
            return this;
        }

        public Builder addOreByproducts(Material ... byproducts) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setOreByProducts(byproducts);
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss) {
            this.cableProperties((int)voltage, amperage, loss, false);
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss, boolean isSuperCon) {
            this.properties.ensureSet(PropertyKey.DUST);
            this.properties.setProperty(PropertyKey.WIRE, new WireProperties((int)voltage, amperage, loss, isSuperCon));
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss, boolean isSuperCon, int criticalTemperature) {
            this.properties.ensureSet(PropertyKey.DUST);
            this.properties.setProperty(PropertyKey.WIRE, new WireProperties((int)voltage, amperage, loss, isSuperCon, criticalTemperature));
            return this;
        }

        public Builder fluidPipeProperties(int maxTemp, int throughput, boolean gasProof) {
            return this.fluidPipeProperties(maxTemp, throughput, gasProof, false, false, false);
        }

        public Builder fluidPipeProperties(int maxTemp, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
            this.properties.setProperty(PropertyKey.FLUID_PIPE, new FluidPipeProperties(maxTemp, throughput, gasProof, acidProof, cryoProof, plasmaProof));
            return this;
        }

        public Builder itemPipeProperties(int priority, float stacksPerSec) {
            this.properties.setProperty(PropertyKey.ITEM_PIPE, new ItemPipeProperties(priority, stacksPerSec));
            return this;
        }

        @Deprecated
        public Builder addDefaultEnchant(Enchantment enchant, int level) {
            if (!this.properties.hasProperty(PropertyKey.TOOL)) {
                throw new IllegalArgumentException("Material cannot have an Enchant without Tools!");
            }
            this.properties.getProperty(PropertyKey.TOOL).addEnchantmentForTools(enchant, level);
            return this;
        }

        public Material buildAndRegister() {
            this.materialInfo.componentList = this.composition.isEmpty() && this.compositionSupplier != null ? ImmutableList.copyOf((Object[])((MaterialStack[])this.compositionSupplier.stream().map(MaterialStackWrapper::toMatStack).toArray(MaterialStack[]::new))) : ImmutableList.copyOf(this.composition);
            Material mat = new Material(this.materialInfo, this.properties, this.flags);
            this.materialInfo.verifyInfo(this.properties, this.averageRGB);
            mat.registerMaterial();
            return mat;
        }

        @Override
        public Material register() {
            this.value = this.buildAndRegister();
            return this.value;
        }
    }
}

