/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.indicators.SurfaceIndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.DikeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.GeodeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.LayeredVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.StandardVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.VeinedVeinGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTOreDefinition {
    public static final Codec<GTOreDefinition> CODEC = ResourceLocation.f_135803_.flatXmap(rl -> Optional.ofNullable((GTOreDefinition)GTRegistries.ORE_VEINS.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No GTOreDefinition with id " + rl + " registered")), obj -> Optional.ofNullable((ResourceLocation)GTRegistries.ORE_VEINS.getKey((GTOreDefinition)obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "GTOreDefinition " + obj + " not registered")));
    public static final Codec<GTOreDefinition> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("cluster_size").forGetter(ft -> ft.clusterSize), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("density").forGetter(ft -> Float.valueOf(ft.density)), (App)Codec.INT.fieldOf("weight").forGetter(ft -> ft.weight), (App)IWorldGenLayer.CODEC.fieldOf("layer").forGetter(ft -> ft.layer), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().fieldOf("dimension_filter").forGetter(ft -> new ArrayList<ResourceKey<Level>>(ft.dimensionFilter)), (App)HeightRangePlacement.f_191673_.fieldOf("height_range").forGetter(ft -> ft.range), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(ft -> Float.valueOf(ft.discardChanceOnAirExposure)), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).optionalFieldOf("biomes", null).forGetter(ext -> ext.biomes == null ? null : ext.biomes.get()), (App)BiomeWeightModifier.CODEC.optionalFieldOf("weight_modifier", null).forGetter(ext -> ext.biomeWeightModifier), (App)VeinGenerator.DIRECT_CODEC.fieldOf("generator").forGetter(ft -> ft.veinGenerator), (App)Codec.list(IndicatorGenerator.DIRECT_CODEC).fieldOf("indicators").forGetter(ft -> ft.indicatorGenerators)).apply((Applicative)instance, (clusterSize, density, weight, layer, dimensionFilter, range, discardChanceOnAirExposure, biomes, biomeWeightModifier, veinGenerator, indicatorGenerators) -> new GTOreDefinition((int)clusterSize, density.floatValue(), (int)weight, (IWorldGenLayer)layer, (Set<ResourceKey<Level>>)new HashSet<ResourceKey<Level>>((Collection<ResourceKey<Level>>)dimensionFilter), (HeightRangePlacement)range, discardChanceOnAirExposure.floatValue(), biomes == null ? null : () -> biomes, (BiomeWeightModifier)biomeWeightModifier, (VeinGenerator)veinGenerator, (List<IndicatorGenerator>)indicatorGenerators)));
    private int clusterSize;
    private float density;
    private int weight;
    private IWorldGenLayer layer;
    private Set<ResourceKey<Level>> dimensionFilter;
    private HeightRangePlacement range;
    private float discardChanceOnAirExposure;
    private Supplier<HolderSet<Biome>> biomes;
    private BiomeWeightModifier biomeWeightModifier;
    private List<PlacementModifier> modifiers;
    private VeinGenerator veinGenerator;
    private List<IndicatorGenerator> indicatorGenerators;
    private int minimumYield;
    private int maximumYield;
    private int depletedYield;
    private int depletionChance;
    private int depletionAmount = 1;
    private List<Map.Entry<Integer, Material>> bedrockVeinMaterial;

    public GTOreDefinition(ResourceLocation id, int clusterSize, float density, int weight, IWorldGenLayer layer, Set<ResourceKey<Level>> dimensionFilter, HeightRangePlacement range, float discardChanceOnAirExposure, @Nullable Supplier<HolderSet<Biome>> biomes, @Nullable BiomeWeightModifier biomeWeightModifier, @Nullable VeinGenerator veinGenerator, @Nullable List<IndicatorGenerator> indicatorGenerators) {
        this(clusterSize, density, weight, layer, dimensionFilter, range, discardChanceOnAirExposure, biomes, biomeWeightModifier, veinGenerator, indicatorGenerators);
        if (GTRegistries.ORE_VEINS.containKey(id)) {
            GTRegistries.ORE_VEINS.replace(id, this);
        } else {
            GTRegistries.ORE_VEINS.register(id, this);
        }
        this.indicatorGenerators = Objects.requireNonNullElseGet(indicatorGenerators, ArrayList::new);
    }

    public GTOreDefinition(int clusterSize, float density, int weight, IWorldGenLayer layer, Set<ResourceKey<Level>> dimensionFilter, HeightRangePlacement range, float discardChanceOnAirExposure, @Nullable Supplier<HolderSet<Biome>> biomes, @Nullable BiomeWeightModifier biomeWeightModifier, @Nullable VeinGenerator veinGenerator, @Nullable List<IndicatorGenerator> indicatorGenerators) {
        this.clusterSize = clusterSize;
        this.density = density;
        this.weight = weight;
        this.layer = layer;
        this.dimensionFilter = dimensionFilter;
        this.range = range;
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
        this.biomes = biomes;
        this.biomeWeightModifier = biomeWeightModifier;
        this.veinGenerator = veinGenerator;
        this.indicatorGenerators = indicatorGenerators != null ? indicatorGenerators : new ArrayList();
        this.maximumYield = (int)(density * 100.0f) * clusterSize;
        this.minimumYield = this.maximumYield / 7;
        this.depletedYield = (int)((float)clusterSize / density / 10.0f);
        this.depletionChance = (int)((float)weight * density / 5.0f);
    }

    public GTOreDefinition biomes(TagKey<Biome> biomes) {
        this.biomes = () -> GTRegistries.builtinRegistry().m_255025_(Registries.f_256952_).m_254956_(biomes);
        return this;
    }

    public GTOreDefinition biomes(Supplier<HolderSet<Biome>> biomes) {
        this.biomes = biomes;
        return this;
    }

    public GTOreDefinition range(HeightRangePlacement range) {
        this.range = range;
        return this;
    }

    public List<Map.Entry<Integer, Material>> getBedrockVeinMaterials() {
        if (this.bedrockVeinMaterial == null) {
            this.bedrockVeinMaterial = ConfigHolder.INSTANCE.machines.doBedrockOres ? this.getVeinGenerator().getValidMaterialsChances() : List.of();
        }
        return this.bedrockVeinMaterial;
    }

    public StandardVeinGenerator standardVeinGenerator() {
        if (this.veinGenerator == null) {
            this.veinGenerator = new StandardVeinGenerator(this);
        }
        return (StandardVeinGenerator)this.veinGenerator;
    }

    public LayeredVeinGenerator layeredVeinGenerator() {
        if (this.veinGenerator == null) {
            this.veinGenerator = new LayeredVeinGenerator(this);
        }
        return (LayeredVeinGenerator)this.veinGenerator;
    }

    public GeodeVeinGenerator geodeVeinGenerator() {
        if (this.veinGenerator == null) {
            this.veinGenerator = new GeodeVeinGenerator(this);
        }
        return (GeodeVeinGenerator)this.veinGenerator;
    }

    public DikeVeinGenerator dikeVeinGenerator() {
        if (this.veinGenerator == null) {
            this.veinGenerator = new DikeVeinGenerator(this);
        }
        return (DikeVeinGenerator)this.veinGenerator;
    }

    public VeinedVeinGenerator veinedVeinGenerator() {
        if (this.veinGenerator == null) {
            this.veinGenerator = new VeinedVeinGenerator(this);
        }
        return (VeinedVeinGenerator)this.veinGenerator;
    }

    public GTOreDefinition surfaceIndicatorGenerator(Consumer<SurfaceIndicatorGenerator> config) {
        config.accept(this.getOrCreateIndicatorGenerator(SurfaceIndicatorGenerator.class, SurfaceIndicatorGenerator::new));
        return this;
    }

    private <T extends IndicatorGenerator> T getOrCreateIndicatorGenerator(Class<T> indicatorClass, Function<GTOreDefinition, T> constructor) {
        IndicatorGenerator existingGenerator = this.indicatorGenerators.stream().filter(indicatorClass::isInstance).map(indicatorClass::cast).findFirst().orElse(null);
        if (existingGenerator != null) {
            return (T)existingGenerator;
        }
        IndicatorGenerator generator = (IndicatorGenerator)constructor.apply(this);
        this.indicatorGenerators.add(generator);
        return (T)generator;
    }

    @Nullable
    public VeinGenerator generator(ResourceLocation id) {
        if (this.veinGenerator == null) {
            this.veinGenerator = WorldGeneratorUtils.VEIN_GENERATOR_FUNCTIONS.containsKey((Object)id) ? (VeinGenerator)((Function)WorldGeneratorUtils.VEIN_GENERATOR_FUNCTIONS.get((Object)id)).apply(this) : null;
        }
        return this.veinGenerator;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public GTOreDefinition setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    public float getDensity() {
        return this.density;
    }

    public GTOreDefinition setDensity(float density) {
        this.density = density;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public GTOreDefinition setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public IWorldGenLayer getLayer() {
        return this.layer;
    }

    public GTOreDefinition setLayer(IWorldGenLayer layer) {
        this.layer = layer;
        return this;
    }

    public Set<ResourceKey<Level>> getDimensionFilter() {
        return this.dimensionFilter;
    }

    public GTOreDefinition setDimensionFilter(Set<ResourceKey<Level>> dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
        return this;
    }

    public HeightRangePlacement getRange() {
        return this.range;
    }

    public GTOreDefinition setRange(HeightRangePlacement range) {
        this.range = range;
        return this;
    }

    public float getDiscardChanceOnAirExposure() {
        return this.discardChanceOnAirExposure;
    }

    public GTOreDefinition setDiscardChanceOnAirExposure(float discardChanceOnAirExposure) {
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
        return this;
    }

    public Supplier<HolderSet<Biome>> getBiomes() {
        return this.biomes;
    }

    public GTOreDefinition setBiomes(Supplier<HolderSet<Biome>> biomes) {
        this.biomes = biomes;
        return this;
    }

    public BiomeWeightModifier getBiomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    public GTOreDefinition setBiomeWeightModifier(BiomeWeightModifier biomeWeightModifier) {
        this.biomeWeightModifier = biomeWeightModifier;
        return this;
    }

    public List<PlacementModifier> getModifiers() {
        return this.modifiers;
    }

    public VeinGenerator getVeinGenerator() {
        return this.veinGenerator;
    }

    public GTOreDefinition setVeinGenerator(VeinGenerator veinGenerator) {
        this.veinGenerator = veinGenerator;
        return this;
    }

    public List<IndicatorGenerator> getIndicatorGenerators() {
        return this.indicatorGenerators;
    }

    public GTOreDefinition setIndicatorGenerators(List<IndicatorGenerator> indicatorGenerators) {
        this.indicatorGenerators = indicatorGenerators;
        return this;
    }

    public int getMinimumYield() {
        return this.minimumYield;
    }

    public int getMaximumYield() {
        return this.maximumYield;
    }

    public int getDepletedYield() {
        return this.depletedYield;
    }

    public int getDepletionChance() {
        return this.depletionChance;
    }

    public int getDepletionAmount() {
        return this.depletionAmount;
    }

    public GTOreDefinition setMinimumYield(int minimumYield) {
        this.minimumYield = minimumYield;
        return this;
    }

    public GTOreDefinition setMaximumYield(int maximumYield) {
        this.maximumYield = maximumYield;
        return this;
    }

    public GTOreDefinition setDepletedYield(int depletedYield) {
        this.depletedYield = depletedYield;
        return this;
    }

    public GTOreDefinition setDepletionChance(int depletionChance) {
        this.depletionChance = depletionChance;
        return this;
    }

    public GTOreDefinition setDepletionAmount(int depletionAmount) {
        this.depletionAmount = depletionAmount;
        return this;
    }

    public GTOreDefinition setBedrockVeinMaterial(List<Map.Entry<Integer, Material>> bedrockVeinMaterial) {
        this.bedrockVeinMaterial = bedrockVeinMaterial;
        return this;
    }
}

