/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.SavedData;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BedrockFluidVeinSavedData
extends SavedData {
    public static final int VEIN_CHUNK_SIZE = 8;
    public static final int MAXIMUM_VEIN_OPERATIONS = 100000;
    public final HashMap<ChunkPos, FluidVeinWorldEntry> veinFluids = new HashMap();
    private final HashMap<Holder<Biome>, Integer> biomeWeights = new HashMap();
    private final ServerLevel serverLevel;

    public static BedrockFluidVeinSavedData getOrCreate(ServerLevel serverLevel) {
        return (BedrockFluidVeinSavedData)serverLevel.m_8895_().m_164861_(tag -> new BedrockFluidVeinSavedData(serverLevel, (CompoundTag)tag), () -> new BedrockFluidVeinSavedData(serverLevel), "gtceu_bedrock_fluid");
    }

    public BedrockFluidVeinSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public BedrockFluidVeinSavedData(ServerLevel serverLevel, CompoundTag nbt) {
        this(serverLevel);
        ListTag list = nbt.m_128437_("veinInfo", 10);
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)tag;
            ChunkPos chunkPos = new ChunkPos(compoundTag.m_128454_("p"));
            this.veinFluids.put(chunkPos, FluidVeinWorldEntry.readFromNBT(compoundTag.m_128469_("d")));
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag oilList = new ListTag();
        for (Map.Entry<ChunkPos, FluidVeinWorldEntry> entry : this.veinFluids.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("p", entry.getKey().m_45588_());
            tag.m_128365_("d", (Tag)entry.getValue().writeToNBT());
            oilList.add((Object)tag);
        }
        nbt.m_128365_("veinInfo", (Tag)oilList);
        return nbt;
    }

    public FluidVeinWorldEntry getFluidVeinWorldEntry(int chunkX, int chunkZ) {
        if (!this.veinFluids.containsKey(new ChunkPos(chunkX, chunkZ))) {
            BedrockFluidDefinition definition = null;
            int query = RandomSource.m_216335_((long)Objects.hash(this.serverLevel.m_7328_(), chunkX / 8, chunkZ / 8)).m_188502_();
            Holder biome = this.serverLevel.m_204166_(new BlockPos(chunkX << 4, 64, chunkZ << 4));
            int totalWeight = this.getTotalWeight((Holder<Biome>)biome);
            if (totalWeight > 0) {
                int weight = Math.abs(query % totalWeight);
                for (BedrockFluidDefinition fluidDefinition : GTRegistries.BEDROCK_FLUID_DEFINITIONS) {
                    int veinWeight = fluidDefinition.getWeight() + fluidDefinition.getBiomeWeightModifier().apply((Holder<Biome>)biome);
                    if (veinWeight <= 0 || fluidDefinition.getDimensionFilter() != null && !fluidDefinition.getDimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((ResourceKey<Level>)dim, (ResourceKey<Level>)this.serverLevel.m_46472_())) || (weight -= veinWeight) >= 0) continue;
                    definition = fluidDefinition;
                    break;
                }
            }
            RandomSource random = RandomSource.m_216335_((long)(961L * (long)chunkX + (long)chunkZ * 31L + (long)Long.hashCode(this.serverLevel.m_7328_())));
            int maximumYield = 0;
            if (definition != null) {
                maximumYield = definition.getMaximumYield() - definition.getMinimumYield() <= 0 ? definition.getMinimumYield() : random.m_188503_(definition.getMaximumYield() - definition.getMinimumYield()) + definition.getMinimumYield();
                maximumYield = Math.min(maximumYield, definition.getMaximumYield());
            }
            this.veinFluids.put(new ChunkPos(chunkX, chunkZ), new FluidVeinWorldEntry(definition, maximumYield, 100000));
            this.m_77762_();
        }
        return this.veinFluids.get(new ChunkPos(chunkX, chunkZ));
    }

    public int getTotalWeight(Holder<Biome> biome) {
        return this.biomeWeights.computeIfAbsent(biome, b -> {
            int totalWeight = 0;
            for (BedrockFluidDefinition definition : GTRegistries.BEDROCK_FLUID_DEFINITIONS) {
                if (definition.getDimensionFilter() != null && !definition.getDimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((ResourceKey<Level>)dim, (ResourceKey<Level>)this.serverLevel.m_46472_()))) continue;
                totalWeight += definition.getBiomeWeightModifier().apply(biome).intValue();
                totalWeight += definition.getWeight();
            }
            return totalWeight;
        });
    }

    public int getFluidYield(int chunkX, int chunkZ) {
        return this.getFluidVeinWorldEntry(chunkX, chunkZ).getFluidYield();
    }

    public int getDepletedFluidYield(int chunkX, int chunkZ) {
        FluidVeinWorldEntry info = this.getFluidVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return 0;
        }
        return info.getDefinition().getDepletedYield();
    }

    public int getOperationsRemaining(int chunkX, int chunkZ) {
        return this.getFluidVeinWorldEntry(chunkX, chunkZ).getOperationsRemaining();
    }

    @Nullable
    public Fluid getFluidInChunk(int chunkX, int chunkZ) {
        FluidVeinWorldEntry info = this.getFluidVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return null;
        }
        return info.getDefinition().getStoredFluid().get();
    }

    public void depleteVein(int chunkX, int chunkZ, int amount, boolean ignoreVeinStats) {
        FluidVeinWorldEntry info = this.getFluidVeinWorldEntry(chunkX, chunkZ);
        if (ignoreVeinStats) {
            info.decreaseOperations(amount);
            if (amount != 0) {
                this.m_77762_();
            }
            return;
        }
        BedrockFluidDefinition definition = info.getDefinition();
        if (definition == null || definition.getDepletionChance() == 0) {
            return;
        }
        if (definition.getDepletionChance() == 100 || GTValues.RNG.m_188503_(100) <= definition.getDepletionChance()) {
            info.decreaseOperations(definition.getDepletionAmount());
            this.m_77762_();
        }
    }
}

