/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class OreVeinWorldEntry {
    @Nullable
    private GTOreDefinition vein;
    private int oreYield;
    private int operationsRemaining;

    public OreVeinWorldEntry(@Nullable GTOreDefinition vein, int oreYield, int operationsRemaining) {
        this.vein = vein;
        this.oreYield = oreYield;
        this.operationsRemaining = operationsRemaining;
    }

    private OreVeinWorldEntry() {
    }

    public GTOreDefinition getDefinition() {
        return this.vein;
    }

    public void setOperationsRemaining(int amount) {
        this.operationsRemaining = amount;
    }

    public void decreaseOperations(int amount) {
        this.operationsRemaining = ConfigHolder.INSTANCE.worldgen.oreVeins.infiniteBedrockOresFluids ? this.operationsRemaining : Math.max(0, this.operationsRemaining - amount);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("oreYield", this.oreYield);
        tag.m_128405_("operationsRemaining", this.operationsRemaining);
        if (this.vein != null) {
            tag.m_128359_("vein", ((ResourceLocation)GTRegistries.ORE_VEINS.getKey(this.vein)).toString());
        }
        return tag;
    }

    @Nonnull
    public static OreVeinWorldEntry readFromNBT(@Nonnull CompoundTag tag) {
        OreVeinWorldEntry info = new OreVeinWorldEntry();
        info.oreYield = tag.m_128451_("oreYield");
        info.operationsRemaining = tag.m_128451_("operationsRemaining");
        if (tag.m_128441_("vein")) {
            info.vein = (GTOreDefinition)GTRegistries.ORE_VEINS.get(new ResourceLocation(tag.m_128461_("vein")));
        }
        return info;
    }

    @Nullable
    public GTOreDefinition getVein() {
        return this.vein;
    }

    public int getOreYield() {
        return this.oreYield;
    }

    public int getOperationsRemaining() {
        return this.operationsRemaining;
    }
}

