/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids;

import com.gregtechceu.gtceu.api.capability.IPropertyFluidFilter;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttributes;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class PropertyFluidFilter
implements IPropertyFluidFilter {
    private final Object2BooleanMap<FluidAttribute> containmentPredicate = new Object2BooleanOpenHashMap();
    private final int maxFluidTemperature;
    private final boolean gasProof;
    private final boolean cryoProof;
    private final boolean plasmaProof;

    public PropertyFluidFilter(int maxFluidTemperature, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        this.maxFluidTemperature = maxFluidTemperature;
        this.gasProof = gasProof;
        if (acidProof) {
            this.setCanContain(FluidAttributes.ACID, true);
        }
        this.cryoProof = cryoProof;
        this.plasmaProof = plasmaProof;
    }

    @Override
    public boolean canContain(@NotNull FluidState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case FluidState.LIQUID -> true;
            case FluidState.GAS -> this.gasProof;
            case FluidState.PLASMA -> this.plasmaProof;
            case FluidState.MOLTEN -> true;
        };
    }

    @Override
    public boolean canContain(@NotNull FluidAttribute attribute) {
        return this.containmentPredicate.getBoolean((Object)attribute);
    }

    @Override
    public void setCanContain(@NotNull FluidAttribute attribute, boolean canContain) {
        this.containmentPredicate.put((Object)attribute, canContain);
    }

    @Override
    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull FluidAttribute> getContainedAttributes() {
        return this.containmentPredicate.keySet();
    }

    public String toString() {
        return "SimplePropertyFluidFilter{maxFluidTemperature=" + this.maxFluidTemperature + ", gasProof=" + this.gasProof + ", cryoProof=" + this.cryoProof + ", plasmaProof=" + this.plasmaProof + ", containmentPredicate=" + this.containmentPredicate + "}";
    }

    @Override
    public int getMaxFluidTemperature() {
        return this.maxFluidTemperature;
    }

    @Override
    public boolean isGasProof() {
        return this.gasProof;
    }

    @Override
    public boolean isCryoProof() {
        return this.cryoProof;
    }

    @Override
    public boolean isPlasmaProof() {
        return this.plasmaProof;
    }
}

