/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids.store;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FluidStorageKey {
    private static final Map<ResourceLocation, FluidStorageKey> keys = new Object2ObjectOpenHashMap();
    private final ResourceLocation resourceLocation;
    private final MaterialIconType iconType;
    private final UnaryOperator<String> registryNameOperator;
    private final Function<Material, String> translationKeyFunction;
    private final int hashCode;

    public FluidStorageKey(@NotNull ResourceLocation resourceLocation, @NotNull MaterialIconType iconType, @NotNull @NotNull UnaryOperator<@NotNull String> registryNameOperator, @NotNull @NotNull Function<@NotNull Material, @NotNull String> translationKeyFunction) {
        this.resourceLocation = resourceLocation;
        this.iconType = iconType;
        this.registryNameOperator = registryNameOperator;
        this.translationKeyFunction = translationKeyFunction;
        this.hashCode = resourceLocation.hashCode();
        if (keys.containsKey(resourceLocation)) {
            throw new IllegalArgumentException("Cannot create duplicate keys");
        }
        keys.put(resourceLocation, this);
    }

    @Nullable
    public static FluidStorageKey getByName(@NotNull ResourceLocation location) {
        return keys.get(location);
    }

    public static Collection<FluidStorageKey> allKeys() {
        return keys.values();
    }

    @NotNull
    public String getRegistryNameFor(@NotNull String baseName) {
        return (String)this.registryNameOperator.apply(baseName);
    }

    @NotNull
    public String getTranslationKeyFor(@NotNull Material material) {
        return this.translationKeyFunction.apply(material);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidStorageKey fluidKey = (FluidStorageKey)o;
        return this.resourceLocation.equals((Object)fluidKey.getResourceLocation());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NotNull
    public String toString() {
        return "FluidStorageKey{" + this.resourceLocation + "}";
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public MaterialIconType getIconType() {
        return this.iconType;
    }
}

