/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.CycleButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnumSelectorWidget<T extends Enum<T>>
extends WidgetGroup {
    private final CycleButtonWidget buttonWidget;
    private final List<T> values;
    private final Consumer<T> onChanged;
    private int selected = 0;
    private BiFunction<T, IGuiTexture, IGuiTexture> textureSupplier = (value, texture) -> new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, texture});
    private BiFunction<T, String, List<Component>> tooltipSupplier = (value, key) -> List.copyOf(LangHandler.getSingleOrMultiLang(key));

    public EnumSelectorWidget(int xPosition, int yPosition, int width, int height, T[] values, T initialValue, Consumer<T> onChanged) {
        this(xPosition, yPosition, width, height, Arrays.asList(values), initialValue, onChanged);
    }

    public EnumSelectorWidget(int xPosition, int yPosition, int width, int height, List<T> values, T initialValue, Consumer<T> onChanged) {
        super(xPosition, yPosition, width, height);
        this.values = values;
        this.onChanged = onChanged;
        this.buttonWidget = new CycleButtonWidget(0, 0, width, height, values.size(), this::getTexture, this::onSelected);
        this.addWidget((Widget)this.buttonWidget);
        this.setSelected(initialValue);
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        buffer.writeInt(this.selected);
    }

    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.onSelected(buffer.readInt());
    }

    public T getCurrentValue() {
        return (T)((Enum)this.values.get(this.selected));
    }

    private IGuiTexture getTexture(int selected) {
        Enum selectedValue = (Enum)this.values.get(selected);
        return this.textureSupplier.apply(selectedValue, ((SelectableEnum)((Object)selectedValue)).getIcon());
    }

    private void onSelected(int selected) {
        Enum selectedValue = (Enum)this.values.get(selected);
        this.setSelected(selectedValue);
    }

    public EnumSelectorWidget<T> setTextureSupplier(BiFunction<T, IGuiTexture, IGuiTexture> textureSupplier) {
        this.textureSupplier = textureSupplier;
        T selectedValue = this.getCurrentValue();
        this.buttonWidget.setBackground(new IGuiTexture[]{textureSupplier.apply(selectedValue, ((SelectableEnum)selectedValue).getIcon())});
        return this;
    }

    public EnumSelectorWidget<T> setTooltipSupplier(BiFunction<T, String, List<Component>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public void setSelected(@NotNull T value) {
        int selectedIndex = this.values.indexOf(value);
        if (selectedIndex == -1) {
            throw new NoSuchElementException(value + " is not a possible value for this selector.");
        }
        this.selected = selectedIndex;
        this.buttonWidget.setIndex(selectedIndex);
        this.updateTooltip();
        this.onChanged.accept(value);
    }

    private void updateTooltip() {
        if (!LDLib.isRemote()) {
            return;
        }
        T selectedValue = this.getCurrentValue();
        this.buttonWidget.setHoverTooltips(this.tooltipSupplier.apply(selectedValue, ((SelectableEnum)selectedValue).getTooltip()));
    }

    public static interface SelectableEnum {
        public String getTooltip();

        public IGuiTexture getIcon();
    }
}

