/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.item.IItemUseFirst;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.ICustomRenderer;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.api.item.forge.ComponentItemImpl;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ComponentItem
extends Item
implements HeldItemUIFactory.IHeldItemUIHolder,
IItemRendererProvider,
IItemUseFirst {
    protected List<IItemComponent> components = new ArrayList<IItemComponent>();

    protected ComponentItem(Item.Properties properties) {
        super(properties);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ComponentItem create(Item.Properties properties) {
        return ComponentItemImpl.create(properties);
    }

    public void attachComponents(IItemComponent ... components) {
        this.components.addAll(Arrays.asList(components));
        for (IItemComponent component : components) {
            component.onAttached(this);
        }
    }

    public void fillItemCategory(CreativeModeTab category, NonNullList<ItemStack> items) {
        boolean found = false;
        for (IItemComponent component : this.components) {
            if (!(component instanceof ISubItemHandler)) continue;
            ISubItemHandler subItemHandler = (ISubItemHandler)component;
            subItemHandler.fillItemCategory(this, category, items);
            found = true;
        }
        if (found) {
            return;
        }
        items.add((Object)new ItemStack((ItemLike)this));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IAddInformation)) continue;
            IAddInformation addInformation = (IAddInformation)component;
            addInformation.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.isBarVisible(stack);
        }
        return super.m_142522_(stack);
    }

    public int m_142158_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.getBarWidth(stack);
        }
        return super.m_142158_(stack);
    }

    public int m_142159_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.getBarColor(stack);
        }
        return super.m_142159_(stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            InteractionResult result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).useOn(context)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            InteractionResultHolder<ItemStack> result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).use(this, level, player, usedHand)).m_19089_() == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_7203_(level, player, usedHand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IInteractionItem)) continue;
            IInteractionItem interactionItem = (IInteractionItem)component;
            stack = interactionItem.finishUsingItem(stack, level, livingEntity);
        }
        return super.m_5922_(stack, level, livingEntity);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            InteractionResult result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).onItemUseFirst(itemStack, context)) == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            InteractionResult result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).interactLivingEntity(stack, player, interactionTarget, usedHand)) == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    public String m_5671_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof ICustomDescriptionId)) continue;
            ICustomDescriptionId customDescriptionId = (ICustomDescriptionId)component;
            return customDescriptionId.getItemStackDisplayName(stack);
        }
        return super.m_5671_(stack);
    }

    @Nullable
    public ModularUI createUI(Player entityPlayer, HeldItemUIFactory.HeldItemHolder holder) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IItemUIFactory)) continue;
            IItemUIFactory uiFactory = (IItemUIFactory)component;
            return uiFactory.createUI(holder, entityPlayer);
        }
        return null;
    }

    @Nullable
    public IRenderer getRenderer(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof ICustomRenderer)) continue;
            ICustomRenderer customRenderer = (ICustomRenderer)component;
            return customRenderer.getRenderer();
        }
        return null;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IItemLifeCycle)) continue;
            IItemLifeCycle lifeCycle = (IItemLifeCycle)component;
            lifeCycle.inventoryTick(stack, level, entity, slotId, isSelected);
        }
    }

    public List<IItemComponent> getComponents() {
        return this.components;
    }
}

