/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.google.common.collect.BiMap;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.item.IItemUseFirst;
import com.gregtechceu.gtceu.api.item.forge.GTToolItemImpl;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.TreeFellingHelper;
import com.gregtechceu.gtceu.client.renderer.item.ToolItemRenderer;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.lowdragmc.lowdraglib.Platform;
import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTToolItem
extends DiggerItem
implements IItemUseFirst {
    protected final GTToolType toolType;

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static GTToolItem create(GTToolType toolType, MaterialToolTier tier, Item.Properties properties) {
        void var2_2;
        void var1_1;
        return GTToolItemImpl.create(toolType, (MaterialToolTier)var1_1, (Item.Properties)var2_2);
    }

    protected GTToolItem(GTToolType toolType, MaterialToolTier tier, Item.Properties properties) {
        super(toolType.attackDamageModifier, toolType.attackSpeedModifier, (Tier)tier, toolType.harvestTag, properties);
        this.toolType = toolType;
        if (Platform.isClient()) {
            ToolItemRenderer.create((Item)this, toolType);
        }
    }

    public MaterialToolTier getTier() {
        return (MaterialToolTier)super.m_43314_();
    }

    public boolean m_41470_() {
        return super.m_41470_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintColor() {
        return (itemStack, index) -> {
            Item patt3080$temp = itemStack.m_41720_();
            if (patt3080$temp instanceof GTToolItem) {
                GTToolItem item = (GTToolItem)patt3080$temp;
                return switch (index) {
                    case 0 -> {
                        if (item.toolType == GTToolType.CROWBAR && itemStack.m_41782_() && itemStack.m_41783_().m_128425_("tint_color", 3)) {
                            yield itemStack.m_41783_().m_128451_("tint_color");
                        }
                        yield -1;
                    }
                    case 1 -> item.getTier().material.getMaterialARGB();
                    default -> -1;
                };
            }
            return -1;
        };
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        IToolable toolable = GTCapabilityHelper.getToolable(context.m_43725_(), context.m_8083_(), context.m_43719_());
        if (toolable != null && ToolHelper.canUse(itemStack)) {
            Player player;
            InteractionResult result = toolable.onToolClick(this.getToolType(), itemStack, context);
            if (result == InteractionResult.CONSUME && (player = context.m_43723_()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ToolHelper.playToolSound(this.toolType, serverPlayer);
                if (!serverPlayer.m_7500_()) {
                    ToolHelper.damageItem(itemStack, context.m_43725_().m_213780_(), serverPlayer);
                }
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this.toolType == GTToolType.SHOVEL) {
            return this.useShovelOn(context);
        }
        if (this.toolType == GTToolType.AXE) {
            return this.useAxeOn(context);
        }
        if (this.toolType == GTToolType.HOE) {
            return this.useHoeOn(context);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useShovelOn(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        if (context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        BlockState blockState2 = (BlockState)ShovelItem.f_43110_.get(blockState.m_60734_());
        BlockState blockState3 = null;
        if (blockState2 != null && level.m_8055_(blockPos.m_7494_()).m_60795_()) {
            level.m_5594_(player, blockPos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockState3 = blockState2;
        } else if (blockState.m_60734_() instanceof CampfireBlock && ((Boolean)blockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5898_(null, 1009, blockPos, 0);
            }
            CampfireBlock.m_152749_((Entity)context.m_43723_(), (LevelAccessor)level, (BlockPos)blockPos, (BlockState)blockState);
            blockState3 = (BlockState)blockState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
        }
        if (blockState3 != null) {
            if (!level.f_46443_) {
                level.m_7731_(blockPos, blockState3, 11);
                level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState3));
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private Optional<BlockState> getStripped(BlockState unstrippedState) {
        return Optional.ofNullable((Block)AxeItem.f_150683_.get(unstrippedState.m_60734_())).map(block -> (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)unstrippedState.m_61143_((Property)RotatedPillarBlock.f_55923_))));
    }

    public InteractionResult useAxeOn(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockState = level.m_8055_(blockPos);
        Optional<BlockState> strippable = this.getStripped(blockState);
        Optional cleanable = WeatheringCopper.m_154899_((BlockState)blockState);
        Optional<BlockState> waxable = Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)blockState.m_60734_())).map(block -> block.m_152465_(blockState));
        ItemStack itemStack = context.m_43722_();
        Optional<Object> result = Optional.empty();
        if (strippable.isPresent()) {
            level.m_5594_(player, blockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            result = strippable;
        } else if (cleanable.isPresent()) {
            level.m_5594_(player, blockPos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockPos, 0);
            result = cleanable;
        } else if (waxable.isPresent()) {
            level.m_5594_(player, blockPos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockPos, 0);
            result = waxable;
        }
        if (result.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockPos, itemStack);
            }
            level.m_7731_(blockPos, (BlockState)result.get(), 11);
            level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)result.get())));
            if (player != null) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useHoeOn(UseOnContext context) {
        BlockPos blockPos;
        Level level = context.m_43725_();
        Pair pair = (Pair)HoeItem.f_41332_.get(level.m_8055_(blockPos = context.m_8083_()).m_60734_());
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.m_43723_();
            level.m_5594_(player, blockPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(context);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public String m_5524_() {
        return this.toolType.getUnlocalizedName();
    }

    public Component m_41466_() {
        return Component.m_237110_((String)this.toolType.getUnlocalizedName(), (Object[])new Object[]{this.getTier().material.getLocalizedName()});
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (stack.m_204117_(CustomTags.TREE_FELLING_TOOLS) && state.m_204336_(BlockTags.f_13106_)) {
            new TreeFellingHelper().fellTree(stack, level, state, pos, miningEntity);
        }
        return super.m_6813_(stack, level, state, pos, miningEntity);
    }

    public GTToolType getToolType() {
        return this.toolType;
    }
}

