/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.forge;

import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IRecipeRemainder;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ComponentItemImpl
extends ComponentItem {
    protected int burnTime = -1;

    protected ComponentItemImpl(Item.Properties properties) {
        super(properties);
    }

    public static ComponentItem create(Item.Properties properties) {
        return new ComponentItemImpl(properties);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IRecipeRemainder)) continue;
            IRecipeRemainder recipeRemainder = (IRecipeRemainder)component;
            return recipeRemainder.getRecipeRemained(itemStack);
        }
        return super.getCraftingRemainingItem(itemStack);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull ItemStack itemStack, @Nonnull Capability<T> cap) {
        for (IItemComponent component : this.components) {
            IComponentCapability componentCapability;
            LazyOptional<T> value;
            if (!(component instanceof IComponentCapability) || !(value = (componentCapability = (IComponentCapability)((Object)component)).getCapability(itemStack, cap)).isPresent()) continue;
            return value;
        }
        return LazyOptional.empty();
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.burnTime;
    }

    public void burnTime(int burnTime) {
        this.burnTime = burnTime;
    }
}

