/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.sound.ExistingSoundEntry;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public enum GTToolType {
    SWORD("sword", "swords", 3.0f, -2.4f, false),
    PICKAXE("pickaxe", "pickaxes", 1.0f, -2.8f, true),
    SHOVEL("shovel", "shovels", 1.5f, -3.0f, true),
    AXE("axe", "axes", 6.0f, -3.2f, true),
    HOE("hoe", "hoes", 0.0f, -3.0f, true),
    MINING_HAMMER("mining_hammer", "mining_hammers", TagUtil.createBlockTag("mineable/pickaxe", true), 1.5f, -3.2f, GTCEu.id("item/tools/mining_hammer"), null, false),
    SAW("saw", "saws", 1.0f, 1.0f, GTSoundEntries.SAW_TOOL),
    HARD_HAMMER("hammer", "hammers", 1.0f, 1.0f, GTSoundEntries.FORGE_HAMMER),
    SOFT_MALLET("mallet", "mallets", 1.0f, 1.0f, GTSoundEntries.SOFT_MALLET_TOOL),
    WRENCH("wrench", "wrenches", 1.0f, 1.0f, GTSoundEntries.WRENCH_TOOL),
    FILE("file", "files", 1.0f, 1.0f, GTSoundEntries.FILE_TOOL),
    CROWBAR("crowbar", "crowbars", 1.0f, 1.0f, new ExistingSoundEntry(SoundEvents.f_12018_, SoundSource.BLOCKS)),
    SCREWDRIVER("screwdriver", "screwdrivers", 1.0f, 1.0f, GTSoundEntries.SCREWDRIVER_TOOL),
    MORTAR("mortar", "mortars", 1.0f, 1.0f, GTSoundEntries.MORTAR_TOOL),
    WIRE_CUTTER("wire_cutter", "wire_cutters", 1.0f, 1.0f, GTSoundEntries.WIRECUTTER_TOOL),
    SCYTHE("scythe", "scythes", 1.0f, 1.0f),
    KNIFE("knife", "knives", 1.0f, 1.0f),
    BUTCHERY_KNIFE("butchery_knife", "butchery_knives", 1.0f, 1.0f),
    PLUNGER("plunger", "plungers", 1.0f, 1.0f, GTSoundEntries.PLUNGER_TOOL);

    public final String name;
    public final TagKey<Item> itemTag;
    public final TagKey<Block> harvestTag;
    public final float attackDamageModifier;
    public final float attackSpeedModifier;
    public final ResourceLocation modelLocation;
    @Nullable
    public final SoundEntry soundEntry;

    private GTToolType(String name, TagKey<Block> harvestTag, TagKey<Item> itemTag, float attackDamageModifier, float attackSpeedModifier, ResourceLocation modelLocation, SoundEntry soundEntry) {
        this.name = name;
        this.itemTag = itemTag;
        this.harvestTag = harvestTag;
        this.attackDamageModifier = attackDamageModifier;
        this.attackSpeedModifier = attackSpeedModifier;
        this.modelLocation = modelLocation;
        this.soundEntry = soundEntry;
    }

    private GTToolType(String name, String plural, TagKey<Block> harvestTag, float attackDamageModifier, float attackSpeedModifier, ResourceLocation modelLocation, SoundEntry soundEntry, boolean isVanilla) {
        this(name, harvestTag, isVanilla ? TagUtil.createItemTag(plural, true) : TagUtil.createPlatformItemTag("tools/" + plural, plural), attackDamageModifier, attackSpeedModifier, modelLocation, soundEntry);
    }

    private GTToolType(String name, String plural, float attackDamageModifier, float attackSpeedModifier, ResourceLocation modelLocation, SoundEntry soundEntry, boolean isVanilla) {
        this(name, plural, (TagKey<Block>)(isVanilla ? TagUtil.createBlockTag("mineable/" + name, true) : TagUtil.createPlatformUnprefixedTag(BuiltInRegistries.f_256975_, "forge:mineable/" + name, "fabric:mineable/" + name)), attackDamageModifier, attackSpeedModifier, modelLocation, soundEntry, isVanilla);
    }

    private GTToolType(String name, String plural, float attackDamageModifier, float attackSpeedModifier, SoundEntry soundEntry, boolean isVanilla) {
        this(name, plural, attackDamageModifier, attackSpeedModifier, GTCEu.id(String.format("item/tools/%s", name)), soundEntry, isVanilla);
    }

    private GTToolType(String name, String plural, float attackDamageModifier, float attackSpeedModifier, SoundEntry soundEntry) {
        this(name, plural, attackDamageModifier, attackSpeedModifier, soundEntry, false);
    }

    private GTToolType(String name, String plural, float attackDamageModifier, float attackSpeedModifier, boolean isVanilla) {
        this(name, plural, attackDamageModifier, attackSpeedModifier, null, isVanilla);
    }

    private GTToolType(String name, String plural, float attackDamageModifier, float attackSpeedModifier) {
        this(name, plural, attackDamageModifier, attackSpeedModifier, false);
    }

    public boolean is(ItemStack itemStack) {
        return ToolHelper.is(itemStack, this);
    }

    public String getUnlocalizedName() {
        return "item.gtceu.tool." + this.name;
    }
}

