/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.item.GTToolItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ToolHelper {
    public static ItemStack get(GTToolType toolType, Material material) {
        ItemEntry entry;
        if (material.hasProperty(PropertyKey.TOOL) && (entry = (ItemEntry)GTItems.TOOL_ITEMS.get((Object)material.getToolTier(), (Object)toolType)) != null) {
            return entry.asStack();
        }
        return ItemStack.f_41583_;
    }

    public static boolean is(ItemStack stack, GTToolType toolType) {
        Item item = stack.m_41720_();
        if (item instanceof GTToolItem) {
            GTToolItem item2 = (GTToolItem)item;
            return item2.getToolType() == toolType;
        }
        return false;
    }

    public static boolean canUse(ItemStack stack) {
        return stack.m_41773_() <= stack.m_41776_();
    }

    public static void damageItem(@Nonnull ItemStack stack, RandomSource random, @Nullable ServerPlayer user) {
        if (ToolHelper.canUse(stack)) {
            stack.m_220157_(1, random, user);
        } else {
            stack.m_41774_(1);
        }
    }

    public static void playToolSound(GTToolType toolType, ServerPlayer player) {
        if (toolType.soundEntry != null) {
            toolType.soundEntry.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_());
        }
    }

    public static List<BlockPos> getAOEPositions(LivingEntity miner, ItemStack stack, BlockPos pos, int radius) {
        Level level = miner.m_9236_();
        ArrayList<BlockPos> aoePositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> potentialPositions = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    potentialPositions.add(new BlockPos(x, y, z));
                }
            }
        }
        Vec3 cameraPos = miner.m_20299_(1.0f);
        Vec3 rotation = miner.m_20252_(1.0f);
        Vec3 combined = cameraPos.m_82520_(rotation.f_82479_ * 4.5, rotation.f_82480_ * 4.5, rotation.f_82481_ * 4.5);
        BlockHitResult result = level.m_45547_(new ClipContext(cameraPos, combined, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)miner));
        for (BlockPos blockPos : potentialPositions) {
            switch (result.m_82434_().m_122434_()) {
                case X: {
                    if (blockPos.m_123341_() != 0) break;
                    aoePositions.add(pos.m_121955_((Vec3i)blockPos));
                    break;
                }
                case Y: {
                    if (blockPos.m_123342_() != 0) break;
                    aoePositions.add(pos.m_121955_((Vec3i)blockPos));
                    break;
                }
                case Z: {
                    if (blockPos.m_123343_() != 0) break;
                    aoePositions.add(pos.m_121955_((Vec3i)blockPos));
                }
            }
        }
        return aoePositions;
    }

    public static boolean aoeCanBreak(ItemStack stack, Level level, BlockPos origin, BlockPos pos) {
        if (origin.equals((Object)pos)) {
            return false;
        }
        if (!stack.m_41735_(level.m_8055_(pos))) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        BlockState originState = level.m_8055_(origin);
        return !(state.m_60800_((BlockGetter)level, pos) < 0.0f) && !(state.m_60800_((BlockGetter)level, pos) - originState.m_60800_((BlockGetter)level, pos) > 8.0f);
    }
}

