/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.WorkableTieredMachine;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputBoth;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import it.unimi.dsi.fastutil.ints.Int2LongFunction;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleTieredMachine
extends WorkableTieredMachine
implements IAutoOutputBoth,
IFancyUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SimpleTieredMachine.class, WorkableTieredMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingFluids;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    protected boolean allowInputFromOutputSideItems;
    @Persisted
    protected boolean allowInputFromOutputSideFluids;
    @Persisted
    protected final ItemStackTransfer chargerInventory;
    @Persisted
    protected final NotifiableItemStackHandler circuitInventory;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected TickableSubscription batterySubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Nullable
    protected ISubscription exportFluidSubs;
    @Nullable
    protected ISubscription energySubs;
    public static BiFunction<ResourceLocation, GTRecipeType, EditableMachineUI> EDITABLE_UI_CREATOR = Util.m_143821_((path, recipeType) -> new EditableMachineUI("simple", (ResourceLocation)path, () -> {
        Widget template = recipeType.createEditableUITemplate(false, false).createDefault().setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        ProgressWidget energyBar = SimpleTieredMachine.createEnergyBar().createDefault();
        SlotWidget batterySlot = SimpleTieredMachine.createBatterySlot().createDefault();
        WidgetGroup energyGroup = new WidgetGroup(0, 0, energyBar.getSize().width, energyBar.getSize().height + 20);
        batterySlot.setSelfPosition(new Position((energyBar.getSize().width - 18) / 2, energyBar.getSize().height + 1));
        energyGroup.addWidget((Widget)energyBar);
        energyGroup.addWidget((Widget)batterySlot);
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyGroup.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8, energyGroup.getSize().height + 8));
        Size size = group.getSize();
        energyGroup.setSelfPosition(new Position(3, (size.height - energyGroup.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - energyGroup.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyGroup.getSize().width + 2, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)energyGroup);
        group.addWidget(template);
        return group;
    }, (template, machine) -> {
        if (machine instanceof SimpleTieredMachine) {
            SimpleTieredMachine tieredMachine = (SimpleTieredMachine)machine;
            tieredMachine.getRecipeType().createEditableUITemplate(false, false).setupUI((WidgetGroup)template, new GTRecipeType.RecipeHolder(tieredMachine.recipeLogic::getProgressPercent, (IItemTransfer)tieredMachine.importItems.storage, (IItemTransfer)tieredMachine.exportItems.storage, tieredMachine.importFluids, tieredMachine.exportFluids, false, false));
            SimpleTieredMachine.createEnergyBar().setupUI((WidgetGroup)template, tieredMachine);
            SimpleTieredMachine.createBatterySlot().setupUI((WidgetGroup)template, tieredMachine);
        }
    }));

    public SimpleTieredMachine(IMachineBlockEntity holder, int tier, Int2LongFunction tankScalingFunction, Object ... args) {
        super(holder, tier, tankScalingFunction, args);
        this.outputFacingFluids = this.outputFacingItems = this.hasFrontFacing() ? this.getFrontFacing().m_122424_() : Direction.UP;
        this.chargerInventory = this.createChargerItemHandler(args);
        this.circuitInventory = this.createCircuitItemHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected ItemStackTransfer createChargerItemHandler(Object ... args) {
        ItemStackTransfer transfer = new ItemStackTransfer();
        transfer.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null);
        return transfer;
    }

    protected NotifiableItemStackHandler createCircuitItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, 1, IO.IN, IO.NONE).setFilter(IntCircuitBehaviour::isIntegratedCircuit);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
            }
            this.updateBatterySubscription();
            this.exportItemSubs = this.exportItems.addChangedListener(this::updateAutoOutputSubscription);
            this.exportFluidSubs = this.exportFluids.addChangedListener(this::updateAutoOutputSubscription);
            this.energySubs = this.energyContainer.addChangedListener(this::updateBatterySubscription);
            this.chargerInventory.setOnContentsChanged(this::updateBatterySubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
        if (this.exportFluidSubs != null) {
            this.exportFluidSubs.unsubscribe();
            this.exportFluidSubs = null;
        }
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
    }

    @Override
    public boolean hasAutoOutputFluid() {
        return this.exportFluids.getTanks() > 0;
    }

    @Override
    public boolean hasAutoOutputItem() {
        return this.exportItems.getSlots() > 0;
    }

    @Override
    @Nullable
    public Direction getOutputFacingFluids() {
        if (this.hasAutoOutputFluid()) {
            return this.outputFacingFluids;
        }
        return null;
    }

    @Override
    @Nullable
    public Direction getOutputFacingItems() {
        if (this.hasAutoOutputItem()) {
            return this.outputFacingItems;
        }
        return null;
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        if (this.hasAutoOutputItem()) {
            this.autoOutputItems = allow;
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public void setAutoOutputFluids(boolean allow) {
        if (this.hasAutoOutputFluid()) {
            this.autoOutputFluids = allow;
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public void setOutputFacingFluids(@Nullable Direction outputFacing) {
        if (this.hasAutoOutputFluid()) {
            this.outputFacingFluids = outputFacing;
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public void setOutputFacingItems(@Nullable Direction outputFacing) {
        if (this.hasAutoOutputItem()) {
            this.outputFacingItems = outputFacing;
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacingItems = this.getOutputFacingItems();
        Direction outputFacingFluids = this.getOutputFacingFluids();
        if (this.isAutoOutputItems() && !this.exportItems.isEmpty() && outputFacingItems != null && ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacingItems), (Direction)outputFacingItems.m_122424_()) != null || this.isAutoOutputFluids() && !this.exportFluids.isEmpty() && outputFacingFluids != null && FluidTransferHelper.getFluidTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacingFluids), (Direction)outputFacingFluids.m_122424_()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void updateBatterySubscription() {
        if (this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, true)) {
            this.batterySubs = this.subscribeServerTick(this.batterySubs, this::chargeBattery);
        } else if (this.batterySubs != null) {
            this.batterySubs.unsubscribe();
            this.batterySubs = null;
        }
    }

    protected void chargeBattery() {
        if (!this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, false)) {
            this.updateBatterySubscription();
        }
    }

    protected void autoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.exportFluids.exportToNearby(this.getOutputFacingFluids());
            }
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.exportItems.exportToNearby(this.getOutputFacingItems());
            }
        }
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.getOutputFacingItems() || facing == this.getOutputFacingFluids()) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public void onDrops(List<ItemStack> drops, Player entity) {
        super.onDrops(drops, entity);
        SimpleTieredMachine.clearInventory(drops, (IItemTransfer)this.chargerInventory);
        if (!ConfigHolder.INSTANCE.machines.ghostCircuit) {
            SimpleTieredMachine.clearInventory(drops, (IItemTransfer)this.circuitInventory.storage);
        }
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.m_6047_() && !this.isRemote()) {
            ItemStack tool = playerIn.m_21120_(hand);
            if (tool.m_41773_() >= tool.m_41776_()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            Direction itemFacing = this.outputFacingItems;
            Direction fluidFacing = this.outputFacingFluids;
            if (gridSide != itemFacing) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            if (gridSide != fluidFacing) {
                this.setOutputFacingFluids(gridSide);
            } else {
                this.setOutputFacingFluids(null);
            }
            return InteractionResult.CONSUME;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            if (gridSide == this.getOutputFacingItems()) {
                if (this.isAllowInputFromOutputSideItems()) {
                    this.setAllowInputFromOutputSideItems(false);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.disallow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.chest.item")));
                } else {
                    this.setAllowInputFromOutputSideItems(true);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.allow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.chest.item")));
                }
            }
            if (gridSide == this.getOutputFacingFluids()) {
                if (this.isAllowInputFromOutputSideFluids()) {
                    this.setAllowInputFromOutputSideFluids(false);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.disallow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.tank.fluid")));
                } else {
                    this.setAllowInputFromOutputSideFluids(true);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.allow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.tank.fluid")));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        IFancyUIMachine.super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new CircuitFancyConfigurator(this.circuitInventory.storage));
    }

    protected static EditableUI<SlotWidget, SimpleTieredMachine> createBatterySlot() {
        return new EditableUI<SlotWidget, SimpleTieredMachine>("battery_slot", SlotWidget.class, () -> {
            SlotWidget slotWidget = new SlotWidget();
            slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY});
            return slotWidget;
        }, (slotWidget, machine) -> {
            slotWidget.setHandlerSlot((IItemTransfer)machine.chargerInventory, 0);
            slotWidget.setCanPutItems(true);
            slotWidget.setCanTakeItems(true);
            slotWidget.setHoverTooltips((Component[])LangHandler.getMultiLang("gtceu.gui.charger_slot.tooltip", GTValues.VNF[machine.getTier()], GTValues.VNF[machine.getTier()]).toArray(new MutableComponent[0]));
        });
    }

    protected IGuiTexture getCircuitSlotOverlay() {
        return GuiTextures.INT_CIRCUIT_OVERLAY;
    }

    @Override
    public ResourceTexture sideTips(Player player, GTToolType toolType, Direction side) {
        if (!(toolType != GTToolType.WRENCH || player.m_6047_() || this.hasFrontFacing() && side == this.getFrontFacing())) {
            return GuiTextures.TOOL_IO_FACING_ROTATION;
        }
        if (toolType == GTToolType.SCREWDRIVER && (side == this.getOutputFacingItems() || side == this.getOutputFacingFluids())) {
            return GuiTextures.TOOL_ALLOW_INPUT;
        }
        return super.sideTips(player, toolType, side);
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSideFluids;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allowInputFromOutputSideFluids) {
        this.allowInputFromOutputSideFluids = allowInputFromOutputSideFluids;
    }

    public ItemStackTransfer getChargerInventory() {
        return this.chargerInventory;
    }

    public NotifiableItemStackHandler getCircuitInventory() {
        return this.circuitInventory;
    }
}

