/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public interface IMaintenanceMachine
extends IMultiPart {
    public static final int MINIMUM_MAINTENANCE_TIME = 3456000;
    public static final byte ALL_PROBLEMS = 0;
    public static final byte NO_PROBLEMS = 63;

    public boolean isFullAuto();

    public void setTaped(boolean var1);

    public boolean isTaped();

    public byte startProblems();

    public byte getMaintenanceProblems();

    public void setMaintenanceProblems(byte var1);

    public int getTimeActive();

    public void setTimeActive(int var1);

    default public float getDurationMultiplier() {
        return 1.0f;
    }

    default public float getTimeMultiplier() {
        return 1.0f;
    }

    @Override
    default public boolean canShared() {
        return false;
    }

    default public boolean calculateTime(int duration) {
        this.setTimeActive(duration + this.getTimeActive());
        int value = this.getTimeActive() - 3456000;
        if (value > 0) {
            this.setTimeActive(value);
            return true;
        }
        return false;
    }

    default public void calculateMaintenance(IMaintenanceMachine maintenanceMachine, int duration) {
        if (!ConfigHolder.INSTANCE.machines.enableMaintenance || maintenanceMachine.isFullAuto()) {
            return;
        }
        if (this.calculateTime((int)((float)duration * maintenanceMachine.getTimeMultiplier())) && GTValues.RNG.m_188501_() - 0.75f >= 0.0f) {
            this.causeRandomMaintenanceProblems();
            maintenanceMachine.setTaped(false);
        }
    }

    default public int getNumMaintenanceProblems() {
        return ConfigHolder.INSTANCE.machines.enableMaintenance ? 6 - Integer.bitCount(this.getMaintenanceProblems()) : 0;
    }

    default public boolean hasMaintenanceProblems() {
        return ConfigHolder.INSTANCE.machines.enableMaintenance && this.getMaintenanceProblems() < 63;
    }

    default public void setMaintenanceFixed(int index) {
        this.setMaintenanceProblems((byte)(this.getMaintenanceProblems() | (byte)(1 << index)));
    }

    default public void causeRandomMaintenanceProblems() {
        this.setMaintenanceProblems((byte)(this.getMaintenanceProblems() & (byte)(~(1 << (int)(GTValues.RNG.m_188501_() * 5.0f)))));
    }

    @Override
    default public void afterWorking(IWorkableMultiController controller) {
        if (ConfigHolder.INSTANCE.machines.enableMaintenance) {
            this.calculateMaintenance(this, controller.getRecipeLogic().getProgress());
            if (this.hasMaintenanceProblems()) {
                controller.getRecipeLogic().markLastRecipeDirty();
            }
        }
    }

    @Override
    default public GTRecipe modifyRecipe(GTRecipe recipe) {
        if (ConfigHolder.INSTANCE.machines.enableMaintenance) {
            if (this.hasMaintenanceProblems()) {
                return null;
            }
            float durationMultiplier = this.getDurationMultiplier();
            if (durationMultiplier != 1.0f) {
                recipe = recipe.copy();
                recipe.duration = (int)((float)recipe.duration * durationMultiplier);
            }
        }
        return recipe;
    }

    @Override
    default public void attachFancyTooltipsToController(IMultiController controller, TooltipsPanel tooltipsPanel) {
        this.attachTooltips(tooltipsPanel);
    }

    @Override
    default public void attachTooltips(TooltipsPanel tooltipsPanel) {
        if (ConfigHolder.INSTANCE.machines.enableMaintenance) {
            tooltipsPanel.attachTooltips(new IFancyTooltip.Basic(() -> GuiTextures.MAINTENANCE_ICON, () -> {
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(Component.m_237115_((String)"gtceu.multiblock.universal.has_problems_header").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                if ((this.getMaintenanceProblems() & 1) == 0) {
                    tooltips.add(Component.m_237110_((String)"gtceu.multiblock.universal.problem.wrench", (Object[])new Object[]{"\n"}));
                }
                if ((this.getMaintenanceProblems() >> 1 & 1) == 0) {
                    tooltips.add(Component.m_237110_((String)"gtceu.multiblock.universal.problem.screwdriver", (Object[])new Object[]{"\n"}));
                }
                if ((this.getMaintenanceProblems() >> 2 & 1) == 0) {
                    tooltips.add(Component.m_237110_((String)"gtceu.multiblock.universal.problem.soft_mallet", (Object[])new Object[]{"\n"}));
                }
                if ((this.getMaintenanceProblems() >> 3 & 1) == 0) {
                    tooltips.add(Component.m_237110_((String)"gtceu.multiblock.universal.problem.hard_hammer", (Object[])new Object[]{"\n"}));
                }
                if ((this.getMaintenanceProblems() >> 4 & 1) == 0) {
                    tooltips.add(Component.m_237110_((String)"gtceu.multiblock.universal.problem.wire_cutter", (Object[])new Object[]{"\n"}));
                }
                if ((this.getMaintenanceProblems() >> 5 & 1) == 0) {
                    tooltips.add(Component.m_237110_((String)"gtceu.multiblock.universal.problem.crowbar", (Object[])new Object[]{"\n"}));
                }
                return tooltips;
            }, this::hasMaintenanceProblems, () -> null));
        }
    }
}

