/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.MultiblockWorldSavedData;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.api.syncdata.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockControllerMachine
extends MetaMachine
implements IMultiController {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MultiblockControllerMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    private MultiblockState multiblockState;
    private final List<IMultiPart> parts = new ArrayList<IMultiPart>();
    @DescSynced
    @UpdateListener(methodName="onPartsUpdated")
    private BlockPos[] partPositions = new BlockPos[0];
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean isFormed;
    private final Lock patternLock = new ReentrantLock();

    public MultiblockControllerMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public MultiblockMachineDefinition getDefinition() {
        return (MultiblockMachineDefinition)super.getDefinition();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).addAsyncLogic(this);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).removeAsyncLogic(this);
        }
    }

    @Override
    @Nonnull
    public MultiblockState getMultiblockState() {
        if (this.multiblockState == null) {
            this.multiblockState = new MultiblockState(this.getLevel(), this.getPos());
        }
        return this.multiblockState;
    }

    protected void onPartsUpdated(BlockPos[] newValue, BlockPos[] oldValue) {
        this.parts.clear();
        for (BlockPos pos : newValue) {
            MetaMachine metaMachine = MultiblockControllerMachine.getMachine((BlockGetter)this.getLevel(), pos);
            if (!(metaMachine instanceof IMultiPart)) continue;
            IMultiPart part = (IMultiPart)((Object)metaMachine);
            this.parts.add(part);
        }
    }

    protected void updatePartPositions() {
        this.partPositions = this.parts.isEmpty() ? new BlockPos[]{} : (BlockPos[])this.parts.stream().map(part -> part.self().getPos()).toArray(BlockPos[]::new);
    }

    @Override
    public List<IMultiPart> getParts() {
        if (this.parts.size() != this.partPositions.length) {
            this.parts.clear();
            for (BlockPos pos : this.partPositions) {
                MetaMachine metaMachine = MultiblockControllerMachine.getMachine((BlockGetter)this.getLevel(), pos);
                if (!(metaMachine instanceof IMultiPart)) continue;
                IMultiPart part = (IMultiPart)((Object)metaMachine);
                this.parts.add(part);
            }
        }
        return this.parts;
    }

    @Override
    public void asyncCheckPattern(long periodID) {
        Level level;
        if ((this.getMultiblockState().hasError() || !this.isFormed) && (this.getHolder().getOffset() + periodID) % 4L == 0L && this.checkPatternWithTryLock() && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().execute(() -> {
                this.patternLock.lock();
                if (this.checkPatternWithLock()) {
                    this.onStructureFormed();
                    MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                    mwsd.addMapping(this.getMultiblockState());
                    mwsd.removeAsyncLogic(this);
                }
                this.patternLock.unlock();
            });
        }
    }

    @Override
    public void onStructureFormed() {
        this.isFormed = true;
        this.parts.clear();
        Set set = this.getMultiblockState().getMatchContext().getOrCreate("parts", Collections::emptySet);
        for (IMultiPart part : set) {
            if (!this.shouldAddPartToController(part)) continue;
            this.parts.add(part);
        }
        this.parts.sort(this.getDefinition().getPartSorter());
        for (IMultiPart part : this.parts) {
            part.addedToController(this);
        }
        this.updatePartPositions();
    }

    @Override
    public void onStructureInvalid() {
        this.isFormed = false;
        for (IMultiPart part : this.parts) {
            part.removedFromController(this);
        }
        this.parts.clear();
        this.updatePartPositions();
    }

    @Override
    public void onPartUnload() {
        this.parts.removeIf(part -> part.self().isInValid());
        this.getMultiblockState().setError(MultiblockState.UNLOAD_ERROR);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).addAsyncLogic(this);
        }
        this.updatePartPositions();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        Level level;
        if (oldFacing != newFacing && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.onStructureInvalid();
            MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
            mwsd.removeMapping(this.getMultiblockState());
            mwsd.addAsyncLogic(this);
        }
    }

    public BlockPos[] getPartPositions() {
        return this.partPositions;
    }

    @Override
    public boolean isFormed() {
        return this.isFormed;
    }

    @Override
    public Lock getPatternLock() {
        return this.patternLock;
    }
}

