/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.steam;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedImageWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExhaustVentMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamEnergyRecipeHandler;
import com.gregtechceu.gtceu.api.machine.steam.SteamWorkableMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.common.recipe.VentCondition;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleSteamMachine
extends SteamWorkableMachine
implements IExhaustVentMachine,
IMachineModifyDrops,
IUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SimpleSteamMachine.class, SteamWorkableMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableItemStackHandler importItems;
    @Persisted
    public final NotifiableItemStackHandler exportItems;
    @Persisted
    private boolean needsVenting;

    public SimpleSteamMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.importItems = this.createImportItemHandler(args);
        this.exportItems = this.createExportItemHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableFluidTank createSteamTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16L * FluidHelper.getBucket(), IO.IN);
    }

    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxInputs(ItemRecipeCapability.CAP), IO.IN);
    }

    protected NotifiableItemStackHandler createExportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.getRecipeType().getMaxOutputs(ItemRecipeCapability.CAP), IO.OUT);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.capabilitiesProxy.put((Object)IO.IN, (Object)EURecipeCapability.CAP, List.of(new SteamEnergyRecipeHandler(this.steamTank, (double)FluidHelper.getBucket() / 1000.0)));
    }

    @Override
    public void onDrops(List<ItemStack> drops, Player entity) {
        SimpleSteamMachine.clearInventory(drops, (IItemTransfer)this.importItems.storage);
        SimpleSteamMachine.clearInventory(drops, (IItemTransfer)this.exportItems.storage);
    }

    @Override
    public float getVentingDamage() {
        return this.isHighPressure() ? 12.0f : 6.0f;
    }

    @Override
    @NotNull
    public Direction getVentingDirection() {
        return this.getOutputFacing();
    }

    @Override
    public boolean needsVenting() {
        return this.needsVenting;
    }

    @Override
    public void markVentingComplete() {
        this.needsVenting = false;
    }

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof SimpleSteamMachine) {
            SimpleSteamMachine steamMachine = (SimpleSteamMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > 1 || !steamMachine.checkVenting()) {
                return null;
            }
            GTRecipe modified = recipe.copy();
            modified.conditions.add(VentCondition.INSTANCE);
            if (!steamMachine.isHighPressure) {
                modified.duration *= 2;
                RecipeHelper.setInputEUt(modified, RecipeHelper.getInputEUt(recipe) / 2L);
            }
            return modified;
        }
        return null;
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
        this.needsVenting = true;
        this.checkVenting();
    }

    public ModularUI createUI(Player entityPlayer) {
        WidgetGroup group = this.getRecipeType().createUITemplate(this.recipeLogic::getProgressPercent, (IItemTransfer)this.importItems.storage, (IItemTransfer)this.exportItems.storage, IFluidTransfer.EMPTY, IFluidTransfer.EMPTY, true, this.isHighPressure);
        Position pos = new Position((Math.max(group.getSize().width + 4 + 8, 176) - 4 - group.getSize().width) / 2 + 4, 32);
        group.setSelfPosition(pos);
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(this.isHighPressure)}).widget((Widget)group).widget((Widget)new LabelWidget(5, 5, this.getBlockState().m_60734_().m_7705_())).widget((Widget)new PredicatedImageWidget(pos.x + group.getSize().width / 2 - 9, pos.y + group.getSize().height / 2 - 9, 18, 18, (IGuiTexture)GuiTextures.INDICATOR_NO_STEAM.get(this.isHighPressure)).setPredicate(this.recipeLogic::isWaiting)).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(this.isHighPressure), 7, 84, true));
    }

    @Override
    public void setNeedsVenting(boolean needsVenting) {
        this.needsVenting = needsVenting;
    }
}

