/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableItemStackHandler
extends NotifiableRecipeHandlerTrait<Ingredient>
implements ICapabilityTrait,
IItemTransfer {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableItemStackHandler.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    public final IO handlerIO;
    public final IO capabilityIO;
    @Persisted
    @DescSynced
    public final ItemStackTransfer storage;
    private Boolean isEmpty;

    public NotifiableItemStackHandler(MetaMachine machine, int slots, IO handlerIO, IO capabilityIO, Function<Integer, ItemStackTransfer> transferFactory) {
        super(machine);
        this.handlerIO = handlerIO;
        this.storage = transferFactory.apply(slots);
        this.capabilityIO = capabilityIO;
        this.storage.setOnContentsChanged(this::onContentsChanged);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, IO handlerIO, IO capabilityIO) {
        this(machine, slots, handlerIO, capabilityIO, ItemStackTransfer::new);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, IO handlerIO) {
        this(machine, slots, handlerIO, handlerIO);
    }

    public NotifiableItemStackHandler setFilter(Function<ItemStack, Boolean> filter) {
        this.storage.setFilter(filter);
        return this;
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
        return NotifiableItemStackHandler.handleIngredient(io, left, simulate, this.handlerIO, this.storage);
    }

    @Nullable
    public static List<Ingredient> handleIngredient(IO io, List<Ingredient> left, boolean simulate, IO handlerIO, ItemStackTransfer storage) {
        block9: {
            Iterator<Ingredient> iterator;
            ItemStackTransfer capability;
            block8: {
                if (io != handlerIO) {
                    return left;
                }
                capability = simulate ? storage.copy() : storage;
                iterator = left.iterator();
                if (io != IO.IN) break block8;
                block0: while (iterator.hasNext()) {
                    Ingredient ingredient = iterator.next();
                    for (int i = 0; i < capability.getSlots(); ++i) {
                        ItemStack[] ingredientStacks;
                        ItemStack itemStack = capability.getStackInSlot(i);
                        if (!ingredient.test(itemStack)) continue;
                        for (ItemStack ingredientStack : ingredientStacks = ingredient.m_43908_()) {
                            if (!ingredientStack.m_150930_(itemStack.m_41720_())) continue;
                            ItemStack extracted = capability.extractItem(i, ingredientStack.m_41613_(), false);
                            ingredientStack.m_41764_(ingredientStack.m_41613_() - extracted.m_41613_());
                            if (!ingredientStack.m_41619_()) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                }
                break block9;
            }
            if (io != IO.OUT) break block9;
            while (iterator.hasNext()) {
                Ingredient ingredient = iterator.next();
                ItemStack[] items = ingredient.m_43908_();
                if (items.length == 0) {
                    iterator.remove();
                    continue;
                }
                ItemStack output = items[0];
                if (!output.m_41619_()) {
                    for (int i = 0; i < capability.getSlots(); ++i) {
                        ItemStack leftStack = capability.insertItem(i, output.m_41777_(), false);
                        output.m_41764_(leftStack.m_41613_());
                        if (output.m_41619_()) break;
                    }
                }
                if (!output.m_41619_()) continue;
                iterator.remove();
            }
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    public RecipeCapability<Ingredient> getCapability() {
        return ItemRecipeCapability.CAP;
    }

    public int getSlots() {
        return this.storage.getSlots();
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                if (this.storage.getStackInSlot(i).m_41619_()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            ItemTransferHelper.exportToTarget((IItemTransfer)this, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }
    }

    public void importFromNearby(Direction ... facings) {
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            ItemTransferHelper.importToTarget((IItemTransfer)this, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.storage.getStackInSlot(slot);
    }

    public void setStackInSlot(int index, ItemStack stack) {
        this.storage.setStackInSlot(index, stack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChange) {
        if (this.canCapInput()) {
            return this.storage.insertItem(slot, stack, simulate, notifyChange);
        }
        return stack;
    }

    public ItemStack insertItemInternal(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.storage.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChange) {
        if (this.canCapOutput()) {
            return this.storage.extractItem(slot, amount, simulate, notifyChange);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return this.storage.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.storage.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.storage.isItemValid(slot, stack);
    }

    @NotNull
    public Object createSnapshot() {
        return this.storage.createSnapshot();
    }

    public void restoreFromSnapshot(Object snapshot) {
        this.storage.restoreFromSnapshot(snapshot);
    }

    @Override
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }
}

