/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.sound.AutoReleasedSound;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.api.syncdata.IEnhancedManaged;
import com.gregtechceu.gtceu.api.syncdata.UpdateListener;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.VisibleForTesting;

public class RecipeLogic
extends MachineTrait
implements IEnhancedManaged,
IWorkable,
IFancyTooltip {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(RecipeLogic.class);
    public final IRecipeLogicMachine machine;
    public List<GTRecipe> lastFailedMatches;
    @Persisted
    @DescSynced
    @UpdateListener(methodName="onStatusSynced")
    private Status status = Status.IDLE;
    @Nullable
    @Persisted
    @DescSynced
    private Component waitingReason = null;
    @Nullable
    @Persisted
    protected GTRecipe lastRecipe;
    @Nullable
    @Persisted
    protected GTRecipe lastOriginRecipe;
    @Persisted
    protected int progress;
    @Persisted
    protected int duration;
    @Persisted
    protected int fuelTime;
    @Persisted
    protected int fuelMaxTime;
    protected boolean recipeDirty;
    @Persisted
    protected long totalContinuousRunningTime;
    protected TickableSubscription subscription;
    protected Object workingSound;
    @Nullable
    protected CompletableFuture<List<GTRecipe>> completableFuture = null;
    protected boolean dirtySearching = false;

    public RecipeLogic(IRecipeLogicMachine machine) {
        super(machine.self());
        this.machine = machine;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void onStatusSynced(Status newValue, Status oldValue) {
        this.getMachine().scheduleRenderUpdate();
        this.updateSound();
    }

    @Override
    public void scheduleRenderUpdate() {
        this.getMachine().scheduleRenderUpdate();
    }

    public void resetRecipeLogic() {
        this.recipeDirty = false;
        this.lastRecipe = null;
        this.lastOriginRecipe = null;
        this.progress = 0;
        this.duration = 0;
        this.fuelTime = 0;
        this.lastFailedMatches = null;
        this.status = Status.IDLE;
        this.updateTickSubscription();
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        this.updateTickSubscription();
    }

    public void updateTickSubscription() {
        if (this.isSuspend() && this.fuelTime == 0 || !this.machine.isRecipeLogicAvailable()) {
            if (this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
        } else {
            this.subscription = this.getMachine().subscribeServerTick(this.subscription, this::serverTick);
            if (this.completableFuture != null) {
                this.dirtySearching = true;
            }
        }
    }

    public double getProgressPercent() {
        return this.duration == 0 ? 0.0 : (double)this.progress / ((double)this.duration * 1.0);
    }

    public boolean needFuel() {
        return this.machine.getRecipeType().isFuelRecipeType();
    }

    public RecipeManager getRecipeManager() {
        return Platform.getMinecraftServer().m_129894_();
    }

    public void serverTick() {
        if (!this.isSuspend()) {
            if (!this.isIdle() && this.lastRecipe != null) {
                if (this.progress < this.duration) {
                    this.handleRecipeWorking();
                }
                if (this.progress >= this.duration) {
                    this.onRecipeFinish();
                }
            } else if (this.lastRecipe != null) {
                this.findAndHandleRecipe();
            } else if (!this.machine.keepSubscribing() || this.getMachine().getOffsetTimer() % 5L == 0L) {
                this.findAndHandleRecipe();
                if (this.lastFailedMatches != null) {
                    for (GTRecipe match : this.lastFailedMatches) {
                        if (this.checkMatchedRecipeAvailable(match)) break;
                    }
                }
            }
        }
        if (this.fuelTime > 0) {
            --this.fuelTime;
        } else {
            boolean unsubscribe = false;
            if (this.isSuspend()) {
                unsubscribe = true;
                if (this.completableFuture != null) {
                    this.completableFuture.cancel(true);
                    this.completableFuture = null;
                }
            } else if (this.completableFuture == null && this.lastRecipe == null && this.isIdle() && !this.machine.keepSubscribing() && !this.recipeDirty && this.lastFailedMatches == null) {
                unsubscribe = true;
            }
            if (unsubscribe && this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
        }
    }

    protected boolean checkMatchedRecipeAvailable(GTRecipe match) {
        GTRecipe modified = this.machine.fullModifyRecipe(match);
        if (modified != null) {
            if (modified.checkConditions(this).isSuccess() && modified.matchRecipe(this.machine).isSuccess() && modified.matchTickRecipe(this.machine).isSuccess()) {
                this.setupRecipe(modified);
            }
            if (this.lastRecipe != null && this.getStatus() == Status.WORKING) {
                this.lastOriginRecipe = match;
                this.lastFailedMatches = null;
                return true;
            }
        }
        return false;
    }

    public void handleRecipeWorking() {
        Status last = this.status;
        assert (this.lastRecipe != null);
        GTRecipe.ActionResult result = this.lastRecipe.checkConditions(this);
        if (result.isSuccess()) {
            if (this.handleFuelRecipe()) {
                result = this.handleTickRecipe(this.lastRecipe);
                if (result.isSuccess()) {
                    this.setStatus(Status.WORKING);
                    this.machine.onWorking();
                    ++this.progress;
                    ++this.totalContinuousRunningTime;
                } else {
                    this.setWaiting(result.reason().get());
                }
            } else {
                this.setWaiting((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_fuel"));
            }
        } else {
            this.setWaiting(result.reason().get());
        }
        if (this.isWaiting()) {
            this.doDamping();
        }
        if (last == Status.WORKING && this.getStatus() != Status.WORKING) {
            this.lastRecipe.postWorking(this.machine);
        } else if (last != Status.WORKING && this.getStatus() == Status.WORKING) {
            this.lastRecipe.preWorking(this.machine);
        }
    }

    protected void doDamping() {
        if (this.progress > 0 && this.machine.dampingWhenWaiting()) {
            this.progress = ConfigHolder.INSTANCE.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progress - 2);
        }
    }

    protected List<GTRecipe> searchRecipe() {
        return this.machine.getRecipeType().searchRecipe(this.getRecipeManager(), this.machine);
    }

    public void findAndHandleRecipe() {
        this.lastFailedMatches = null;
        if (!this.recipeDirty && this.lastRecipe != null && this.lastRecipe.matchRecipe(this.machine).isSuccess() && this.lastRecipe.matchTickRecipe(this.machine).isSuccess() && this.lastRecipe.checkConditions(this).isSuccess()) {
            GTRecipe recipe = this.lastRecipe;
            this.lastRecipe = null;
            this.lastOriginRecipe = null;
            this.setupRecipe(recipe);
        } else {
            this.lastRecipe = null;
            this.lastOriginRecipe = null;
            if (this.completableFuture == null) {
                if (ConfigHolder.INSTANCE.machines.asyncRecipeSearching) {
                    this.completableFuture = this.supplyAsyncSearchingTask();
                } else {
                    this.handleSearchingRecipes(this.searchRecipe());
                }
                this.dirtySearching = false;
            } else if (this.completableFuture.isDone()) {
                CompletableFuture<List<GTRecipe>> lastFuture = this.completableFuture;
                this.completableFuture = null;
                if (!lastFuture.isCancelled()) {
                    try {
                        List<GTRecipe> matches = lastFuture.join().stream().filter(match -> match.matchRecipe(this.machine).isSuccess()).toList();
                        if (!matches.isEmpty()) {
                            this.handleSearchingRecipes(matches);
                        } else if (this.dirtySearching) {
                            this.completableFuture = this.supplyAsyncSearchingTask();
                        }
                    }
                    catch (Throwable throwable) {
                        this.completableFuture = this.supplyAsyncSearchingTask();
                    }
                } else {
                    this.handleSearchingRecipes(this.searchRecipe());
                }
                this.dirtySearching = false;
            }
        }
        this.recipeDirty = false;
    }

    private CompletableFuture<List<GTRecipe>> supplyAsyncSearchingTask() {
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"Searching recipes", this::searchRecipe), Util.m_183991_());
    }

    private void handleSearchingRecipes(List<GTRecipe> matches) {
        for (GTRecipe match : matches) {
            if (this.checkMatchedRecipeAvailable(match)) break;
            if (this.lastFailedMatches == null) {
                this.lastFailedMatches = new ArrayList<GTRecipe>();
            }
            this.lastFailedMatches.add(match);
        }
    }

    public boolean handleFuelRecipe() {
        if (!this.needFuel() || this.fuelTime > 0) {
            return true;
        }
        for (GTRecipe recipe : this.machine.getRecipeType().searchFuelRecipe(this.getRecipeManager(), this.machine)) {
            if (recipe.checkConditions(this).isSuccess() && recipe.handleRecipeIO(IO.IN, this.machine)) {
                this.fuelTime = this.fuelMaxTime = recipe.duration;
            }
            if (this.fuelTime <= 0) continue;
            return true;
        }
        return false;
    }

    public GTRecipe.ActionResult handleTickRecipe(GTRecipe recipe) {
        if (recipe.hasTick()) {
            GTRecipe.ActionResult result = recipe.matchTickRecipe(this.machine);
            if (result.isSuccess()) {
                recipe.handleTickRecipeIO(IO.IN, this.machine);
                recipe.handleTickRecipeIO(IO.OUT, this.machine);
            } else {
                return result;
            }
        }
        return GTRecipe.ActionResult.SUCCESS;
    }

    public void setupRecipe(GTRecipe recipe) {
        if (this.handleFuelRecipe()) {
            this.machine.beforeWorking();
            recipe.preWorking(this.machine);
            if (recipe.handleRecipeIO(IO.IN, this.machine)) {
                this.recipeDirty = false;
                this.lastRecipe = recipe;
                this.setStatus(Status.WORKING);
                this.progress = 0;
                this.duration = recipe.duration;
            }
        }
    }

    public void setStatus(Status status) {
        if (this.status != status) {
            if (this.status == Status.WORKING) {
                this.totalContinuousRunningTime = 0L;
            }
            this.machine.notifyStatusChanged(this.status, status);
            this.status = status;
            this.updateTickSubscription();
            if (this.status != Status.WAITING) {
                this.waitingReason = null;
            }
        }
    }

    public void setWaiting(@Nullable Component reason) {
        this.setStatus(Status.WAITING);
        this.waitingReason = reason;
        this.machine.onWaiting();
    }

    public void markLastRecipeDirty() {
        this.recipeDirty = true;
    }

    public boolean isWorking() {
        return this.status == Status.WORKING;
    }

    public boolean isIdle() {
        return this.status == Status.IDLE;
    }

    public boolean isWaiting() {
        return this.status == Status.WAITING;
    }

    public boolean isSuspend() {
        return this.status == Status.SUSPEND;
    }

    @Override
    public boolean isWorkingEnabled() {
        return !this.isSuspend();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (!isWorkingAllowed) {
            this.setStatus(Status.SUSPEND);
        } else if (this.lastRecipe != null && this.duration > 0) {
            this.setStatus(Status.WORKING);
        } else {
            this.setStatus(Status.IDLE);
        }
    }

    @Override
    public int getMaxProgress() {
        return this.duration;
    }

    @Override
    public boolean isActive() {
        return this.isWorking() || this.isWaiting() || this.isSuspend() && this.lastRecipe != null && this.duration > 0;
    }

    @Deprecated
    public boolean isHasNotEnoughEnergy() {
        return this.isWaiting();
    }

    public void onRecipeFinish() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.lastRecipe.postWorking(this.machine);
            this.lastRecipe.handleRecipeIO(IO.OUT, this.machine);
            if (this.machine.alwaysTryModifyRecipe()) {
                if (this.lastOriginRecipe != null) {
                    GTRecipe modified = this.machine.fullModifyRecipe(this.lastOriginRecipe);
                    if (modified == null) {
                        this.markLastRecipeDirty();
                    } else {
                        this.lastRecipe = modified;
                    }
                } else {
                    this.markLastRecipeDirty();
                }
            }
            if (!this.recipeDirty && this.lastRecipe.matchRecipe(this.machine).isSuccess() && this.lastRecipe.matchTickRecipe(this.machine).isSuccess() && this.lastRecipe.checkConditions(this).isSuccess()) {
                this.setupRecipe(this.lastRecipe);
            } else {
                this.setStatus(Status.IDLE);
                this.progress = 0;
                this.duration = 0;
            }
        }
    }

    public void interruptRecipe() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.lastRecipe.postWorking(this.machine);
            this.setStatus(Status.IDLE);
            this.progress = 0;
            this.duration = 0;
        }
    }

    public void inValid() {
        if (this.lastRecipe != null && this.isWorking()) {
            this.lastRecipe.postWorking(this.machine);
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSound() {
        if (this.isWorking() && this.machine.shouldWorkingPlaySound()) {
            SoundEntry sound = this.machine.getRecipeType().getSound();
            Object object = this.workingSound;
            if (object instanceof AutoReleasedSound) {
                AutoReleasedSound soundEntry = (AutoReleasedSound)((Object)object);
                if (soundEntry.soundEntry == sound && !soundEntry.m_7801_()) {
                    return;
                }
                soundEntry.release();
                this.workingSound = null;
            }
            if (sound != null) {
                this.workingSound = sound.playAutoReleasedSound(() -> this.machine.shouldWorkingPlaySound() && this.isWorking() && !this.getMachine().isInValid() && this.getMachine().getLevel().m_46749_(this.getMachine().getPos()) && MetaMachine.getMachine((BlockGetter)this.getMachine().getLevel(), this.getMachine().getPos()) == this.getMachine(), this.getMachine().getPos(), true, 0, 1.0f, 1.0f);
            }
        } else {
            Object object = this.workingSound;
            if (object instanceof AutoReleasedSound) {
                AutoReleasedSound soundEntry = (AutoReleasedSound)((Object)object);
                soundEntry.release();
                this.workingSound = null;
            }
        }
    }

    @Override
    public IGuiTexture getFancyTooltipIcon() {
        if (this.isWaiting()) {
            return GuiTextures.INSUFFICIENT_INPUT;
        }
        return IGuiTexture.EMPTY;
    }

    @Override
    public List<Component> getFancyTooltip() {
        if (this.isWaiting() && this.waitingReason != null) {
            return List.of(this.waitingReason);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean showFancyTooltip() {
        return this.isWaiting();
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public GTRecipe getLastRecipe() {
        return this.lastRecipe;
    }

    @Nullable
    public GTRecipe getLastOriginRecipe() {
        return this.lastOriginRecipe;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public int getFuelMaxTime() {
        return this.fuelMaxTime;
    }

    @VisibleForTesting
    public boolean isRecipeDirty() {
        return this.recipeDirty;
    }

    public long getTotalContinuousRunningTime() {
        return this.totalContinuousRunningTime;
    }

    public static enum Status {
        IDLE,
        WORKING,
        WAITING,
        SUSPEND;

    }
}

