/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet;

import com.gregtechceu.gtceu.api.pipenet.ITickablePipeNet;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TickableLevelPipeNet<NodeDataType, T extends PipeNet<NodeDataType>>
extends LevelPipeNet<NodeDataType, T> {
    private final Map<T, List<ChunkPos>> loadedChunksByPipeNet = new HashMap<T, List<ChunkPos>>();
    private final Set<T> tickingPipeNets = new HashSet<T>();
    private final Set<T> removeLater = new HashSet<T>();

    public TickableLevelPipeNet(ServerLevel serverLevel) {
        super(serverLevel);
    }

    public TickableLevelPipeNet(ServerLevel serverLevel, CompoundTag tag) {
        super(serverLevel, tag);
    }

    private boolean isChunkLoaded(ChunkPos chunkPos) {
        ServerLevel worldServer = this.getWorld();
        if (worldServer == null) {
            return false;
        }
        return worldServer.m_7726_().m_5563_(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    protected abstract int getUpdateRate();

    public void update() {
        if (this.getWorld().m_46467_() % (long)this.getUpdateRate() == 0L) {
            this.tickingPipeNets.forEach(rec$ -> ((ITickablePipeNet)rec$).update());
        }
        if (this.removeLater.size() > 0) {
            this.removeLater.forEach(x$0 -> this.tickingPipeNets.remove(x$0));
            this.removeLater.clear();
        }
    }

    public void onChunkLoaded(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        List pipeNetsInThisChunk = (List)this.pipeNetsByChunk.get(chunkPos);
        if (pipeNetsInThisChunk == null) {
            return;
        }
        for (PipeNet pipeNet : pipeNetsInThisChunk) {
            List<ChunkPos> loadedChunks = this.getOrCreateChunkListForPipeNet(pipeNet);
            if (loadedChunks.isEmpty()) {
                this.tickingPipeNets.add(pipeNet);
            }
            loadedChunks.add(chunkPos);
        }
    }

    public void onChunkUnloaded(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        List pipeNetsInThisChunk = (List)this.pipeNetsByChunk.get(chunkPos);
        if (pipeNetsInThisChunk == null) {
            return;
        }
        for (PipeNet pipeNet : pipeNetsInThisChunk) {
            List<ChunkPos> loadedChunks = this.loadedChunksByPipeNet.get(pipeNet);
            if (loadedChunks == null || !loadedChunks.contains(chunkPos)) continue;
            loadedChunks.remove(chunkPos);
            if (!loadedChunks.isEmpty()) continue;
            this.removeFromTicking(pipeNet);
        }
    }

    protected void init() {
        super.init();
        Map<PipeNet, List> pipeNetByLoadedChunks = this.pipeNets.stream().map(pipeNet -> Pair.of((Object)pipeNet, this.getPipeNetLoadedChunks(pipeNet))).filter(pair -> !((List)pair.getRight()).isEmpty()).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        if (!pipeNetByLoadedChunks.isEmpty()) {
            this.tickingPipeNets.addAll(pipeNetByLoadedChunks.keySet());
            this.loadedChunksByPipeNet.putAll(pipeNetByLoadedChunks);
        }
    }

    protected void addPipeNet(T pipeNet) {
        super.addPipeNet(pipeNet);
        List<ChunkPos> loadedChunks = this.getPipeNetLoadedChunks(pipeNet);
        if (!loadedChunks.isEmpty()) {
            this.loadedChunksByPipeNet.put(pipeNet, loadedChunks);
            this.tickingPipeNets.add(pipeNet);
        }
    }

    private List<ChunkPos> getPipeNetLoadedChunks(T pipeNet) {
        return pipeNet.getContainedChunks().stream().filter(this::isChunkLoaded).collect(Collectors.toList());
    }

    protected void removePipeNet(T pipeNet) {
        super.removePipeNet(pipeNet);
        if (this.loadedChunksByPipeNet.containsKey(pipeNet)) {
            this.removeFromTicking(pipeNet);
        }
    }

    private void removeFromTicking(T pipeNet) {
        this.loadedChunksByPipeNet.remove(pipeNet);
        this.removeLater.add(pipeNet);
    }

    private List<ChunkPos> getOrCreateChunkListForPipeNet(T pipeNet) {
        return this.loadedChunksByPipeNet.computeIfAbsent(pipeNet, k -> new ArrayList());
    }

    protected void addPipeNetToChunk(ChunkPos chunkPos, T pipeNet) {
        super.addPipeNetToChunk(chunkPos, pipeNet);
        if (this.isChunkLoaded(chunkPos)) {
            List<ChunkPos> loadedChunks = this.getOrCreateChunkListForPipeNet(pipeNet);
            if (loadedChunks.isEmpty()) {
                this.tickingPipeNets.add(pipeNet);
            }
            loadedChunks.add(chunkPos);
        }
    }

    protected void removePipeNetFromChunk(ChunkPos chunkPos, T pipeNet) {
        super.removePipeNetFromChunk(chunkPos, pipeNet);
        List<ChunkPos> loadedChunks = this.loadedChunksByPipeNet.get(pipeNet);
        if (loadedChunks != null && loadedChunks.contains(chunkPos)) {
            loadedChunks.remove(chunkPos);
            if (loadedChunks.isEmpty()) {
                this.removeFromTicking(pipeNet);
            }
        }
    }
}

