/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTRecipe
implements Recipe<Container> {
    public final GTRecipeType recipeType;
    public final ResourceLocation id;
    public final Map<RecipeCapability<?>, List<Content>> inputs;
    public final Map<RecipeCapability<?>, List<Content>> outputs;
    public final Map<RecipeCapability<?>, List<Content>> tickInputs;
    public final Map<RecipeCapability<?>, List<Content>> tickOutputs;
    public final List<RecipeCondition> conditions;
    public CompoundTag data;
    public int duration;
    public boolean isFuel;

    public GTRecipe(GTRecipeType recipeType, ResourceLocation id, Map<RecipeCapability<?>, List<Content>> inputs, Map<RecipeCapability<?>, List<Content>> outputs, Map<RecipeCapability<?>, List<Content>> tickInputs, Map<RecipeCapability<?>, List<Content>> tickOutputs, List<RecipeCondition> conditions, CompoundTag data, int duration, boolean isFuel) {
        this.recipeType = recipeType;
        this.id = id;
        this.inputs = inputs;
        this.outputs = outputs;
        this.tickInputs = tickInputs;
        this.tickOutputs = tickOutputs;
        this.conditions = conditions;
        this.data = data;
        this.duration = duration;
        this.isFuel = isFuel;
    }

    public Map<RecipeCapability<?>, List<Content>> copyContents(Map<RecipeCapability<?>, List<Content>> contents, @Nullable ContentModifier modifier) {
        HashMap copyContents = new HashMap();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            List<Content> contentList = entry.getValue();
            RecipeCapability<?> cap = entry.getKey();
            if (contentList == null || contentList.isEmpty()) continue;
            ArrayList<Content> contentsCopy = new ArrayList<Content>();
            for (Content content : contentList) {
                contentsCopy.add(content.copy(cap, modifier));
            }
            copyContents.put(entry.getKey(), contentsCopy);
        }
        return copyContents;
    }

    public GTRecipe copy() {
        return new GTRecipe(this.recipeType, this.id, this.copyContents(this.inputs, null), this.copyContents(this.outputs, null), this.copyContents(this.tickInputs, null), this.copyContents(this.tickOutputs, null), this.conditions, this.data, this.duration, this.isFuel);
    }

    public GTRecipe copy(ContentModifier modifier) {
        return this.copy(modifier, true);
    }

    public GTRecipe copy(ContentModifier modifier, boolean modifyDuration) {
        GTRecipe copied = new GTRecipe(this.recipeType, this.id, this.copyContents(this.inputs, modifier), this.copyContents(this.outputs, modifier), this.copyContents(this.tickInputs, modifier), this.copyContents(this.tickOutputs, modifier), this.conditions, this.data, this.duration, this.isFuel);
        if (modifyDuration) {
            copied.duration = modifier.apply(this.duration).intValue();
        }
        return copied;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return GTRecipeSerializer.SERIALIZER;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return this.recipeType;
    }

    public boolean m_5818_(@NotNull Container pContainer, @NotNull Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public List<Content> getInputContents(RecipeCapability<?> capability) {
        return this.inputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getOutputContents(RecipeCapability<?> capability) {
        return this.outputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getTickInputContents(RecipeCapability<?> capability) {
        return this.tickInputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getTickOutputContents(RecipeCapability<?> capability) {
        return this.tickOutputs.getOrDefault(capability, Collections.emptyList());
    }

    public ActionResult matchRecipe(IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies()) {
            return ActionResult.FAIL_NO_REASON;
        }
        ActionResult result = this.matchRecipe(IO.IN, holder, this.inputs, false);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.matchRecipe(IO.OUT, holder, this.outputs, false);
        if (!result.isSuccess()) {
            return result;
        }
        return ActionResult.SUCCESS;
    }

    public ActionResult matchTickRecipe(IRecipeCapabilityHolder holder) {
        if (this.hasTick()) {
            if (!holder.hasProxies()) {
                return ActionResult.FAIL_NO_REASON;
            }
            ActionResult result = this.matchRecipe(IO.IN, holder, this.tickInputs, false);
            if (!result.isSuccess()) {
                return result;
            }
            result = this.matchRecipe(IO.OUT, holder, this.tickOutputs, false);
            if (!result.isSuccess()) {
                return result;
            }
        }
        return ActionResult.SUCCESS;
    }

    public ActionResult matchRecipe(IO io, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, List<Content>> contents, boolean calculateExpectingRate) {
        Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilityProxies = holder.getCapabilitiesProxy();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            Tuple<List, Map<String, List>> result;
            HashSet used = new HashSet();
            List<Object> content = new ArrayList<Object>();
            HashMap<String, List> contentSlot = new HashMap<String, List>();
            for (Content cont : entry.getValue()) {
                if (cont.slotName == null) {
                    content.add(cont.content);
                    continue;
                }
                contentSlot.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
            }
            RecipeCapability<?> capability = entry.getKey();
            if ((content = content.stream().map(capability::copyContent).toList()).isEmpty() && contentSlot.isEmpty()) continue;
            if (content.isEmpty()) {
                content = null;
            }
            if ((result = this.handlerContentsInternal(io, io, capabilityProxies, capability, used, content, contentSlot, content, contentSlot, true)).m_14418_() == null && ((Map)result.m_14419_()).isEmpty() || (result = this.handlerContentsInternal(IO.BOTH, io, capabilityProxies, capability, used, (List)result.m_14418_(), (Map)result.m_14419_(), content, contentSlot, true)).m_14418_() == null && ((Map)result.m_14419_()).isEmpty()) continue;
            float expectingRate = 0.0f;
            if (io == IO.IN) {
                return ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.insufficient_in").m_130946_(": ").m_7220_(capability.getTraslateComponent()), expectingRate);
            }
            if (io == IO.OUT) {
                return ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.insufficient_out").m_130946_(": ").m_7220_(capability.getTraslateComponent()), expectingRate);
            }
            return ActionResult.FAIL_NO_REASON;
        }
        return ActionResult.SUCCESS;
    }

    public boolean handleTickRecipeIO(IO io, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies() || io == IO.BOTH) {
            return false;
        }
        return this.handleRecipe(io, holder, io == IO.IN ? this.tickInputs : this.tickOutputs);
    }

    public boolean handleRecipeIO(IO io, IRecipeCapabilityHolder holder) {
        if (!holder.hasProxies() || io == IO.BOTH) {
            return false;
        }
        return this.handleRecipe(io, holder, io == IO.IN ? this.inputs : this.outputs);
    }

    public boolean handleRecipe(IO io, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, List<Content>> contents) {
        Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilityProxies = holder.getCapabilitiesProxy();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            Tuple<List, Map<String, List>> result;
            HashSet used = new HashSet();
            List<Object> content = new ArrayList();
            HashMap<String, List> contentSlot = new HashMap<String, List>();
            ArrayList<Object> contentSearch = new ArrayList<Object>();
            HashMap<String, List> contentSlotSearch = new HashMap<String, List>();
            for (Content cont : entry.getValue()) {
                if (cont.slotName == null) {
                    contentSearch.add(cont.content);
                } else {
                    contentSlotSearch.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
                }
                if (!(cont.chance >= 1.0f) && !(GTValues.RNG.m_188501_() < cont.chance + (float)holder.getChanceTier() * cont.tierChanceBoost)) continue;
                if (cont.slotName == null) {
                    content.add(cont.content);
                    continue;
                }
                contentSlot.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
            }
            RecipeCapability<?> capability = entry.getKey();
            if ((content = content.stream().map(capability::copyContent).toList()).isEmpty() && contentSlot.isEmpty()) continue;
            if (content.isEmpty()) {
                content = null;
            }
            if ((result = this.handlerContentsInternal(io, io, capabilityProxies, capability, used, content, contentSlot, contentSearch, contentSlotSearch, false)).m_14418_() == null && ((Map)result.m_14419_()).isEmpty() || (result = this.handlerContentsInternal(IO.BOTH, io, capabilityProxies, capability, used, (List)result.m_14418_(), (Map)result.m_14419_(), contentSearch, contentSlotSearch, false)).m_14418_() == null && ((Map)result.m_14419_()).isEmpty()) continue;
            GTCEu.LOGGER.warn("io error while handling a recipe {} outputs. holder: {}", (Object)this.id, (Object)holder);
            return false;
        }
        return true;
    }

    private Tuple<List, Map<String, List>> handlerContentsInternal(IO capIO, IO io, Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilityProxies, RecipeCapability<?> capability, Set<IRecipeHandler<?>> used, List content, Map<String, List> contentSlot, List contentSearch, Map<String, List> contentSlotSearch, boolean simulate) {
        if (capabilityProxies.contains((Object)capIO, capability)) {
            List handlers = (List)capabilityProxies.get((Object)capIO, capability);
            for (IRecipeHandler handler : handlers) {
                if (!handler.isDistinct()) continue;
                List result = handler.handleRecipe(io, this, contentSearch, null, true);
                if (result == null) {
                    if (handler.getSlotNames() != null && handler.getSlotNames().containsAll(contentSlotSearch.keySet())) {
                        boolean success = true;
                        for (Map.Entry<String, List> entry : contentSlotSearch.entrySet()) {
                            List left = handler.handleRecipe(io, this, entry.getValue(), entry.getKey(), true);
                            if (left == null) continue;
                            success = false;
                            break;
                        }
                        if (success) {
                            if (!simulate) {
                                for (Map.Entry<String, List> entry : contentSlot.entrySet()) {
                                    handler.handleRecipe(io, this, entry.getValue(), entry.getKey(), false);
                                }
                            }
                            contentSlot.clear();
                        }
                    }
                    if (contentSlot.isEmpty()) {
                        if (!simulate) {
                            handler.handleRecipe(io, this, content, null, false);
                        }
                        content = null;
                    }
                }
                if (content != null || !contentSlot.isEmpty()) continue;
                break;
            }
            if (content != null || !contentSlot.isEmpty()) {
                for (IRecipeHandler proxy : handlers) {
                    if (used.contains(proxy) || proxy.isDistinct()) continue;
                    used.add(proxy);
                    if (content != null) {
                        content = proxy.handleRecipe(io, this, content, null, simulate);
                    }
                    if (proxy.getSlotNames() != null) {
                        Iterator<String> iterator = contentSlot.keySet().iterator();
                        while (iterator.hasNext()) {
                            List left;
                            String key = iterator.next();
                            if (!proxy.getSlotNames().contains(key) || (left = proxy.handleRecipe(io, this, contentSlot.get(key), key, simulate)) != null) continue;
                            iterator.remove();
                        }
                    }
                    if (content != null || !contentSlot.isEmpty()) continue;
                    break;
                }
            }
        }
        return new Tuple((Object)content, contentSlot);
    }

    public boolean hasTick() {
        return !this.tickInputs.isEmpty() || !this.tickOutputs.isEmpty();
    }

    public void preWorking(IRecipeCapabilityHolder holder) {
        this.handlePre(this.inputs, holder, IO.IN);
        this.handlePre(this.outputs, holder, IO.OUT);
    }

    public void postWorking(IRecipeCapabilityHolder holder) {
        this.handlePost(this.inputs, holder, IO.IN);
        this.handlePost(this.outputs, holder, IO.OUT);
    }

    public void handlePre(Map<RecipeCapability<?>, List<Content>> contents, IRecipeCapabilityHolder holder, IO io) {
        contents.forEach((capability, tuples) -> {
            block3: {
                block2: {
                    if (!holder.getCapabilitiesProxy().contains((Object)io, capability)) break block2;
                    for (IRecipeHandler capabilityProxy : (List)holder.getCapabilitiesProxy().get((Object)io, capability)) {
                        capabilityProxy.preWorking(holder, io, this);
                    }
                    break block3;
                }
                if (!holder.getCapabilitiesProxy().contains((Object)IO.BOTH, capability)) break block3;
                for (IRecipeHandler capabilityProxy : (List)holder.getCapabilitiesProxy().get((Object)IO.BOTH, capability)) {
                    capabilityProxy.preWorking(holder, io, this);
                }
            }
        });
    }

    public void handlePost(Map<RecipeCapability<?>, List<Content>> contents, IRecipeCapabilityHolder holder, IO io) {
        contents.forEach((capability, tuples) -> {
            block3: {
                block2: {
                    if (!holder.getCapabilitiesProxy().contains((Object)io, capability)) break block2;
                    for (IRecipeHandler capabilityProxy : (List)holder.getCapabilitiesProxy().get((Object)io, capability)) {
                        capabilityProxy.postWorking(holder, io, this);
                    }
                    break block3;
                }
                if (!holder.getCapabilitiesProxy().contains((Object)IO.BOTH, capability)) break block3;
                for (IRecipeHandler capabilityProxy : (List)holder.getCapabilitiesProxy().get((Object)IO.BOTH, capability)) {
                    capabilityProxy.postWorking(holder, io, this);
                }
            }
        });
    }

    public ActionResult checkConditions(@Nonnull RecipeLogic recipeLogic) {
        if (this.conditions.isEmpty()) {
            return ActionResult.SUCCESS;
        }
        HashMap<String, List> or = new HashMap<String, List>();
        for (RecipeCondition condition2 : this.conditions) {
            if (condition2.isOr()) {
                or.computeIfAbsent(condition2.getType(), type -> new ArrayList()).add(condition2);
                continue;
            }
            if (condition2.test(this, recipeLogic) != condition2.isReverse()) continue;
            return ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.condition_fails").m_130946_(": ").m_7220_(condition2.getTooltips()));
        }
        for (List conditions : or.values()) {
            if (!conditions.stream().allMatch(condition -> condition.test(this, recipeLogic) == condition.isReverse())) continue;
            return ActionResult.fail(() -> Component.m_237115_((String)"gtceu.recipe_logic.condition_fails"));
        }
        return ActionResult.SUCCESS;
    }

    public GTRecipe trimRecipeOutputs(Map<RecipeCapability<?>, Integer> trimLimits) {
        if (trimLimits.isEmpty() || trimLimits.values().stream().allMatch(integer -> integer == -1)) {
            return this;
        }
        GTRecipe current = this.copy();
        GTRecipeBuilder builder = new GTRecipeBuilder(current, this.recipeType);
        builder.output.clear();
        builder.tickOutput.clear();
        Map<RecipeCapability<?>, List<Content>> recipeOutputs = this.doTrim(current.outputs, trimLimits);
        Map<RecipeCapability<?>, List<Content>> recipeTickOutputs = this.doTrim(current.tickOutputs, trimLimits);
        builder.output.putAll(recipeOutputs);
        builder.tickOutput.putAll(recipeTickOutputs);
        return builder.buildRawRecipe();
    }

    public Map<RecipeCapability<?>, List<Content>> doTrim(Map<RecipeCapability<?>, List<Content>> current, Map<RecipeCapability<?>, Integer> trimLimits) {
        HashMap outputs = new HashMap();
        HashSet trimmed = new HashSet();
        for (Map.Entry<RecipeCapability<?>, Integer> entry : trimLimits.entrySet()) {
            RecipeCapability<?> key = entry.getKey();
            if (!current.containsKey(key)) continue;
            ArrayList<Content> nonChanced = new ArrayList<Content>();
            List chanced = new ArrayList<Content>();
            for (Content content : current.getOrDefault(key, List.of())) {
                if (content.chance <= 0.0f || content.chance >= 1.0f) {
                    nonChanced.add(content);
                    continue;
                }
                chanced.add(content);
            }
            int outputLimit = entry.getValue();
            if (outputLimit == -1) {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(nonChanced);
            } else if (nonChanced.size() >= outputLimit) {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(nonChanced.stream().map(cont -> cont.copy(key, null)).toList().subList(0, outputLimit));
                chanced.clear();
            } else if (!nonChanced.isEmpty() && nonChanced.size() + chanced.size() >= outputLimit) {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(nonChanced.stream().map(cont -> cont.copy(key, null)).toList());
                int numChanced = outputLimit - nonChanced.size();
                chanced = chanced.subList(0, Math.min(numChanced, chanced.size()));
            } else if (nonChanced.isEmpty()) {
                chanced = chanced.subList(0, Math.min(outputLimit, chanced.size()));
            } else {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(nonChanced.stream().map(cont -> cont.copy(key, null)).toList());
            }
            if (!chanced.isEmpty()) {
                outputs.computeIfAbsent(key, $ -> new ArrayList()).addAll(chanced.stream().map(cont -> cont.copy(key, null)).toList());
            }
            trimmed.add(key);
        }
        for (Map.Entry<RecipeCapability<?>, Object> entry : current.entrySet()) {
            if (trimmed.contains(entry.getKey())) continue;
            outputs.computeIfAbsent(entry.getKey(), $ -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        return outputs;
    }

    public boolean checkRecipeValid() {
        return this.checkItemValid(this.inputs, "input") && this.checkItemValid(this.outputs, "output") && this.checkItemValid(this.tickInputs, "tickInput") && this.checkItemValid(this.tickOutputs, "tickOutput");
    }

    private boolean checkItemValid(Map<RecipeCapability<?>, List<Content>> contents, String name) {
        for (Content content : contents.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList())) {
            ItemStack[] items = ((Ingredient)ItemRecipeCapability.CAP.of(content.content)).m_43908_();
            if (items.length == 0) {
                GTCEu.LOGGER.error("recipe {} {} item length is 0", (Object)this.id, (Object)name);
                return false;
            }
            if (!Arrays.stream(items).anyMatch(ItemStack::m_41619_)) continue;
            GTCEu.LOGGER.error("recipe {} {} item is empty", (Object)this.id, (Object)name);
            return false;
        }
        return true;
    }

    public boolean isFuel() {
        return this.isFuel;
    }

    public record ActionResult(boolean isSuccess, @Nullable Supplier<Component> reason, float expectingRate) {
        public static final ActionResult SUCCESS = new ActionResult(true, null, 0.0f);
        public static final ActionResult FAIL_NO_REASON = new ActionResult(true, null, 0.0f);

        public static ActionResult fail(@Nullable Supplier<Component> component) {
            return new ActionResult(false, component, 0.0f);
        }

        public static ActionResult fail(@Nullable Supplier<Component> component, float expectingRate) {
            return new ActionResult(false, component, expectingRate);
        }
    }
}

