/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.ingredient.NBTIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.forge.SizedIngredientImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizedIngredient
extends Ingredient {
    public static final ResourceLocation TYPE = GTCEu.id("sized");
    protected final int amount;
    protected final Ingredient inner;
    protected ItemStack[] itemStacks = null;

    protected SizedIngredient(Ingredient inner, int amount) {
        super(Stream.empty());
        this.amount = amount;
        this.inner = inner;
    }

    protected SizedIngredient(@NotNull TagKey<Item> tag, int amount) {
        this(Ingredient.m_204132_(tag), amount);
    }

    protected SizedIngredient(ItemStack itemStack) {
        this(itemStack.m_41782_() || itemStack.m_41773_() > 0 ? NBTIngredient.createNBTIngredient(itemStack) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}), itemStack.m_41613_());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SizedIngredient create(ItemStack inner) {
        return SizedIngredientImpl.create(inner);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SizedIngredient create(Ingredient inner, int amount) {
        void var1_1;
        return SizedIngredientImpl.create(inner, (int)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SizedIngredient create(Ingredient inner) {
        return SizedIngredientImpl.create(inner);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SizedIngredient create(TagKey<Item> tag, int amount) {
        void var1_1;
        return SizedIngredientImpl.create(tag, (int)var1_1);
    }

    public static SizedIngredient copy(Ingredient ingredient) {
        if (ingredient instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
            SizedIngredient copied = SizedIngredient.create(sizedIngredient.inner, sizedIngredient.amount);
            if (sizedIngredient.itemStacks != null) {
                copied.itemStacks = (ItemStack[])Arrays.stream(sizedIngredient.itemStacks).map(ItemStack::m_41777_).toArray(ItemStack[]::new);
            }
            return copied;
        }
        return SizedIngredient.create(ingredient);
    }

    public int getAmount() {
        return this.amount;
    }

    public Ingredient getInner() {
        return this.inner;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SizedIngredient fromJson(JsonObject json) {
        return SizedIngredientImpl.fromJson(json);
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.addProperty("fabric:type", TYPE.toString());
        json.addProperty("count", (Number)this.amount);
        json.add("ingredient", this.inner.m_43942_());
        return json;
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.inner.test(stack);
    }

    public ItemStack @NotNull [] m_43908_() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.inner.m_43908_()).map(i -> {
                ItemStack ic = i.m_41777_();
                ic.m_41764_(this.amount);
                return ic;
            }).toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @NotNull
    public IntList m_43931_() {
        return this.inner.m_43931_();
    }

    public boolean m_43947_() {
        return this.inner.m_43947_();
    }
}

