/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.json.SimpleIGuiTextureJsonUtils;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CompassSection {
    private final ResourceLocation sectionID;
    private Supplier<IGuiTexture> icon = () -> IGuiTexture.EMPTY;
    @Nullable
    private Supplier<IGuiTexture> background = null;
    private int priority = 99;
    private String lang;

    private CompassSection(String section) {
        this.sectionID = GTCEu.id(section);
        this.lang = FormattingUtil.toEnglishName(section);
    }

    public static CompassSection create(String section) {
        return new CompassSection(section);
    }

    public CompassSection register() {
        GTRegistries.COMPASS_SECTIONS.register(this.sectionID, this);
        return this;
    }

    public String getUnlocalizedKey() {
        return this.sectionID.m_214296_("compass.section");
    }

    public ResourceLocation sectionID() {
        return this.sectionID;
    }

    public CompassSection icon(Supplier<IGuiTexture> icon) {
        this.icon = icon;
        return this;
    }

    public CompassSection background(@Nullable Supplier<IGuiTexture> background) {
        this.background = background;
        return this;
    }

    public CompassSection priority(int priority) {
        this.priority = priority;
        return this;
    }

    public CompassSection lang(String lang) {
        this.lang = lang;
        return this;
    }

    public String lang() {
        return this.lang;
    }

    public static class CompassSectionProvider
    implements DataProvider {
        private final PackOutput output;
        private final Predicate<ResourceLocation> existingHelper;

        public CompassSectionProvider(PackOutput output, Predicate<ResourceLocation> existingHelper) {
            this.output = output;
            this.existingHelper = existingHelper;
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return this.generate(this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("gtceu"), cache);
        }

        public String m_6055_() {
            return "GTCEU's Compass Sections";
        }

        public CompletableFuture<?> generate(Path path, CachedOutput cache) {
            return CompletableFuture.allOf((CompletableFuture[])GTRegistries.COMPASS_SECTIONS.values().stream().map(section -> {
                String resourcePath = "compass/sections/" + section.sectionID.m_135815_() + ".json";
                if (this.existingHelper.test(GTCEu.id(resourcePath))) {
                    return null;
                }
                JsonObject json = new JsonObject();
                json.add("button_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson((IGuiTexture)section.icon.get()));
                if (section.background != null) {
                    json.add("background_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson((IGuiTexture)section.background.get()));
                }
                json.addProperty("priority", (Number)section.priority);
                return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path.resolve(resourcePath));
            }).filter(Objects::nonNull).toArray(CompletableFuture[]::new));
        }
    }
}

