/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.forge;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.client.ClientCommands;
import com.gregtechceu.gtceu.client.TooltipHelper;
import com.gregtechceu.gtceu.client.TooltipsHandler;
import com.gregtechceu.gtceu.client.renderer.BlockHighLightRenderer;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gtceu", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ForgeClientEventListener {
    @SubscribeEvent
    public static void registerItemStackCapabilities(RenderHighlightEvent.Block event) {
        BlockHighLightRenderer.renderBlockHighLight(event.getPoseStack(), event.getCamera(), event.getTarget(), event.getMultiBufferSource(), event.getPartialTick());
    }

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent event) {
        TooltipsHandler.appendTooltips(event.getItemStack(), event.getFlags(), event.getToolTip());
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        List commands = ClientCommands.createClientCommands();
        commands.forEach(arg_0 -> ((CommandDispatcher)dispatcher).register(arg_0));
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TooltipHelper.onClientTick();
            ++GTValues.CLIENT_TIME;
        }
    }
}

