/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.utils.ResourceHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WorkableOverlayModel {
    protected final ResourceLocation location;
    @OnlyIn(value=Dist.CLIENT)
    public Map<OverlayFace, ActivePredicate> sprites;
    @OnlyIn(value=Dist.CLIENT)
    public Table<Direction, Direction, List<BakedQuad>[][]> caches;

    public WorkableOverlayModel(ResourceLocation location) {
        this.location = location;
        if (LDLib.isClient()) {
            this.sprites = new EnumMap<OverlayFace, ActivePredicate>(OverlayFace.class);
            this.caches = Tables.newCustomTable(new EnumMap(Direction.class), () -> new EnumMap(Direction.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction side, Direction frontFacing, boolean isActive, boolean isWorkingEnabled) {
        Table<Direction, Direction, List<BakedQuad>[][]> table = this.caches;
        synchronized (table) {
            if (side == null) {
                return Collections.emptyList();
            }
            if (!this.caches.contains((Object)side, (Object)frontFacing)) {
                this.caches.put((Object)side, (Object)frontFacing, (Object)new List[2][2]);
            }
            List[][] cache = (List[][])this.caches.get((Object)side, (Object)frontFacing);
            assert (cache != null);
            if (cache[isActive ? 0 : 1][isWorkingEnabled ? 0 : 1] == null) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                for (Direction renderSide : Direction.values()) {
                    BakedQuad quad;
                    ModelState rotation = ModelFactory.getRotation((Direction)frontFacing);
                    ActivePredicate predicate = this.sprites.get((Object)OverlayFace.bySide(renderSide));
                    if (predicate == null) continue;
                    TextureAtlasSprite texture = predicate.getSprite(isActive, isWorkingEnabled);
                    if (texture != null && (quad = FaceQuad.bakeFace((AABB)FaceQuad.BLOCK, (Direction)renderSide, (TextureAtlasSprite)texture, (ModelState)rotation, (int)-1, (int)0, (boolean)true, (boolean)true)).m_111306_() == side) {
                        quads.add(quad);
                    }
                    if ((texture = predicate.getEmissiveSprite(isActive, isWorkingEnabled)) == null) continue;
                    if (ConfigHolder.INSTANCE.client.machinesEmissiveTextures) {
                        quad = FaceQuad.bakeFace((AABB)FaceQuad.BLOCK, (Direction)renderSide, (TextureAtlasSprite)texture, (ModelState)rotation, (int)-101, (int)15, (boolean)true, (boolean)false);
                        if (quad.m_111306_() != side) continue;
                        quads.add(quad);
                        continue;
                    }
                    quad = FaceQuad.bakeFace((AABB)FaceQuad.BLOCK, (Direction)renderSide, (TextureAtlasSprite)texture, (ModelState)rotation, (int)-1, (int)0, (boolean)true, (boolean)true);
                    if (quad.m_111306_() != side) continue;
                    quads.add(quad);
                }
                cache[isActive ? 0 : 1][isWorkingEnabled ? 0 : 1] = quads;
            }
            return cache[isActive ? 0 : 1][isWorkingEnabled ? 0 : 1];
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        for (ActivePredicate predicate : this.sprites.values()) {
            TextureAtlasSprite sprite = predicate.getSprite(false, false);
            if (sprite == null) continue;
            return sprite;
        }
        return ModelFactory.getBlockSprite((ResourceLocation)MissingTextureAtlasSprite.m_118071_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        IItemRendererProvider.disabled.set(true);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (state, direction, random) -> this.bakeQuads(direction, Direction.NORTH, false, false));
        IItemRendererProvider.disabled.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public void registerTextureAtlas(Consumer<ResourceLocation> register) {
        this.sprites.clear();
        OverlayFace[] overlayFaceArray = this.caches;
        synchronized (this.caches) {
            this.caches.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (OverlayFace overlayFace : OverlayFace.VALUES) {
                String overlayPath = "/overlay_" + overlayFace.name().toLowerCase(Locale.ROOT);
                ResourceLocation normalSprite = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + overlayPath);
                if (!ResourceHelper.isTextureExist((ResourceLocation)normalSprite)) continue;
                register.accept(normalSprite);
                String active = String.format("%s_active", overlayPath);
                ResourceLocation activeSprite = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + active);
                if (ResourceHelper.isTextureExist((ResourceLocation)activeSprite)) {
                    register.accept(activeSprite);
                } else {
                    activeSprite = normalSprite;
                }
                String paused = String.format("%s_paused", overlayPath);
                ResourceLocation pausedSprite = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + paused);
                if (ResourceHelper.isTextureExist((ResourceLocation)pausedSprite)) {
                    register.accept(pausedSprite);
                } else {
                    pausedSprite = normalSprite;
                }
                ResourceLocation normalSpriteEmissive = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + "_emissive");
                if (ResourceHelper.isTextureExist((ResourceLocation)normalSpriteEmissive)) {
                    register.accept(normalSpriteEmissive);
                } else {
                    normalSpriteEmissive = null;
                }
                ResourceLocation activeSpriteEmissive = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + active + "_emissive");
                if (ResourceHelper.isTextureExist((ResourceLocation)activeSpriteEmissive)) {
                    register.accept(activeSpriteEmissive);
                } else {
                    activeSpriteEmissive = null;
                }
                ResourceLocation pausedSpriteEmissive = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + paused + "_emissive");
                if (ResourceHelper.isTextureExist((ResourceLocation)pausedSpriteEmissive)) {
                    register.accept(pausedSpriteEmissive);
                } else {
                    pausedSpriteEmissive = null;
                }
                this.sprites.put(overlayFace, new ActivePredicate(normalSprite, activeSprite, pausedSprite, normalSpriteEmissive, activeSpriteEmissive, pausedSpriteEmissive));
            }
            return;
        }
    }

    public static enum OverlayFace {
        FRONT,
        BACK,
        TOP,
        BOTTOM,
        SIDE;

        public static final OverlayFace[] VALUES;

        public static OverlayFace bySide(Direction side) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> BOTTOM;
                case Direction.UP -> TOP;
                case Direction.NORTH -> FRONT;
                case Direction.SOUTH -> BACK;
                case Direction.WEST, Direction.EAST -> SIDE;
            };
        }

        static {
            VALUES = OverlayFace.values();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ActivePredicate {
        private final ResourceLocation normalSprite;
        private final ResourceLocation activeSprite;
        private final ResourceLocation pausedSprite;
        private final ResourceLocation normalSpriteEmissive;
        private final ResourceLocation activeSpriteEmissive;
        private final ResourceLocation pausedSpriteEmissive;

        public ActivePredicate(@Nullable ResourceLocation normalSprite, @Nullable ResourceLocation activeSprite, @Nullable ResourceLocation pausedSprite, @Nullable ResourceLocation normalSpriteEmissive, @Nullable ResourceLocation activeSpriteEmissive, @Nullable ResourceLocation pausedSpriteEmissive) {
            this.normalSprite = normalSprite;
            this.activeSprite = activeSprite;
            this.pausedSprite = pausedSprite;
            this.normalSpriteEmissive = normalSpriteEmissive;
            this.activeSpriteEmissive = activeSpriteEmissive;
            this.pausedSpriteEmissive = pausedSpriteEmissive;
        }

        @Nullable
        public TextureAtlasSprite getSprite(boolean active, boolean workingEnabled) {
            return this.getTextureAtlasSprite(active, workingEnabled, this.activeSprite, this.pausedSprite, this.normalSprite);
        }

        @Nullable
        public TextureAtlasSprite getEmissiveSprite(boolean active, boolean workingEnabled) {
            return this.getTextureAtlasSprite(active, workingEnabled, this.activeSpriteEmissive, this.pausedSpriteEmissive, this.normalSpriteEmissive);
        }

        @Nullable
        private TextureAtlasSprite getTextureAtlasSprite(boolean active, boolean workingEnabled, @Nullable ResourceLocation activeSprite, @Nullable ResourceLocation pausedSprite, @Nullable ResourceLocation normalSprite) {
            if (active) {
                if (workingEnabled) {
                    return activeSprite == null ? null : ModelFactory.getBlockSprite((ResourceLocation)activeSprite);
                }
                if (pausedSprite != null) {
                    return ModelFactory.getBlockSprite((ResourceLocation)pausedSprite);
                }
            }
            return normalSprite == null ? null : ModelFactory.getBlockSprite((ResourceLocation)normalSprite);
        }
    }
}

