/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.google.common.base.Suppliers;
import com.gregtechceu.gtceu.client.model.ItemBakedModel;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.impl.BlockStateRenderer;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class OreBlockRenderer
extends BlockStateRenderer {
    private final Supplier<BlockState> stone = Suppliers.memoize(stone::get);
    private final Supplier<ResourceLocation> overlaySupplier;
    private final Supplier<@Nullable ResourceLocation> secondaryOverlaySupplier;
    private final boolean emissive;

    public OreBlockRenderer(Supplier<BlockState> stone, Supplier<ResourceLocation> overlaySupplier, Supplier<@Nullable ResourceLocation> secondaryOverlaySupplier, boolean emissive) {
        this.overlaySupplier = overlaySupplier;
        this.secondaryOverlaySupplier = secondaryOverlaySupplier;
        this.emissive = emissive;
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    public BlockInfo getBlockInfo() {
        return new BlockInfo(this.stone.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        super.renderItem(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, model);
        IItemRendererProvider.disabled.set(true);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (BakedModel)new ItemBakedModel(){

            @OnlyIn(value=Dist.CLIENT)
            public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                if (direction != null) {
                    quads.add(FaceQuad.bakeFace((Direction)direction, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)OreBlockRenderer.this.overlaySupplier.get()), (ModelState)BlockModelRotation.X0_Y0, (int)(OreBlockRenderer.this.emissive ? -101 : 0), (int)(OreBlockRenderer.this.emissive ? 15 : 0), (boolean)true, (!OreBlockRenderer.this.emissive ? 1 : 0) != 0));
                    if (OreBlockRenderer.this.secondaryOverlaySupplier.get() != null) {
                        quads.add(FaceQuad.bakeFace((Direction)direction, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)OreBlockRenderer.this.secondaryOverlaySupplier.get()), (ModelState)BlockModelRotation.X0_Y0, (int)(OreBlockRenderer.this.emissive ? -111 : 1), (int)(OreBlockRenderer.this.emissive ? 15 : 0), (boolean)true, (!OreBlockRenderer.this.emissive ? 1 : 0) != 0));
                    }
                }
                return quads;
            }
        });
        IItemRendererProvider.disabled.set(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> renderModel(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(super.renderModel(level, pos, state, side, rand));
        if (side != null) {
            quads.add(FaceQuad.bakeFace((Direction)side, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)this.overlaySupplier.get()), (ModelState)BlockModelRotation.X0_Y0, (int)(this.emissive ? -101 : 0), (int)(this.emissive ? 15 : 0), (boolean)true, (!this.emissive ? 1 : 0) != 0));
            if (this.secondaryOverlaySupplier.get() != null) {
                quads.add(FaceQuad.bakeFace((Direction)side, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)this.secondaryOverlaySupplier.get()), (ModelState)BlockModelRotation.X0_Y0, (int)(this.emissive ? -111 : 1), (int)(this.emissive ? 15 : 0), (boolean)true, (!this.emissive ? 1 : 0) != 0));
            }
        }
        return quads;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)InventoryMenu.f_39692_)) {
            register.accept(this.overlaySupplier.get());
            if (this.secondaryOverlaySupplier.get() != null) {
                register.accept(this.secondaryOverlaySupplier.get());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useAO() {
        BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
        BakedModel model = brd.m_110910_(this.stone.get());
        return model.m_7541_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
        BakedModel model = brd.m_110910_(this.stone.get());
        return model.m_7547_();
    }
}

