/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.cover;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ICoverableRenderer
extends IRenderer {
    @OnlyIn(value=Dist.CLIENT)
    default public List<BakedQuad> renderModel(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand) {
        ICoverable coverable;
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = level == null ? null : level.m_7702_(pos);
        if (blockEntity != null && (coverable = GTCapabilityHelper.getCoverable(blockEntity.m_58904_(), blockEntity.m_58899_(), null)) != null) {
            LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
            ModelState modelState = ModelFactory.getRotation((Direction)coverable.getFrontFacing());
            Direction modelFacing = side == null ? null : ModelFactory.modelFacing((Direction)side, (Direction)coverable.getFrontFacing());
            this.renderCovers(quads, side, rand, coverable, modelFacing, modelState);
            return quads;
        }
        return super.renderModel(level, pos, state, side, rand);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderCovers(List<BakedQuad> quads, @Nullable Direction side, RandomSource rand, @Nonnull ICoverable coverable, @Nullable Direction modelFacing, ModelState modelState) {
        double thickness = coverable.getCoverPlateThickness();
        for (Direction face : Direction.values()) {
            CoverBehavior cover = coverable.getCoverAtSide(face);
            if (cover == null) continue;
            if (thickness > 0.0 && cover.shouldRenderPlate()) {
                double min = thickness;
                double max = 1.0 - thickness;
                Vec3i normal = face.m_122436_();
                AABB cube = new AABB(normal.m_123341_() == 0 ? 0.001 : (normal.m_123341_() > 0 ? max : 0.001), normal.m_123342_() == 0 ? 0.001 : (normal.m_123342_() > 0 ? max : 0.001), normal.m_123343_() == 0 ? 0.001 : (normal.m_123343_() > 0 ? max : 0.001), normal.m_123341_() == 0 ? 0.999 : (normal.m_123341_() > 0 ? 0.999 : min), normal.m_123342_() == 0 ? 0.999 : (normal.m_123342_() > 0 ? 0.999 : min), normal.m_123343_() == 0 ? 0.999 : (normal.m_123343_() > 0 ? 0.999 : min));
                if (side == null) {
                    quads.add(FaceQuad.builder((Direction)face.m_122424_(), (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)GTCEu.id("block/material_sets/dull/wire_side"))).cube(cube).cubeUV().tintIndex(-1).bake());
                } else if (side != face.m_122424_()) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)GTCEu.id("block/material_sets/dull/wire_side"))).cube(cube).cubeUV().tintIndex(-1).bake());
                }
            }
            cover.getCoverRenderer().renderCover(quads, side, rand, cover, modelFacing, modelState);
        }
    }
}

