/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.machine.electric.ChargerMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ChargerRenderer
extends TieredHullMachineRenderer {
    public static final ResourceLocation CHARGER_IDLE = GTCEu.id("block/machines/charger/overlay_charger_idle");
    public static final ResourceLocation CHARGER_RUNNING = GTCEu.id("block/machines/charger/overlay_charger_running");
    public static final ResourceLocation CHARGER_RUNNING_EMISSIVE = GTCEu.id("block/machines/charger/overlay_charger_running_emissive");
    public static final ResourceLocation CHARGER_FINISHED = GTCEu.id("block/machines/charger/overlay_charger_finished");
    public static final ResourceLocation CHARGER_FINISHED_EMISSIVE = GTCEu.id("block/machines/charger/overlay_charger_finished_emissive");

    public ChargerRenderer(int tier) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        ChargerMachine.State state = ChargerMachine.State.IDLE;
        if (machine instanceof ChargerMachine) {
            ChargerMachine charger = (ChargerMachine)machine;
            state = charger.getState();
        }
        if (side == frontFacing && modelFacing != null) {
            ArrayList<BakedQuad> bakedFaces = new ArrayList<BakedQuad>();
            switch (state) {
                case IDLE: {
                    bakedFaces.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)CHARGER_IDLE), (ModelState)modelState, (int)-1, (int)0, (boolean)false, (boolean)true));
                    break;
                }
                case RUNNING: {
                    bakedFaces.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)CHARGER_RUNNING), (ModelState)modelState, (int)-1, (int)0, (boolean)true, (boolean)true));
                    if (!ConfigHolder.INSTANCE.client.machinesEmissiveTextures) break;
                    bakedFaces.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)CHARGER_RUNNING_EMISSIVE), (ModelState)modelState, (int)-101, (int)15, (boolean)true, (boolean)false));
                    break;
                }
                case FINISHED: {
                    bakedFaces.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)CHARGER_FINISHED), (ModelState)modelState, (int)-1, (int)0, (boolean)true, (boolean)true));
                    if (!ConfigHolder.INSTANCE.client.machinesEmissiveTextures) break;
                    bakedFaces.add(FaceQuad.bakeFace((Direction)modelFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)CHARGER_FINISHED_EMISSIVE), (ModelState)modelState, (int)-101, (int)15, (boolean)true, (boolean)false));
                }
            }
            quads.addAll(bakedFaces);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(CHARGER_IDLE);
            register.accept(CHARGER_RUNNING);
            register.accept(CHARGER_RUNNING_EMISSIVE);
            register.accept(CHARGER_FINISHED);
            register.accept(CHARGER_FINISHED_EMISSIVE);
        }
    }
}

