/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.common.data.GTBlockEntities;
import com.gregtechceu.gtceu.common.pipelike.cable.CableData;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.gregtechceu.gtceu.common.pipelike.cable.LevelEnergyNet;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CableBlock
extends MaterialPipeBlock<Insulation, CableData, LevelEnergyNet> {
    public CableBlock(BlockBehaviour.Properties properties, Insulation insulation, Material material) {
        super(properties, insulation, material);
    }

    @Override
    public int tinted(BlockState blockState, @Nullable BlockAndTintGetter blockAndTintGetter, @Nullable BlockPos blockPos, int index) {
        if (((Insulation)this.pipeType).isCable && index == 0) {
            return 0x404040;
        }
        return index == 0 || index == 1 ? this.material.getMaterialRGB() : -1;
    }

    @Override
    protected CableData createMaterialData() {
        return new CableData(this.material.getProperty(PropertyKey.WIRE), 0);
    }

    @Override
    public LevelEnergyNet getWorldPipeNet(ServerLevel level) {
        return LevelEnergyNet.getOrCreate(level);
    }

    @Override
    public BlockEntityType<? extends PipeBlockEntity<Insulation, CableData>> getBlockEntityType() {
        return (BlockEntityType)GTBlockEntities.CABLE.get();
    }

    @Override
    protected PipeModel createPipeModel() {
        return ((Insulation)this.pipeType).createPipeModel(this.material);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        WireProperties wireProperties = ((Insulation)this.pipeType).modifyProperties((CableData)this.createRawData(this.m_49966_(), stack)).properties();
        byte tier = GTUtil.getTierByVoltage(wireProperties.getVoltage());
        if (wireProperties.isSuperconductor()) {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.cable.superconductor", (Object[])new Object[]{GTValues.VN[tier]}));
        }
        tooltip.add((Component)Component.m_237110_((String)"gtceu.cable.voltage", (Object[])new Object[]{wireProperties.getVoltage(), GTValues.VNF[tier]}));
        tooltip.add((Component)Component.m_237110_((String)"gtceu.cable.amperage", (Object[])new Object[]{wireProperties.getAmperage()}));
        tooltip.add((Component)Component.m_237110_((String)"gtceu.cable.loss_per_block", (Object[])new Object[]{wireProperties.getLossPerBlock()}));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }
}

