/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.common.data.GTBlockEntities;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeData;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.LevelFluidPipeNet;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidPipeBlock
extends MaterialPipeBlock<FluidPipeType, FluidPipeData, LevelFluidPipeNet> {
    public FluidPipeBlock(BlockBehaviour.Properties properties, FluidPipeType fluidPipeType, Material material) {
        super(properties, fluidPipeType, material);
    }

    @Override
    protected FluidPipeData createMaterialData() {
        return new FluidPipeData(this.material.getProperty(PropertyKey.FLUID_PIPE), 0);
    }

    @Override
    public LevelFluidPipeNet getWorldPipeNet(ServerLevel level) {
        return LevelFluidPipeNet.getOrCreate(level);
    }

    @Override
    public BlockEntityType<? extends PipeBlockEntity<FluidPipeType, FluidPipeData>> getBlockEntityType() {
        return (BlockEntityType)GTBlockEntities.FLUID_PIPE.get();
    }

    @Override
    protected PipeModel createPipeModel() {
        return ((FluidPipeType)this.pipeType).createPipeModel(this.material);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        FluidPipeProperties properties = ((FluidPipeType)this.pipeType).modifyProperties((FluidPipeData)this.createRawData(this.m_49966_(), stack)).properties();
        tooltip.add((Component)Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{properties.getThroughput()}));
        tooltip.add((Component)Component.m_237110_((String)"gtceu.fluid_pipe.max_temperature", (Object[])new Object[]{properties.getMaxFluidTemperature()}));
        if (properties.getChannels() > 1) {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.fluid_pipe.channels", (Object[])new Object[]{properties.getChannels()}));
        }
        if (!GTUtil.isShiftDown()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.tooltip.fluid_pipe_hold_shift"));
            return;
        }
        if (properties.isGasProof()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.gas_proof"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.not_gas_proof"));
        }
        if (properties.isAcidProof()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.acid_proof"));
        }
        if (properties.isCryoProof()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.cryo_proof"));
        }
        if (properties.isPlasmaProof()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.plasma_proof"));
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }
}

