/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity.forge;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeData;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeNet;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.PipeNetRoutePath;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidTransferHelperImpl;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidPipeBlockEntityImpl
extends FluidPipeBlockEntity {
    public FluidPipeBlockEntityImpl(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static FluidPipeBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new FluidPipeBlockEntityImpl(type, pos, blockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            IFluidHandler handler = this.getFluidHandler(side);
            if (handler != null) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> handler));
            }
        } else {
            if (cap == GTCapability.CAPABILITY_COVERABLE) {
                return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(this::getCoverContainer));
            }
            if (cap == GTCapability.CAPABILITY_TOOLABLE) {
                return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> this));
            }
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        if (side != null && this.isBlocked(side)) {
            return null;
        }
        if (this.isRemote()) {
            return EmptyFluidHandler.INSTANCE;
        }
        FluidPipeNet net = this.getFluidPipeNet();
        if (net != null) {
            return new FluidPipeHandler(net, this, side);
        }
        return null;
    }

    public static IFluidTransfer getNetHandler(FluidPipeBlockEntity pipe, @Nullable Direction side) {
        return FluidTransferHelperImpl.toFluidTransfer((IFluidHandler)((FluidPipeBlockEntityImpl)pipe).getFluidHandler(side));
    }

    public static void onBlockEntityRegister(BlockEntityType<FluidPipeBlockEntity> cableBlockEntityBlockEntityType) {
    }

    class FluidPipeHandler
    implements IFluidHandler {
        private final FluidPipeNet net;
        private final FluidPipeBlockEntity pipe;
        private final List<PipeNetRoutePath> paths;
        @Nullable
        private final Direction side;
        private Predicate<FluidStack> filter = fluid -> true;

        public FluidPipeHandler(FluidPipeNet net, @Nullable FluidPipeBlockEntity pipe, Direction side) {
            CoverBehavior coverBehavior;
            this.net = Objects.requireNonNull(net);
            this.pipe = Objects.requireNonNull(pipe);
            this.paths = net.getNetData(pipe.getPipePos());
            this.side = side;
            if (side != null && (coverBehavior = FluidPipeBlockEntityImpl.this.getCoverContainer().getCoverAtSide(side)) instanceof FluidFilterCover) {
                FluidFilterCover cover = (FluidFilterCover)coverBehavior;
                this.filter = f -> cover.getFluidFilter().test(FluidHelperImpl.toFluidStack((FluidStack)f));
            }
        }

        public int getTanks() {
            FluidPipeProperties properties = ((FluidPipeData)this.net.getNodeAt((BlockPos)this.pipe.getPipePos()).data).properties();
            return properties.getChannels();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            Fluid fluid = this.net.getFluid(this.pipe.getPipePos(), tank);
            if (fluid == null) {
                return FluidStack.EMPTY;
            }
            return new FluidStack(fluid, (int)this.net.getLastSecondTotalThroughput(this.pipe.getPipePos(), tank));
        }

        public int getTankCapacity(int tank) {
            FluidPipeProperties properties = ((FluidPipeData)this.net.getNodeAt((BlockPos)this.pipe.getPipePos()).data).properties();
            if (tank < 0 || tank > properties.getChannels()) {
                return 0;
            }
            long pipeThroughput = properties.getPlatformThroughput();
            return (int)(20L * pipeThroughput);
        }

        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
            return FluidStack.EMPTY;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.filter.test(stack);
        }

        private int checkPathAvailable(FluidStack stack, PipeNetRoutePath routePath, Map<BlockPos, Set<Fluid>> simulateChannelUsed, Object2LongMap<BlockPos> simulateThroughputUsed) {
            if (stack.isEmpty()) {
                return 0;
            }
            int amount = stack.getAmount();
            for (Pair<BlockPos, FluidPipeData> node : routePath.getPath()) {
                FluidPipeProperties properties = ((FluidPipeData)node.getB()).properties();
                BlockPos pos = (BlockPos)node.getA();
                if (!properties.test(FluidHelperImpl.toFluidStack((FluidStack)stack))) {
                    return 0;
                }
                int maxChannel = properties.getChannels() - 1;
                int channel = this.net.getChannel(pos, stack.getFluid());
                Set simulateChannels = simulateChannelUsed.getOrDefault(pos, Collections.emptySet());
                if (!(channel != -1 && channel <= maxChannel || simulateChannels.contains(stack.getFluid()) || (channel = this.net.useChannel(pos, stack.getFluid())) != -1 && channel <= maxChannel)) {
                    return 0;
                }
                long platformThroughputPerSecond = 20L * properties.getPlatformThroughput();
                long left = platformThroughputPerSecond - this.net.getLastSecondTotalThroughput(pos, channel) - simulateThroughputUsed.getOrDefault((Object)pos, 0L);
                if ((amount = (int)Math.min((long)amount, left)) > 0) continue;
                return 0;
            }
            return amount;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction fluidAction) {
            if (resource.isEmpty() || !this.filter.test(resource)) {
                return 0;
            }
            FluidStack left = resource.copy();
            HashMap<BlockPos, Set<Fluid>> simulateChannelUsed = new HashMap<BlockPos, Set<Fluid>>();
            Object2LongOpenHashMap simulateThroughputUsed = new Object2LongOpenHashMap();
            for (PipeNetRoutePath path : this.paths) {
                FluidFilterCover cover;
                CoverBehavior coverBehavior;
                IFluidHandler handler;
                BlockEntity blockEntity;
                if (Objects.equals(this.pipe.getPipePos(), path.getPipePos()) && (this.side == path.getFaceToHandler() || this.side == null) || (blockEntity = this.pipe.getPipeLevel().m_7702_(path.getHandlerPos())) == null || (handler = (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, path.getFaceToHandler().m_122424_()).resolve().orElse(null)) == null) continue;
                ICoverable coverable = GTCapabilityHelper.getCoverable((Level)this.net.getLevel(), path.getPipePos(), null);
                if (coverable != null && (coverBehavior = coverable.getCoverAtSide(path.getFaceToHandler())) instanceof FluidFilterCover && !(cover = (FluidFilterCover)coverBehavior).getFluidFilter().test(FluidHelperImpl.toFluidStack((FluidStack)resource))) {
                    return 0;
                }
                int accepted = this.checkPathAvailable(left, path, simulateChannelUsed, (Object2LongMap<BlockPos>)simulateThroughputUsed);
                if (accepted <= 0) continue;
                FluidStack copied = left.copy();
                copied.setAmount(accepted);
                int filled = handler.fill(copied, fluidAction);
                if (filled > 0) {
                    for (Pair<BlockPos, FluidPipeData> node : path.getPath()) {
                        BlockPos pos = (BlockPos)node.getA();
                        if (fluidAction.simulate()) {
                            simulateThroughputUsed.put((Object)pos, simulateThroughputUsed.getOrDefault((Object)pos, 0L) + (long)filled);
                            simulateChannelUsed.computeIfAbsent(pos, p -> new HashSet()).add(resource.getFluid());
                            continue;
                        }
                        int channel = this.net.getChannel(pos, resource.getFluid());
                        if (channel == -1) continue;
                        this.net.useThroughput(pos, channel, filled);
                    }
                }
                left.shrink(filled);
                if (!left.isEmpty()) continue;
                break;
            }
            return resource.getAmount() - left.getAmount();
        }

        public void setFilter(Predicate<FluidStack> filter) {
            this.filter = filter;
        }
    }
}

